#############################################################################
##
##  This file is part of GAP, a system for computational discrete algebra.
##  This file's authors include Stefan Kohl, Alexander Hulpke.
##
##  Copyright of GAP belongs to its developers, whose names are too numerous
##  to list here. Please refer to the COPYRIGHT file for details.
##
##  SPDX-License-Identifier: GPL-2.0-or-later
##
##  This file contains basic constructions for simple groups of bounded size,
##  if necessary by calling the `atlasrep' package.
##

return [
# last one was: [911215823217986880,"S",4,67],
[1053927211015007280,"L",3,179],
[1148120010326016000,"L",4,16],[1148680752699801600,"U",4,16],
[1151901690253488720,"U",3,181],[1152639960927436800,"S",4,64],
[1216451004088320000,"A",20,0],[1309569604744237200,"L",3,211],
[1426532459730094080,"U",4,17],[1627298834701881600,"S",4,71],
[1771148480238009600,"L",3,191],[1925071538156421888,"U",3,193],
[2038491369977715072,"L",3,223],[2148409609152917760,"S",4,73],
[2268394375519042848,"L",3,197],[2350050591084975072,"U",3,227],
[2459312399784240000,"U",3,199],[2520892267783947360,"L",3,229],
[2895463856362442976,"U",3,233],[3548578210896499200,"U",3,239],
[3785291261439408000,"U",4,19],[3793216031663731200,"L",3,241],
[3928709650668327840,"U",3,211],[4089470473293004800,"Fi",23,0],
[4157776806543360000,"Co",1,0],[4733379365384217600,"S",4,79],
[5251237383047292000,"U",3,251],[5348063769211699200,"L",8,2],
[6077906078240793600,"S",4,81],[6115475212857120768,"U",3,223],
[6148820499745996800,"L",3,256],[6343620327977167872,"U",3,257],
[7050150567800339568,"L",3,227],[7434971050829414400,"U",8,2],
[7562678062854608400,"U",3,229],[7568375355962524800,"L",4,19],
[7629893540021022336,"U",3,263],[7756894284040399680,"S",4,83],
[8686390195672914816,"L",3,233],[8911539000000000000,"O+",8,5],
[9077005607176765440,"S",6,8],[9138838566869398800,"U",3,269],
[9696770944479892800,"L",3,271],[10645733073094271040,"L",3,239],
[11379649720943232960,"U",3,241],[11553437444371484256,"L",3,277],
[11570921621943780096,"G",2,23],[12157458720650573616,"L",3,243],
[12157460415199094688,"U",3,243],[12957577765142603040,"U",3,281],
[13714020288713860272,"L",3,283],[15588891422120966400,"S",4,89],
[15753710156672250000,"L",3,251],[16220202412486625280,"L",3,289],
[17880203250000000000,"O-",8,5],[18105672752409752496,"U",3,293],
[18446463698227691520,"U",3,256],[19030858741655666688,"L",3,257],
[22889678103531054816,"L",3,263],[25545471085854720000,"A",21,0],
[26301536862878881296,"L",3,307],[27416512883617621920,"L",3,269],
[29090315756720494080,"U",3,271],[29171407345497406080,"U",3,311],
[30706406751252166272,"L",3,313],[33989794182813256272,"U",3,317],
[34660315594657995216,"U",3,277],[35817806390625000000,"3D",4,5],
[36867287211507486720,"S",4,97],[36888985097480437760,"Sz",8192,0],
[37193298187500000000,"G",2,25],[38872729791492374400,"L",3,281],
[41142064496560573728,"U",3,283],[48028466418260050800,"L",3,331],
[48660611269399401600,"U",3,289],[50027557148216524800,"O+",12,2],
[51615733565620224000,"O-",12,2],[54025731402499584000,"S",6,9],
[54025731402499584000,"O",7,9],[54317013938429795616,"L",3,293],
[55225691456324040000,"S",4,101],[55451604473112347136,"L",3,337],
[63859866073149115872,"L",3,343],[66538030303401845760,"U",4,23],
[67189484519829285120,"S",4,103],[70066584416259019872,"U",3,347],
[73363253840420191200,"L",3,349],[78904616042663411616,"U",3,307],
[80366103618623577216,"U",3,353],[86775571046077562880,"J",4,0],
[87514216217772333600,"L",3,311],[91966778431759555200,"U",3,359],
[92119226261996195808,"U",3,313],[96146398040560963200,"L",3,361],
[98348976183279470400,"S",4,107],[101969376146346676128,"L",3,317],
[109268894214173244096,"G",2,27],[109699342879806403776,"L",3,367],
[118358220077917934400,"S",4,109],[124895350133056575072,"L",3,373],
[133054187487045834240,"L",4,23],[141902286557955482160,"L",3,379],
[144085407201099244320,"U",3,331],[154335553603831627776,"U",3,383],
[166354822112457066816,"U",3,337],[169715076234252272640,"S",4,113],
[174772336883957233200,"U",3,389],[187035198320488089600,"L",5,7],
[188151359720376729600,"U",5,7],[191579607714489660288,"U",3,343],
[205683776147019573216,"L",3,397],[210199743187021490448,"L",3,347],
[220089771876343110000,"U",3,349],[222859438592961067200,"U",3,401],
[232442642250000000000,"L",4,25],[241098299893612271616,"L",3,353],
[261013281547286805120,"L",3,409],[275900323369167070560,"L",3,359],
[288439206383721313440,"U",3,361],[297204417392942404800,"G",2,29],
[316656539335219960800,"U",3,419],[328952397367804744800,"L",3,421],
[329098041954907362816,"U",3,367],[336352021032241209600,"S",4,121],
[361310134959341568000,"L",6,4],[374686064839297401168,"U",3,373],
[396912315082968138240,"U",3,431],[411888431554954486272,"L",3,433],
[425706875313372122400,"U",3,379],[459825073131625930080,"L",3,439],
[463006644329077602816,"L",3,383],[464944793625000000000,"U",4,25],
[465631483078125000000,"S",4,125],[494431745246057395296,"U",3,443],
[524316992837310385440,"L",3,389],[545733086821769871360,"S",4,127],
[550614094114805280000,"U",3,449],[562000363888803840000,"A",22,0],
[617051348164367501616,"U",3,397],[634170829913337338496,"L",3,457],
[650084965259666227200,"O-",10,3],[668578295041728960000,"L",3,401],
[679961164963035851280,"U",3,461],[703922169380520670272,"L",3,463],
[737601122106242110080,"U",4,27],[744145143237264225600,"S",4,131],
[754070242372687330272,"U",3,467],[756156271585004236800,"G",2,31],
[783039867531762741600,"U",3,409],[923763851859382732800,"U",3,479],
[949969592177251966320,"L",3,419],[986857218554166289680,"U",3,421],
[1054650590305758978336,"L",3,487],[1120527288631296000000,"U",6,4],
[1125975353876798836320,"U",3,491],[1164534971510960144640,"S",4,137],
[1179438698114366570496,"G",2,32],[1180519558725595299840,"S",4,128],
[1190736915503901998400,"L",3,431],[1235665325106441448128,"U",3,433],
[1281390094998126666000,"L",3,499],[1289512799941305139200,"O+",10,3],
[1346156421658776302400,"S",4,139],[1365906314091499238016,"U",3,503],
[1379475252004843593600,"U",3,439],[1475052355750361431680,"L",4,27],
[1483295201615234441616,"L",3,443],[1501825005112645861200,"U",3,509],
[1574116167885124534272,"U",3,512],[1651842245847215923200,"L",3,449],
[1809584779747544523360,"U",3,521],[1865909884890414825072,"L",3,523],
[1902512529606586115616,"U",3,457],[2039883453247011741600,"L",3,461],
[2044196153210067816960,"L",3,529],[2111766550694830622208,"U",3,463],
[2154640634826571382400,"L",4,29],[2262210682694599351728,"L",3,467],
[2445993955827236959200,"L",3,541],[2671627479423960382416,"L",3,547],
[2696578858044312840000,"S",4,149],[2771291505146208766080,"L",3,479],
[3081203828722599840000,"S",4,151],[3088295931897682633872,"U",3,557],
[3163951825703702994816,"U",3,487],[3364685963221808979936,"U",3,563],
[3377926004556745563600,"L",3,491],[3662482324267435312800,"U",3,569],
[3669292720793456064000,"S",6,11],[3669292720793456064000,"O",7,11],
[3766745489435114986800,"L",3,571],[3844170346871626500000,"U",3,499],
[4095283237861941190656,"L",3,577],[4097718877877116835616,"L",3,503],
[4309634663229463344000,"U",4,29],[4408780839651901440000,"S",8,4],
[4505474947007023404960,"L",3,509],[4549345370434681876800,"S",4,157],
[4638226007491010887680,"L",5,8],[4656663745464977326080,"U",5,8],
[4698749548680295282272,"U",3,587],[4722348433286897860608,"L",3,512],
[5097004995712580508096,"U",3,593],[5428754262468130838400,"L",3,521],
[5524489036078056720000,"U",3,599],[5597729732930705441568,"U",3,523],
[5673790776241944720000,"L",3,601],[5860401476453366169600,"U",4,31],
[6132588542482929806400,"U",3,529],[6143093043788562765696,"L",3,607],
[6619568818424589138240,"S",4,163],[6646016019936318514272,"L",3,613],
[7000981315355734594272,"U",3,617],[7184603444310456441840,"L",3,619],
[7337981960167859714160,"U",3,541],[7761001555125000000000,"L",3,625],
[8014882536213025907616,"U",3,547],[8377463161089132616800,"L",3,631],
[8435661468060475111680,"S",4,167],[9005478340479254536896,"G",2,37],
[9264887688465945129888,"L",3,557],[9500400767995742891520,"U",3,641],
[9502149167487173433600,"S",4,169],[9740146220519358529872,"L",3,643],
[10094057776537299168816,"L",3,563],[10235568162422398303872,"U",3,647],
[10987446853516165710720,"L",3,569],[11020040194046324268816,"U",3,653],
[11300236589702694485280,"U",3,571],[11720016110603234304000,"L",4,31],
[11856624433528512607200,"U",3,659],[12006502733312307120960,"S",4,173],
[12147570428543089135200,"L",3,661],[12285849841496783145216,"U",3,577],
[12926008369442488320000,"A",23,0],[14028082094932835715072,"L",3,673],
[14096248506654858147408,"L",3,587],[14709135496983509745072,"U",3,677],
[15291014840480933807616,"L",3,593],[15775810414207914240000,"U",5,9],
[15784958524593559457376,"U",3,683],[16573466954006287197600,"L",3,599],
[16884443811550651041600,"S",4,179],[17021372485545727202400,"U",3,601],
[17326155722856816733200,"L",3,691],[18429279296171405039616,"U",3,607],
[18868722437568562977600,"S",4,181],[19436676502997148267600,"U",3,701],
[19938048232922565358608,"U",3,613],[21002943767231315987328,"L",3,617],
[21283731011077303194720,"L",3,709],[21553810514684586650400,"U",3,619],
[23283004856109375000000,"U",3,625],[23807238867579208204800,"U",3,719],
[25132389683334508955520,"U",3,631],[26010770027471547173856,"L",3,727],
[27778560269006937058272,"L",3,733],[28501202087556417945600,"L",3,641],
[29220438881386481117088,"U",3,643],[29650597958270123689680,"L",3,739],
[30706704260515594215648,"L",3,647],[30959110175341663840896,"U",3,743],
[32306638466021477990400,"S",4,191],[33060120344676556019616,"L",3,653],
[33728534398831923000000,"L",3,751],[35569873052011327389360,"L",3,659],
[35853489849322432512000,"S",4,193],[35945540838378870412896,"L",3,757],
[36442711537998437234640,"U",3,661],[37493436720175906891680,"U",3,761],
[37740850586690833612800,"L",4,32],[37743154175703357849600,"U",4,32],
[37777778976635853209600,"Sz",32768,0],[37906663696635017491200,"G",2,41],
[40765120304718118256640,"L",3,769],[42084246560922635491968,"U",3,673],
[42492665125819519991856,"U",3,773],[44017064387881039667520,"S",4,197],
[44127406206522500398368,"L",3,677],[47354875276523341188816,"L",3,683],
[48695608961700608160000,"S",4,199],[49054166640212257550736,"L",3,787],
[51978467483649351929760,"U",3,691],[54268102124039619505872,"U",3,797],
[58310029170444263940000,"L",3,701],[61159828007512552543200,"U",3,809],
[62379934995282415081200,"L",3,811],[63851193391543047027600,"U",3,709],
[67034222101339041669120,"L",7,3],[68805532248350540603760,"U",3,821],
[70157932950372102495072,"L",3,823],[71421716218434772605120,"L",3,719],
[72853912155490594652160,"U",7,3],[72932682507877455615072,"U",3,827],
[73845397701659362274496,"G",2,43],[74355715488052299886560,"L",3,829],
[76532479683774853939200,"2E",6,2],[78032310488578455225216,"U",3,727],
[78660280796419613491200,"L",5,9],[79766292776346468190080,"L",3,729],
[79766293188127957538400,"U",3,729],[81841544305045367875200,"U",3,839],
[83298985700006908056960,"L",4,37],[83335681230224125826928,"U",3,733],
[83415373148285834947200,"L",3,841],[87455031824842815470400,"S",4,211],
[88951794315620324637600,"U",3,739],[92877330073155277643616,"L",3,743],
[93426568342574953483872,"L",3,853],[96989502137701361059872,"U",3,857],
[98815134628404192089520,"L",3,859],[101185603674276808128000,"U",3,751],
[102556815849493790017536,"U",3,863],[107836623012310870433616,"U",3,757],
[112480309650078518217600,"L",3,761],[112554991177798901760000,"O+",8,7],
[116647363426192287577056,"L",3,877],[120972165145724096043840,"U",3,881],
[122295361452004091366400,"U",3,769],[122796979335906113871360,"S",6,13],
[122796979335906113871360,"O",7,13],[123186698589040045504272,"L",3,883],
[127477994825474243325216,"L",3,773],[127722424084491170374272,"U",3,887],
[147162500524450463910816,"U",3,787],[152058219656771272642560,"S",4,223],
[152663956400264575530096,"L",3,907],[158133993368877996986880,"U",3,911],
[162804305728956055993248,"L",3,797],[166604549539925370003840,"U",4,37],
[169590812780832306121440,"L",3,919],[181643619764649637028160,"S",4,227],
[183479483329475892773760,"L",3,809],[184928545794594485116800,"U",3,929],
[187139805687518372670240,"U",3,811],[198059180243745239991936,"L",3,937],
[198297183562576584033600,"S",4,229],[204925141084899568651920,"U",3,941],
[206416595999040783770400,"L",3,821],[208114637736580743168000,"S",12,2],
[210473799606258141802368,"U",3,823],[214841575522005575270400,"E",6,2],
[215614564492461130747872,"U",3,947],[218798046749960315437968,"L",3,827],
[223067147247229478684400,"U",3,829],[225297574007560801689600,"O-",8,7],
[226788731931389561440416,"U",3,953],[235787737226765828532480,"S",4,233],
[239189910264352349332632,"R",2187,0],
[242474111088258025267200,"L",3,961],[245524632083680273628640,"L",3,839],
[250246120286270781795360,"U",3,841],[254853189410067695484576,"L",3,967],
[256550794680757953309696,"G",2,47],[263409918762890730468960,"U",3,971],
[264905352699586176614400,"2F",4,8],[276716337248995414875072,"U",3,977],
[280279705930905364989648,"U",3,853],[290607246103480071566976,"U",3,983],
[290968505488547460233088,"L",3,857],[296445404820607968525600,"U",3,859],
[304047481612332847334400,"S",4,239],[307670446591103485362816,"L",3,863],
[310075561273926098851200,"L",3,991],[310224200866619719680000,"A",24,0],
[325416503512287480530016,"L",3,997],[325473292721108444774400,"U",9,2],
[330470694013858246886400,"S",4,241],[349942091316170733975216,"U",3,877],
[358102743438722529784320,"L",3,1009],[358942914910252943265600,"S",4,243],
[362916494375699223590400,"L",3,881],[369560096840696537831328,"U",3,883],
[369618657561800627316336,"U",3,1013],[383167271155359221944608,"L",3,887],
[387500082666841697608800,"U",3,1019],[388537527956978058624000,"L",4,41],
[393626442294296530552800,"L",3,1021],[402974888522408578252800,"L",3,1024],
[425547123637859618279040,"U",3,1031],[432196166102481976390272,"L",3,1033],
[450782974156649555296512,"3D",4,7],[452691899268576388649280,"L",3,1039],
[457991870428419232547616,"U",3,907],[459794955280140305280000,"G",2,49],
[468755520187500000000000,"U",6,5],[474401978851698628785600,"L",3,911],
[488744920171018958580000,"U",3,1049],[496249497450404170830000,"L",3,1051],
[496249778047121469000000,"S",4,251],[508772439653510039702400,"U",3,919],
[535305161648036695132080,"U",3,1061],[543431084666316720586272,"L",3,1063],
[554785635999872770529280,"L",3,929],[568460125429348991286240,"L",3,1069],
[594177542175768679398816,"U",3,937],[614775421779068208669600,"L",3,941],
[628484631394760530329600,"S",4,257],[646843691954104562380848,"L",3,947],
[649702787497620798203136,"L",3,1087],[669077438304764407857120,"U",3,1091],
[678952945897313200075872,"L",3,1093],[680366194222018537247616,"L",3,953],
[699087288328049948779872,"U",3,1097],[699612310033197642547200,"L",9,2],
[727422334904028874755840,"U",3,961],[730268366022246843081216,"U",3,1103],
[762659635731767922985200,"U",3,1109],[764559569921274318930816,"U",3,967],
[777097605973616998156800,"U",4,41],[790229754562334770616400,"L",3,971],
[791628115722608473309440,"S",4,263],[793847777722539895555200,"U",4,43],
[807799875341600226679776,"L",3,1117],[830149009966648664237568,"L",3,977],
[843172533148918306725072,"L",3,1123],[871821736474759542054816,"L",3,983],
[879893155964578850156160,"L",3,1129],[930226685733381835560960,"U",3,991],
[976249512507039920345616,"U",3,997],[991943195156348493729600,"S",4,269],
[1026788525635903259443200,"U",3,1151],[1041148976851014769999872,"L",3,1153],
[1068210885874436031513600,"S",4,271],[1074308232407800180593600,"U",3,1009],
[1108855970551979734614816,"L",3,1013],[1115619617055274442135136,"U",3,1163],
[1162500245803168720843920,"L",3,1019],[1178510859895760354854800,"L",3,1171],
[1180879329101894635972080,"U",3,1021],[1208907372589084783411200,"S",4,256],
[1208924667819023400960000,"U",3,1024],[1255205709190661721292800,"Spor","F3+",0],
[1261471999543114011564240,"U",3,1181],[1276641368583755934194400,"L",3,1031],
[1296588500659954402045728,"U",3,1033],[1313663668444295865826272,"U",3,1187],
[1329725614841651150026560,"S",4,277],[1358075700227356617561600,"U",3,1039],
[1367735091971826122659296,"U",3,1193],[1379455003090649516181696,"G",2,53],
[1383059427750000000000000,"L",6,5],[1442854383333135554880000,"L",3,1201],
[1466234757972627991420800,"L",3,1049],[1488748494915951552679200,"U",3,1051],
[1534714877455424688441600,"S",4,281],[1562301525417624968290272,"L",3,1213],
[1587655617437446720732800,"L",4,43],[1603995251054460990550272,"U",3,1217],
[1605915482255012706573600,"L",3,1061],[1630293256713488213927808,"U",3,1063],
[1647513328786511070070080,"S",4,283],[1668361316271474903152256,"U",3,1223],
[1705380379080064509908400,"U",3,1069],[1734976197844752832822800,"U",3,1229],
[1757692428316918522228800,"L",3,1231],[1827410257190637247434336,"L",3,1237],
[1949108365527992751906816,"U",3,1087],[1952052708565059186240000,"L",5,11],
[1974140115405244151040000,"L",3,1249],[2007232311822906170511600,"L",3,1091],
[2032091372436540797030400,"S",4,289],[2036858840811766094502288,"U",3,1093],
[2097261861806816559128448,"L",3,1097],[2104186899409068138991200,"U",3,1259],
[2190805094801559978791616,"L",3,1103],[2287978903840343562742560,"L",3,1109],
[2331530757174931451899200,"S",4,293],[2357250069842492240565072,"U",3,1277],
[2386947326567063235240960,"L",3,1279],[2423399629502527888872816,"U",3,1117],
[2447325484664957845956576,"U",3,1283],[2529517603018894600203168,"U",3,1123],
[2540398355473026418927200,"U",3,1289],[2572103394967887592729200,"L",3,1291],
[2639679471562328127242400,"U",3,1129],[2669305587750377311228416,"L",3,1297],
[2735878845657964966268400,"U",3,1301],[2769706913019236295067872,"L",3,1303],
[2838462702051029746123872,"U",3,1307],[3014500254733584812482560,"U",4,47],
[3053773768245673230172800,"U",3,1319],[3080365572867477946560000,"L",3,1151],
[3091014462875422200796800,"L",3,1321],[3123446934628500279464448,"U",3,1153],
[3205131713622519467806656,"L",3,1327],[3283242373355847804649440,"U",3,1331],
[3346858846910542287636816,"L",3,1163],[3535532584090944856267680,"U",3,1171],
[3718340449774753178376000,"S",4,307],[3784415994034409149418400,"L",3,1181],
[3924131140374825430572480,"U",3,1361],[3940991000620041233981808,"L",3,1187],
[4064682517701237155014272,"U",3,1367],[4103205271082310173471616,"L",3,1193],
[4112501775485526238515840,"L",3,1369],[4209619213639971856879056,"U",3,1373],
[4232231393645274958598400,"S",4,311],[4328563154996813788804800,"U",3,1201],
[4409891923562349462856800,"L",3,1381],[4512414091205299178615040,"S",4,313],
[4686904581504983592404208,"U",3,1213],[4811985747824104237129728,"L",3,1217],
[4891254260070710853064800,"L",3,1399],[5005083943342224347445216,"L",3,1223],
[5123400480112732888898880,"S",4,317],[5178052764012319299187200,"U",3,1409],
[5204928587926502319538080,"L",3,1229],[5273077290604289116177920,"U",3,1231],
[5482230777364574031684816,"U",3,1237],[5604252978828368293515072,"L",3,1423],
[5632439350189020042240000,"L",4,49],[5731526662889918040495072,"U",3,1427],
[5734420792816671844761600,"F",4,3],[5796106580183142088625760,"L",3,1429],
[5922420352294869150000000,"U",3,1249],[5927179191673326105881376,"U",3,1433],
[6028884370606993419663360,"L",4,47],[6128650947957220311091200,"U",3,1439],
[6191607015326785597675200,"G",2,59],[6312560691900779294826960,"L",3,1259],
[6406587863382891917507616,"L",3,1447],[6549646167156888055893600,"U",3,1451],
[6622217701322872375675872,"L",3,1453],[6844171386381048948168720,"L",3,1459],
[6973279267500000000000000,"S",8,5],[6973279267500000000000000,"O",9,5],
[7071750202735687246116768,"L",3,1277],[7160841986546331559526400,"U",3,1279],
[7307686810057897875628800,"L",3,1471],[7341976447042021078200816,"L",3,1283],
[7621195059302122597971840,"L",3,1289],[7714699523485784526284640,"U",3,1481],
[7716310192076004059792160,"U",3,1291],[7755605021665492992000000,"A",25,0],
[7798440373438152536188272,"L",3,1483],[7893070430870592741153600,"S",4,331],
[7968311386985024315638272,"U",3,1487],[8007916770591699118487616,"U",3,1297],
[8054454477323719971463680,"L",3,1489],[8207636529519434329140000,"L",3,1301],
[8229188535489364450054896,"U",3,1493],[8309120746569643834366848,"U",3,1303],
[8497508641678094629500000,"U",3,1499],[8515388098525142019087888,"L",3,1307],
[9057206506996626225367680,"U",3,1511],[9161321296752409406682720,"L",3,1319],
[9273043396671596090213280,"U",3,1321],[9446375148695185907082240,"S",4,337],
[9615395149097265212745216,"U",3,1327],[9648899542456750031525856,"U",3,1523],
[9775062020994743678515200,"U",5,11],[9849727111713051791012400,"L",3,1331],
[9874178184195364716331200,"G",2,61],[10061902054555115955274800,"L",3,1531],
[10710406919506236472531872,"L",3,1543],
[11048158757176597720389600,"L",3,1549],
[11265070201783935264000000,"U",4,49],[11269574353916238882412800,"S",4,343],
[11278470583461464557223616,"U",3,1553],
[11631815052303692096323200,"U",3,1559],
[11772393411785045950809600,"L",3,1361],
[12117988612591464205685376,"L",3,1567],
[12194047543556592459815328,"L",3,1367],
[12337505336073742328930400,"U",3,1369],
[12367674586776556272929760,"U",3,1571],
[12628857631161429389325216,"L",3,1373],
[12654970740711659608038720,"S",4,347],
[12880585686303657581560560,"L",3,1579],
[13143949776608561360626176,"U",3,1583],
[13229675780733163747733520,"U",3,1381],
[13403576835936900615240000,"S",4,349],
[14103207768974479571406816,"L",3,1597],
[14388291614933053457068800,"U",3,1601],
[14673762790930245923760000,"U",3,1399],
[14825371719337112943199872,"U",3,1607],
[14973624233651683293563520,"L",3,1609],
[15021509366253162579333120,"S",4,353],
[15274025719827889599211536,"U",3,1613],
[15534158280930265543311360,"L",3,1409],
[15734515323907944347896800,"U",3,1619],
[15890687924885750686600800,"L",3,1621],
[16367373936264969039643056,"L",3,1627],
[16812758948154659514643968,"U",3,1423],
[17189688968853558052804272,"U",3,1637],
[17194579976835261370696368,"L",3,1427],
[17388319752467084501480400,"U",3,1429],
[17779155171262739214854400,"S",4,359],
[17781537562934586471378816,"L",3,1433],
[18277653704353074655827840,"L",4,53],
[18385952831531132539386240,"L",3,1439],
[18794842506959546318342400,"S",4,361],
[18943431608076110096916096,"L",3,1657],
[19031213036231093492121600,"O+",8,8],
[19040507889972842499932160,"O-",8,8],
[19045158721552047314829312,"3D",4,8],
[19219763602836070248863616,"U",3,1447],
[19266960106724096212992000,"S",6,16],
[19338090747069790892851200,"G",2,64],
[19499190486817925917942272,"L",3,1663],
[19648938488606936075490000,"L",3,1451],
[19866653116921244193379248,"U",3,1453],
[19877574402564077521762272,"U",3,1667],
[20069164036722152629945440,"L",3,1669],
[20532514172365423842717600,"U",3,1459],
[21253002779246699806732800,"L",3,1681],
[21923060443948742824058880,"U",3,1471],
[22162942636848116948321280,"S",4,367],
[22497499899205142103163872,"L",3,1693],
[22926266324064623623807872,"U",3,1697],
[23143318154112278324264400,"L",3,1699],
[23144098556207674280726400,"L",3,1481],
[23395321134660613750448928,"U",3,1483],
[23904934146414395460259008,"L",3,1487],
[24163363446609886136097600,"U",3,1489],
[24255771818912887223149200,"U",3,1709],
[24687565591631682905123616,"L",3,1493],
[25492525909897348169994000,"L",3,1499],
[25652255763226881748044960,"U",3,1721],
[25891715033566897328865072,"L",3,1723],
[26064848253906631300887360,"S",4,373],
[27118589833309252294940976,"U",3,1733],
[27171619505237282960757600,"L",3,1511],
[28136415637734334357471200,"L",3,1741],
[28921568530766619588176016,"L",3,1747],
[28946698610982122934375216,"L",3,1523],
[29725826089090614636511872,"L",3,1753],
[30185706180488437693689120,"U",3,1531],
[30549585389703905444008320,"L",3,1759],
[30574480075343640655329600,"S",4,379],
[32131220776011513961327488,"U",3,1543],
[33141947888980395206816256,"L",3,1777],
[33144476289365359469790000,"U",3,1549],
[33835411732317350004143616,"L",3,1553],
[33958991427863167900385280,"S",4,383],
[34047823425103850381170272,"L",3,1783],
[34426017123500213280276480,"S",6,17],
[34426017123500213280276480,"O",7,17],
[34663708939361422453810272,"U",3,1787],
[34895445138492316121945760,"L",3,1559],
[34975290796270751148173280,"L",3,1789],
[36353965856670606723618816,"U",3,1567],
[36555798492660698146247040,"U",4,53],
[36724042443586285645615296,"G",2,67],
[36896767014020452494480000,"L",3,1801],
[37103023741191043294700400,"L",3,1571],
[38567919805760971312858080,"U",3,1811],
[38641757078541884531354400,"U",3,1579],
[38685331082014736871587840,"Sz",131072,0],
[39431849309944859347626816,"L",3,1583],
[39670086508764164484782400,"S",4,389],
[40660429695760383282579456,"U",3,1823],
[42110012475285527824480800,"L",3,1831],
[42309623327699078467109616,"U",3,1597],
[43164874823762030607360000,"L",3,1601],
[44476115136577043449541088,"L",3,1607],
[44920872722523058499565600,"U",3,1609],
[45145428714030704227039872,"U",3,1847],
[45537995249356606735939200,"L",3,1849],
[45822077137646231766822816,"L",3,1613],
[47203545949477211140121520,"L",3,1619],
[47672063797041623544054480,"U",3,1621],
[47956734685409131861423200,"L",3,1861],
[48626422187318616930189120,"S",4,397],
[49102121831596626486525216,"U",3,1627],
[49207711093863679498705776,"L",3,1867],
[50057472942602663266460160,"U",3,1871],
[50487148251455833447875072,"L",3,1873],
[51356190723730327589625072,"U",3,1877],
[51569066883049558893112608,"L",3,1637],
[51795599369354382171080160,"L",3,1879],
[53754030042062414336640000,"S",4,401],
[54042357616643156811523200,"U",3,1889],
[56830294849211203252667616,"U",3,1657],
[56850666434526574909069200,"U",3,1901],
[58302096277584210282235872,"U",3,1907],
[58497571485892253474193408,"U",3,1663],
[59632723181946346766316528,"L",3,1667],
[59785847070482144645279136,"U",3,1913],
[60207492136067159174432400,"U",3,1669],
[63759008364585408540294720,"U",3,1681],
[64437223504370030049990240,"U",3,1931],
[64973080981609130094946272,"L",3,1933],
[65493845080688471316998400,"S",4,409],
[67492499725432704559755888,"U",3,1693],
[68778798944046420864718848,"L",3,1697],
[69402217011661395773730000,"U",3,1949],
[69429954490650542366340000,"U",3,1699],
[69974013793862727366480000,"L",3,1951],
[72767315427581841344480160,"L",3,1709],
[76457792934119864313446400,"S",10,3],
[76457792934119864313446400,"O",11,3],
[76541208644962923728486256,"U",3,1973],
[76956767259485703178646400,"L",3,1721],
[77675145131071492319124768,"U",3,1723],
[78423277414868273923912800,"U",3,1979],
[80995627074445573892640336,"L",3,1987],
[81355769468665331756694816,"L",3,1733],
[82704801012184062685612800,"G",2,71],
[82973044442151488423647872,"L",3,1993],
[83388806917025021039073600,"S",4,419],
[84314672104072081237561872,"U",3,1997],
[84409246945193700481638960,"U",3,1741],
[84992575456319880026664000,"L",3,1999],
[86362703976301777954946016,"U",3,2003],
[86764705624845615823475616,"U",3,1747],
[87455778962056115763297600,"S",4,421],
[89161055816042003064289200,"L",3,2011],
[89177478300380338540734048,"U",3,1753],
[91311572970263832883070976,"L",3,2017],
[91326640612967526621456000,"U",4,59],
[91648756202790705838233600,"U",3,1759],
[94996724097955614711615072,"U",3,2027],
[95749169563479428110164960,"L",3,2029],
[99425843702379005560545216,"U",3,1777],
[99590163897078212062147200,"U",3,2039],
[102143470311351699905017728,"U",3,1783],
[103161645356799187438534656,"U",3,2048],
[103991126781638036466776208,"L",3,1787],
[104925872425462893447471600,"U",3,1789],
[105193822621545804418507872,"L",3,2053],
[109363516721879453204967936,"U",3,2063],
[110596241458620494016537600,"S",4,431],
[110690301079957798504807200,"U",3,1801],
[111934140596462654557282800,"U",3,2069],
[115703759378322629865063600,"L",3,1811],
[115836826639280245607162880,"S",4,433],
[117234459834550836273325440,"U",3,2081],
[118138867881507837913912272,"L",3,2083],
[119966016472414452214342272,"U",3,2087],
[120888827548215367987082880,"L",3,2089],
[121981289047012857932985216,"L",3,1823],
[122022111990893789657316096,"G",2,73],
[125596678820743221659820000,"U",3,2099],
[126330037467016225373800320,"U",3,1831],
[129182006871144805294080000,"O+",8,9],
[131457241358178254422548480,"U",3,2111],
[132456911501240785225654272,"L",3,2113],
[132926923446077482456838400,"S",4,439],
[135436286099102419499516448,"L",3,1847],
[136613985791292772191660000,"U",3,1849],
[140696709626017714579300800,"U",3,2129],
[141757565873489873587846800,"L",3,2131],
[143870204100871255416919440,"U",3,1861],
[144982247363932315308241536,"L",3,2137],
[145547601681263058955080000,"S",4,443],
[147167525940385560923693520,"U",3,2141],
[147623133326959229303382816,"U",3,1867],
[148270932529764553279999872,"L",3,2143],
[150172418781951711007262400,"L",3,1871],
[150580543027486263893136000,"L",4,61],
[151461444800469393378255168,"U",3,1873],
[153897260898993527434926816,"U",3,2153],
[154068572124594703927995168,"L",3,1877],
[155386798154908203667862400,"U",3,1879],
[158531944769072351009395200,"L",3,2161],
[162127072801824531956029440,"L",3,1889],
[166506526137893478082560000,"S",4,449],
[169409006577428259373799760,"L",3,2179],
[170551999253927300214660000,"L",3,1901],
[174906288782311671086634288,"L",3,1907],
[179357541160206952350546816,"L",3,1913],
[180933552622592559468203616,"L",3,2197],
[182651502539780355267907200,"L",4,59],
[184924576573425788025565872,"L",3,2203],
[187627858369513962097231872,"U",3,2207],
[188992418748158358938142720,"L",3,2209],
[191747613789029538035426736,"U",3,2213],
[193311670459414175056088400,"L",3,1931],
[194919242998801955121742128,"U",3,1933],
[197363630587999261936888800,"L",3,2221],
[198668917561824662179795200,"S",4,457],
[201645730563302817792000000,"A",26,0],
[208206650978738519594167200,"L",3,1949],
[209028994425575255807368272,"U",3,2237],
[209922041438123030057932800,"U",3,1951],
[210528747753751958520487680,"L",3,2239],
[213556526117646716454268896,"U",3,2243],
[216759037891409800654190400,"S",4,461],
[219726591877104008775750000,"L",3,2251],
[226348639567499122245411840,"S",4,463],
[229623625875093710586045216,"L",3,1973],
[232536334222042667775538272,"U",3,2267],
[234182602449951203925404640,"L",3,2269],
[235269832183895014271560080,"L",3,1979],
[237505760240960340684809856,"U",3,2273],
[242986881285283570798374816,"U",3,1987],
[244276081074861132447964800,"L",3,2281],
[246681635205971935620406080,"S",4,467],
[248919133389342262046342688,"U",3,1993],
[249464055924472905821612736,"L",3,2287],
[252944016248694821799174048,"L",3,1997],
[254748186176366092878091872,"L",3,2293],
[254977726432799784024000000,"U",3,1999],
[258325110935017475547475872,"U",3,2297],
[258442783258674454981632000,"O-",8,9],
[259088111864423907775325616,"L",3,2003],
[267483167513905459700555040,"U",3,2011],
[269320943469942554882353200,"U",3,2309],
[271192845372433774503991200,"L",3,2311],
[273934718977558116950994816,"U",3,2017],
[284990172225428635494114768,"L",3,2027],
[287247508759214792930996400,"U",3,2029],
[292547624434826746522900176,"U",3,2333],
[298621065281943675595615200,"U",3,2339],
[298770491620746501171543840,"L",3,2039],
[300669915525019855226287200,"L",3,2341],
[301163739690412257916924800,"U",4,61],
[306890456491149689588952816,"L",3,2347],
[309484935998339985457545216,"L",3,2048],
[311099776955472082642444800,"U",3,2351],
[315581467937578904755528848,"U",3,2053],
[317508478856731391037589872,"U",3,2357],
[317923950002875071824793600,"S",4,479],
[328090550090903016370938816,"L",3,2063],
[332913264817242987537310800,"L",3,2371],
[335802421713559484195154720,"L",3,2069],
[339712965281173308939709056,"L",3,2377],
[344313326288286871965645840,"U",3,2381],
[346633879314456181600414272,"L",3,2383],
[351703379425599383655782400,"L",3,2081],
[353677854327695356458192480,"L",3,2389],
[354416603722952435670426528,"U",3,2083],
[356112797846512129157952000,"S",6,19],
[356112797846512129157952000,"O",7,19],
[358443127822176055393521696,"U",3,2393],
[359898049338058498819533408,"L",3,2087],
[362666482724211109261725600,"U",3,2089],
[365696373500374915595520000,"U",3,2399],
[368142494194299004427520000,"L",3,2401],
[368731028836129851377740800,"G",2,79],
[375195642020080049871325440,"S",4,487],
[376790036380741959343191600,"L",3,2099],
[380589106661858553584438880,"U",3,2411],
[388232487201237320107582272,"U",3,2417],
[394371723990690941760249600,"L",3,2111],
[396009846461248230064726656,"U",3,2423],
[397370734587964106364772608,"U",3,2113],
[407176892985109808845166400,"S",4,491],
[414689372526221213748003936,"L",3,2437],
[420166001501066211925453920,"U",3,2441],
[422090128790573258014164480,"L",3,2129],
[425272697708361175846511520,"U",3,2131],
[428499606654566083380367872,"U",3,2447],
[434946742180932816677022816,"U",3,2137],
[441502577731183468174365600,"L",3,2141],
[444812797679687899543001088,"U",3,2143],
[445601766040407547048879200,"U",3,2459],
[457332294143379621770586576,"L",3,2467],
[461691782604457508796959616,"L",3,2153],
[466306645872891774375315072,"L",3,2473],
[472374806704507023428925072,"U",3,2477],
[475595834401471909640840640,"U",3,2161],
[478601126411097684501000000,"S",4,499],
[508227019830531044595050400,"U",3,2179],
[513529589687828055088051872,"L",3,2503],
[516964372056378442547769600,"3D",4,9],
[518379881851586990753521920,"S",4,503],
[523267866582430926944332800,"G",2,81],
[523347523558339871062505808,"L",3,2187],
[523347523658402940339798816,"U",3,2187],
[539322992420959314658621440,"L",5,13],
[539817086878048288131863040,"U",5,13],
[542800657970149443223793616,"U",3,2197],
[543827847281805767617372800,"L",3,2521],
[554773729824054669948841248,"U",3,2203],
[561326878968182854992131040,"U",3,2531],
[562883575003819007496367488,"L",3,2207],
[566977256349673319727657600,"U",3,2209],
[575242841260934464243350816,"L",3,2213],
[575678864280339983171447280,"L",3,2539],
[582974501261217528109994496,"U",3,2543],
[583641481789878600640046400,"S",4,509],
[592090891872084596010536880,"U",3,2221],
[594069645399183627030630000,"U",3,2549],
[597808860079029196120380000,"L",3,2551],
[609150356960722851226339296,"L",3,2557],
[615129725635054023113850240,"U",4,67],
[627086983164689190990127008,"L",3,2237],
[631586243373794182428057600,"U",3,2239],
[640669578239392989106853616,"L",3,2243],
[652363144022176597389304800,"U",3,2579],
[659179775746898598616884000,"U",3,2251],
[677045700503673086283909120,"U",3,2591],
[681237920877319003132495872,"L",3,2593],
[697609002546374697304838928,"L",3,2267],
[702547807470136096448876400,"U",3,2269],
[712517280601534567948425216,"L",3,2273],
[715601618746416295701595200,"U",3,2609],
[732828243348080377658217120,"U",3,2281],
[733345215606505844528731776,"L",3,2617],
[736258373301645859645423296,"G",2,83],
[736793248079243021469753600,"S",4,521],
[742360489838579370514286160,"U",3,2621],
[748392167898548513214690816,"U",3,2287],
[764244558655878114947569488,"U",3,2293],
[765570702697611015175652160,"S",4,523],
[769990834288818923517799776,"U",3,2633],
[774975332677162926676069248,"L",3,2297],
[803360017857799190963061216,"L",3,2647],
[807962830278562472448617760,"L",3,2309],
[813578536249135995124026240,"U",3,2311],
[827963361455630319567775872,"U",3,2657],
[832962370709534425442727120,"L",3,2659],
[843039678435689754498923136,"U",3,2663],
[858074849351128057902105600,"S",4,529],
[863514806169562747984324800,"L",3,2671],
[877642873166249825216166816,"L",3,2333],
[879155412462730539908175456,"L",3,2677],
[895043341992840003906676272,"L",3,2683],
[895863195705813943900022640,"L",3,2339],
[902009746715676292626201360,"U",3,2341],
[905774347041495734338486272,"U",3,2687],
[911181939413637630531502080,"L",3,2689],
[920671369615877065135139616,"U",3,2347],
[922081933089414419288437296,"U",3,2693],
[933299330722770404810760000,"L",3,2351],
[938645845190831747867580000,"U",3,2699],
[952525436424705953230349088,"L",3,2357],
[961135751704886018790596496,"L",3,2707],
[972556468838937874828529280,"U",3,2711],
[978311224462285007689030272,"L",3,2713],
[995754659283722908127399040,"L",3,2719],
[998739794601589638955032480,"U",3,2371],
[1019138895995286394943325216,"U",3,2377],
[1025432250943750446749752800,"U",3,2729],
[1031459756427101644629058800,"L",3,2731],
[1032939978711812884647530400,"L",3,2381],
[1039901638097060144480675328,"U",3,2383],
[1061033563138722287204859600,"U",3,2389],
[1062064693745589274852414320,"U",3,2741],
[1073843942247540190961582400,"S",4,541],
[1075329383309584637523359616,"L",3,2393],
[1087117799463431602159788000,"L",3,2749],
[1097089120342203794035190400,"L",3,2399],
[1099837134985125502018550016,"U",3,2753],
[1104427482742481518195209600,"U",3,2401],
[1141767319822640065020315600,"L",3,2411]];
