/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.IndicesKt;
import org.jetbrains.kotlinx.dataframe.api.TakeKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aO\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012+\u0010\u0003\u001a'\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0004j\b\u0012\u0004\u0012\u0002H\u0002`\tH\u0086\b\u00f8\u0001\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001af\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2B\u0010\u0003\u001a>\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u000f\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u0002H\u0002`\u0011\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000\u001af\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\r2B\u0010\u0003\u001a>\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u000f\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u0002H\u0002`\u0011\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"drop", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "T", "predicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "it", "", "Lorg/jetbrains/kotlinx/dataframe/Predicate;", "n", "", "dropLast", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/RowFilter;", "dropWhile", "core"})
@SourceDebugExtension(value={"SMAP\ndrop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 drop.kt\norg/jetbrains/kotlinx/dataframe/api/DropKt\n+ 2 filter.kt\norg/jetbrains/kotlinx/dataframe/api/FilterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 first.kt\norg/jetbrains/kotlinx/dataframe/api/FirstKt\n*L\n1#1,402:1\n28#2,2:403\n30#2:408\n37#2:411\n38#2,2:414\n40#2:417\n774#3:405\n865#3,2:406\n774#3:412\n865#3:413\n866#3:416\n295#3:420\n296#3:422\n1#4:409\n1#4:410\n1#4:418\n1#4:424\n57#5:419\n58#5:421\n59#5:423\n*S KotlinDebug\n*F\n+ 1 drop.kt\norg/jetbrains/kotlinx/dataframe/api/DropKt\n*L\n27#1:403,2\n27#1:408\n65#1:411\n65#1:414,2\n65#1:417\n27#1:405\n27#1:406,2\n65#1:412\n65#1:413\n65#1:416\n71#1:420\n71#1:422\n27#1:409\n65#1:418\n71#1:419\n71#1:421\n71#1:423\n*E\n"})
public final class DropKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataColumn<T> drop(@NotNull DataColumn<? extends T> $this$drop, @NotNull Function1<? super T, Boolean> predicate) {
        void $this$filterTo$iv$iv$iv;
        void $this$filter$iv$iv;
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$drop = false;
        DataColumn<T> $this$filter$iv = $this$drop;
        boolean $i$f$filter = false;
        Iterable iterable = (Iterable)DataColumnKt.getIndices($this$filter$iv);
        boolean $i$f$filter2 = false;
        void var7_8 = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            int it$iv = ((Number)element$iv$iv$iv).intValue();
            boolean bl = false;
            Object it = $this$filter$iv.get(it$iv);
            boolean bl2 = false;
            boolean bl3 = !((Boolean)predicate.invoke(it)).booleanValue();
            if (!bl3) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List it$iv = (List)destination$iv$iv$iv;
        boolean bl = false;
        return $this$filter$iv.get(it$iv);
    }

    @NotNull
    public static final <T> DataColumn<T> drop(@NotNull DataColumn<? extends T> $this$drop, int n) {
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        return n == 0 ? $this$drop : (n >= BaseColumnKt.getSize((BaseColumn)$this$drop) ? $this$drop.get(CollectionsKt.emptyList()) : $this$drop.get(RangesKt.until((int)n, (int)BaseColumnKt.getSize((BaseColumn)$this$drop))));
    }

    @NotNull
    public static final <T> DataColumn<T> dropLast(@NotNull DataColumn<? extends T> $this$dropLast, int n) {
        Intrinsics.checkNotNullParameter($this$dropLast, (String)"<this>");
        return TakeKt.take($this$dropLast, BaseColumnKt.getSize((BaseColumn)$this$dropLast) - n);
    }

    public static /* synthetic */ DataColumn dropLast$default(DataColumn dataColumn, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return DropKt.dropLast(dataColumn, n);
    }

    @NotNull
    public static final <T> DataFrame<T> drop(@NotNull DataFrame<? extends T> $this$drop, int n) {
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Requested rows count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return DataFrameGetKt.getRows($this$drop, RangesKt.until((int)RangesKt.coerceAtMost((int)n, (int)DataFrameKt.getNrow($this$drop)), (int)DataFrameKt.getNrow($this$drop)));
    }

    @NotNull
    public static final <T> DataFrame<T> dropLast(@NotNull DataFrame<? extends T> $this$dropLast, int n) {
        Intrinsics.checkNotNullParameter($this$dropLast, (String)"<this>");
        if (!(n >= 0)) {
            boolean bl = false;
            String string = "Requested rows count " + n + " is less than zero.";
            throw new IllegalArgumentException(string.toString());
        }
        return TakeKt.take($this$dropLast, RangesKt.coerceAtLeast((int)(DataFrameKt.getNrow($this$dropLast) - n), (int)0));
    }

    public static /* synthetic */ DataFrame dropLast$default(DataFrame dataFrame, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return DropKt.dropLast(dataFrame, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> drop(@NotNull DataFrame<? extends T> $this$drop, @NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, Boolean> predicate) {
        void $this$filterTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter($this$drop, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$drop = false;
        DataFrame<T> $this$filter$iv = $this$drop;
        boolean $i$f$filter = false;
        Iterable $this$filter$iv$iv = (Iterable)IndicesKt.indices($this$filter$iv);
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            void it;
            DataRow<? extends T> row$iv;
            int it$iv = ((Number)element$iv$iv$iv).intValue();
            boolean bl = false;
            DataRow<? extends T> dataRow = row$iv = $this$filter$iv.get(it$iv);
            DataRow<? extends T> $this$drop_u24lambda_u243 = row$iv;
            boolean bl2 = false;
            boolean bl3 = !((Boolean)predicate.invoke((Object)it, (Object)it)).booleanValue();
            if (!bl3) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List it$iv = (List)destination$iv$iv$iv;
        boolean bl = false;
        return $this$filter$iv.get(it$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> dropWhile(@NotNull DataFrame<? extends T> $this$dropWhile, @NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, Boolean> predicate) {
        DataFrame<? extends T> dataFrame;
        block6: {
            block5: {
                DataRow<? extends T> dataRow;
                block4: {
                    Intrinsics.checkNotNullParameter($this$dropWhile, (String)"<this>");
                    Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                    boolean $i$f$dropWhile = false;
                    DataFrame<? extends T> $this$firstOrNull$iv = $this$dropWhile;
                    boolean $i$f$firstOrNull = false;
                    Iterable<DataRow<T>> $this$firstOrNull$iv$iv = DataFrameGetKt.rows($this$firstOrNull$iv);
                    boolean $i$f$firstOrNull2 = false;
                    Iterator<DataRow<T>> iterator2 = $this$firstOrNull$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        DataRow<? extends T> element$iv$iv;
                        DataRow<? extends T> it$iv = element$iv$iv = iterator2.next();
                        boolean bl = false;
                        DataRow<? extends T> dataRow2 = it$iv;
                        DataRow<? extends T> $this$dropWhile_u24lambda_u244 = it$iv;
                        boolean bl2 = false;
                        boolean bl3 = !((Boolean)predicate.invoke((Object)it, (Object)it)).booleanValue();
                        if (!bl3) continue;
                        dataRow = element$iv$iv;
                        break block4;
                    }
                    dataRow = null;
                }
                DataRow dataRow3 = dataRow;
                dataFrame = dataRow3;
                if (dataRow3 == null) break block5;
                DataRow it = dataFrame;
                boolean bl = false;
                DataFrame<? extends T> dataFrame2 = DropKt.drop($this$dropWhile, it.index());
                dataFrame = dataFrame2;
                if (dataFrame2 != null) break block6;
            }
            dataFrame = $this$dropWhile;
        }
        return dataFrame;
    }
}

