/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001c\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\r\u00a8\u0006\u001f"}, d2={"Lio/ktor/network/tls/EncryptionInfo;", "", "Ljava/security/PublicKey;", "serverPublic", "clientPublic", "Ljava/security/PrivateKey;", "clientPrivate", "<init>", "(Ljava/security/PublicKey;Ljava/security/PublicKey;Ljava/security/PrivateKey;)V", "component1", "()Ljava/security/PublicKey;", "component2", "component3", "()Ljava/security/PrivateKey;", "copy", "(Ljava/security/PublicKey;Ljava/security/PublicKey;Ljava/security/PrivateKey;)Lio/ktor/network/tls/EncryptionInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/security/PublicKey;", "getServerPublic", "getClientPublic", "Ljava/security/PrivateKey;", "getClientPrivate", "ktor-network-tls"})
public final class EncryptionInfo {
    @NotNull
    private final PublicKey serverPublic;
    @NotNull
    private final PublicKey clientPublic;
    @NotNull
    private final PrivateKey clientPrivate;

    public EncryptionInfo(@NotNull PublicKey serverPublic, @NotNull PublicKey clientPublic, @NotNull PrivateKey clientPrivate) {
        Intrinsics.checkNotNullParameter((Object)serverPublic, (String)"serverPublic");
        Intrinsics.checkNotNullParameter((Object)clientPublic, (String)"clientPublic");
        Intrinsics.checkNotNullParameter((Object)clientPrivate, (String)"clientPrivate");
        this.serverPublic = serverPublic;
        this.clientPublic = clientPublic;
        this.clientPrivate = clientPrivate;
    }

    @NotNull
    public final PublicKey getServerPublic() {
        return this.serverPublic;
    }

    @NotNull
    public final PublicKey getClientPublic() {
        return this.clientPublic;
    }

    @NotNull
    public final PrivateKey getClientPrivate() {
        return this.clientPrivate;
    }

    @NotNull
    public final PublicKey component1() {
        return this.serverPublic;
    }

    @NotNull
    public final PublicKey component2() {
        return this.clientPublic;
    }

    @NotNull
    public final PrivateKey component3() {
        return this.clientPrivate;
    }

    @NotNull
    public final EncryptionInfo copy(@NotNull PublicKey serverPublic, @NotNull PublicKey clientPublic, @NotNull PrivateKey clientPrivate) {
        Intrinsics.checkNotNullParameter((Object)serverPublic, (String)"serverPublic");
        Intrinsics.checkNotNullParameter((Object)clientPublic, (String)"clientPublic");
        Intrinsics.checkNotNullParameter((Object)clientPrivate, (String)"clientPrivate");
        return new EncryptionInfo(serverPublic, clientPublic, clientPrivate);
    }

    public static /* synthetic */ EncryptionInfo copy$default(EncryptionInfo encryptionInfo, PublicKey publicKey, PublicKey publicKey2, PrivateKey privateKey, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = encryptionInfo.serverPublic;
        }
        if ((n & 2) != 0) {
            publicKey2 = encryptionInfo.clientPublic;
        }
        if ((n & 4) != 0) {
            privateKey = encryptionInfo.clientPrivate;
        }
        return encryptionInfo.copy(publicKey, publicKey2, privateKey);
    }

    @NotNull
    public String toString() {
        return "EncryptionInfo(serverPublic=" + this.serverPublic + ", clientPublic=" + this.clientPublic + ", clientPrivate=" + this.clientPrivate + ')';
    }

    public int hashCode() {
        int result2 = this.serverPublic.hashCode();
        result2 = result2 * 31 + this.clientPublic.hashCode();
        result2 = result2 * 31 + this.clientPrivate.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptionInfo)) {
            return false;
        }
        EncryptionInfo encryptionInfo = (EncryptionInfo)other;
        if (!Intrinsics.areEqual((Object)this.serverPublic, (Object)encryptionInfo.serverPublic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientPublic, (Object)encryptionInfo.clientPublic)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientPrivate, (Object)encryptionInfo.clientPrivate);
    }
}

