/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmArrayVariableInLoopAssignmentChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "<init>", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isOuterForLoopRangeVariable", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
public final class JvmArrayVariableInLoopAssignmentChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final JvmArrayVariableInLoopAssignmentChecker INSTANCE = new JvmArrayVariableInLoopAssignmentChecker();

    private JvmArrayVariableInLoopAssignmentChecker() {
    }

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProperForInArrayLoopRangeVariableAssignmentSemantic)) {
            return;
        }
        KtBinaryExpression ktBinaryExpression = expression instanceof KtBinaryExpression ? (KtBinaryExpression)expression : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhsExpression = ktSimpleNameExpression;
        KtElement ktElement = (KtElement)lhsExpression;
        BindingContext bindingContext = c.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)ktElement, (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        LocalVariableDescriptor localVariableDescriptor = callableDescriptor instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)callableDescriptor : null;
        if (localVariableDescriptor == null) {
            return;
        }
        LocalVariableDescriptor variableDescriptor = localVariableDescriptor;
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return;
        }
        if (variableDescriptor.isDelegated()) {
            return;
        }
        KotlinType kotlinType = variableDescriptor.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getReturnType(...)");
        KotlinType variableType = kotlinType;
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray(variableType)) {
            return;
        }
        if (!this.isOuterForLoopRangeVariable(expression, (CallableDescriptor)variableDescriptor, c)) {
            return;
        }
        DataFlowValue.Kind dataFlowValueKind = c.dataFlowValueFactory.createDataFlowValue((KtExpression)lhsExpression, variableType, c).getKind();
        if (dataFlowValueKind != DataFlowValue.Kind.STABLE_VARIABLE) {
            return;
        }
        c.trace.report((Diagnostic)ErrorsJvm.ASSIGNMENT_TO_ARRAY_LOOP_VARIABLE.on((PsiElement)lhsExpression));
    }

    private final boolean isOuterForLoopRangeVariable(KtExpression expression, CallableDescriptor variableDescriptor, ResolutionContext<?> c) {
        for (PsiElement parent : PsiUtilsKt.getParents((PsiElement)((PsiElement)expression))) {
            ResolvedCall rangeResolvedCall;
            KtSimpleNameExpression rangeExpression;
            KtExpression ktExpression;
            if (!(parent instanceof KtForExpression) || ((ktExpression = ((KtForExpression)parent).getLoopRange()) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null) == null) continue;
            rangeExpression = rangeExpression;
            KtElement ktElement = (KtElement)rangeExpression;
            BindingContext bindingContext = c.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            if (CallUtilKt.getResolvedCall((KtElement)ktElement, (BindingContext)bindingContext) == null || !Intrinsics.areEqual((Object)rangeResolvedCall.getResultingDescriptor(), (Object)variableDescriptor)) continue;
            return true;
        }
        return false;
    }
}

