/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.ui;

import com.intellij.ide.rpc.ThrottledAccumulatedItems;
import com.intellij.ide.rpc.ThrottledItems;
import com.intellij.ide.rpc.ThrottledOneItem;
import com.intellij.platform.searchEverywhere.SeResultEvent;
import com.intellij.platform.searchEverywhere.frontend.ui.ResultListEventHandlingUtilsKt;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListCollection;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListModelAdapter;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListMoreRow;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListRow;
import com.intellij.platform.searchEverywhere.providers.SeLog;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\u0014\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel;", "Ljavax/swing/DefaultListModel;", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListRow;", "selectionModelProvider", "Lkotlin/Function0;", "Ljavax/swing/ListSelectionModel;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "freezer", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel$Freezer;", "getFreezer", "()Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel$Freezer;", "isValid", "", "()Z", "isValidState", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "_isValidState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "reset", "", "invalidate", "removeLoadingItem", "addFromThrottledEvent", "throttledEvent", "Lcom/intellij/ide/rpc/ThrottledItems;", "Lcom/intellij/platform/searchEverywhere/SeResultEvent;", "Freezer", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeResultListModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeResultListModel.kt\ncom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 SeResultListModel.kt\ncom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel\n*L\n47#1:83,2\n*E\n"})
public final class SeResultListModel
extends DefaultListModel<SeResultListRow> {
    @NotNull
    private final Function0<ListSelectionModel> selectionModelProvider;
    @NotNull
    private final Freezer freezer;
    @NotNull
    private final MutableStateFlow<Boolean> _isValidState;

    public SeResultListModel(@NotNull Function0<? extends ListSelectionModel> selectionModelProvider) {
        Intrinsics.checkNotNullParameter(selectionModelProvider, (String)"selectionModelProvider");
        this.selectionModelProvider = selectionModelProvider;
        this.freezer = new Freezer((Function0<Integer>)((Function0)() -> SeResultListModel.freezer$lambda$0(this)));
        this._isValidState = StateFlowKt.MutableStateFlow((Object)true);
    }

    @NotNull
    public final Freezer getFreezer() {
        return this.freezer;
    }

    public final boolean isValid() {
        return (Boolean)this.isValidState().getValue();
    }

    @NotNull
    public final StateFlow<Boolean> isValidState() {
        return FlowKt.asStateFlow(this._isValidState);
    }

    public final void reset() {
        SeLog.Companion.log(SeLog.THROTTLING, SeResultListModel::reset$lambda$1);
        this.freezer.reset();
        this._isValidState.setValue((Object)true);
        this.removeAllElements();
    }

    public final void invalidate() {
        this._isValidState.setValue((Object)false);
    }

    public final void removeLoadingItem() {
        if (this.getSize() > 0 && this.getElementAt(this.getSize() - 1) instanceof SeResultListMoreRow) {
            this.removeElementAt(this.getSize() - 1);
        }
    }

    public final void addFromThrottledEvent(@NotNull ThrottledItems<SeResultEvent> throttledEvent) {
        ThrottledItems<SeResultEvent> throttledItems;
        Intrinsics.checkNotNullParameter(throttledEvent, (String)"throttledEvent");
        if (!this.isValid()) {
            this.reset();
        }
        if ((throttledItems = throttledEvent) instanceof ThrottledAccumulatedItems) {
            SeResultListCollection accumulatedList = new SeResultListCollection();
            Iterable $this$forEach$iv = ((ThrottledAccumulatedItems)throttledEvent).getItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SeResultEvent it = (SeResultEvent)element$iv;
                boolean bl = false;
                ResultListEventHandlingUtilsKt.handleEvent(accumulatedList, it);
            }
            this.addAll((Collection)accumulatedList.getList());
        } else if (throttledItems instanceof ThrottledOneItem) {
            ResultListEventHandlingUtilsKt.handleEvent(new SeResultListModelAdapter(this, (ListSelectionModel)this.selectionModelProvider.invoke()), (SeResultEvent)((ThrottledOneItem)throttledEvent).getItem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final int freezer$lambda$0(SeResultListModel this$0) {
        return this$0.getSize();
    }

    private static final String reset$lambda$1() {
        return "Will reset result list model";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0010R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel$Freezer;", "", "listSize", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "frozenCountToApply", "value", "", "isEnabled", "()Z", "frozenCount", "getFrozenCount", "()I", "enable", "", "freezeIfEnabled", "count", "reset", "intellij.platform.searchEverywhere.frontend"})
    public static final class Freezer {
        @NotNull
        private final Function0<Integer> listSize;
        private int frozenCountToApply;
        private boolean isEnabled;

        public Freezer(@NotNull Function0<Integer> listSize) {
            Intrinsics.checkNotNullParameter(listSize, (String)"listSize");
            this.listSize = listSize;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final int getFrozenCount() {
            return this.isEnabled ? this.frozenCountToApply : 0;
        }

        public final void enable() {
            this.isEnabled = true;
            SeLog.Companion.log(SeLog.FROZEN_COUNT, () -> Freezer.enable$lambda$0(this));
        }

        public final void freezeIfEnabled(int count) {
            if (count > this.frozenCountToApply) {
                this.frozenCountToApply = count;
                SeLog.Companion.log(SeLog.FROZEN_COUNT, () -> Freezer.freezeIfEnabled$lambda$1(this));
            }
        }

        public final void reset() {
            this.isEnabled = false;
            this.frozenCountToApply = 0;
        }

        private static final String enable$lambda$0(Freezer this$0) {
            return "frozenCount = " + this$0.frozenCountToApply + "; size = " + this$0.listSize.invoke() + "; isApplied = " + this$0.isEnabled;
        }

        private static final String freezeIfEnabled$lambda$1(Freezer this$0) {
            return "frozenCount = " + this$0.frozenCountToApply + "; size = " + this$0.listSize.invoke() + "; isApplied = " + this$0.isEnabled;
        }
    }
}

