/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.vcs;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.vcs.FailureDescription;
import com.intellij.execution.vcs.RunConfigurationBeforeCommitHandlerFactoryKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/vcs/RunConfigurationProblemWithDetails;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "problem", "Lcom/intellij/execution/vcs/FailureDescription;", "<init>", "(Lcom/intellij/execution/vcs/FailureDescription;)V", "getProblem", "()Lcom/intellij/execution/vcs/FailureDescription;", "text", "", "getText", "()Ljava/lang/String;", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showDetailsAction", "getShowDetailsAction", "Companion", "intellij.platform.smRunner.vcs"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationProblem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationProblem.kt\ncom/intellij/execution/vcs/RunConfigurationProblemWithDetails\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n24#2:65\n*S KotlinDebug\n*F\n+ 1 RunConfigurationProblem.kt\ncom/intellij/execution/vcs/RunConfigurationProblemWithDetails\n*L\n62#1:65\n*E\n"})
public final class RunConfigurationProblemWithDetails
implements CommitProblemWithDetails {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final FailureDescription problem;
    @NotNull
    private static final Logger LOG;

    public RunConfigurationProblemWithDetails(@NotNull FailureDescription problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.problem = problem;
    }

    @NotNull
    public final FailureDescription getProblem() {
        return this.problem;
    }

    @NotNull
    public String getText() {
        return this.problem.getMessage();
    }

    public void showDetails(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FailureDescription failureDescription = this.problem;
        if (failureDescription instanceof FailureDescription.FailedToStart) {
            if (((FailureDescription.FailedToStart)this.problem).getConfiguration() != null) {
                Object[] objectArray = new Object[]{((FailureDescription.FailedToStart)this.problem).getConfiguration().getName()};
                RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)((FailureDescription.FailedToStart)this.problem).getConfiguration(), (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])objectArray));
            } else {
                new EditConfigurationsDialog(project).show();
            }
        } else if (failureDescription instanceof FailureDescription.ProcessNonZeroExitCode) {
            Object[] objectArray = new Object[]{((FailureDescription.ProcessNonZeroExitCode)this.problem).getConfiguration().getName()};
            RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)((FailureDescription.ProcessNonZeroExitCode)this.problem).getConfiguration(), (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])objectArray));
        } else if (failureDescription instanceof FailureDescription.TestsFailed) {
            Pair<String, VirtualFile> pair = RunConfigurationBeforeCommitHandlerFactoryKt.getHistoryFile(project, ((FailureDescription.TestsFailed)this.problem).getHistoryFileName());
            String path = (String)pair.component1();
            VirtualFile virtualFile = (VirtualFile)pair.component2();
            if (virtualFile != null) {
                AbstractImportTestsAction.doImport((Project)project, (VirtualFile)virtualFile, (Long)ExecutionEnvironment.getNextUnusedExecutionId());
            } else {
                LOG.error("File not found: " + path);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public String getShowDetailsAction() {
        String string;
        if (this.problem instanceof FailureDescription.TestsFailed) {
            String string2 = ExecutionBundle.message((String)"commit.checks.run.configuration.failed.show.details.action", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = VcsBundle.message((String)"before.commit.run.configuration.failed.edit.configuration", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/vcs/RunConfigurationProblemWithDetails$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.smRunner.vcs"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

