/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorInspectionsActionToolbar;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.EditorToolbarButtonLook;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.DecompilerInEditorActionGroup;
import org.jetbrains.java.decompiler.IdeaDecompilerSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/java/decompiler/DecompilerInEditorListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "setupModeToggles", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.java.decompiler"})
final class DecompilerInEditorListener
implements EditorFactoryListener {
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = event.getEditor();
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor2 = editorImpl;
        VirtualFile virtualFile = editor2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)JavaClassFileType.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)file.getName(), (Object)"module-info.class")) {
            return;
        }
        this.setupModeToggles(editor2);
    }

    private final void setupModeToggles(EditorImpl editor) {
        IdeaDecompilerSettings decompilerSettings = IdeaDecompilerSettings.Companion.getInstance();
        AnAction[] anActionArray = new AnAction[]{new DecompilerInEditorActionGroup(decompilerSettings)};
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(anActionArray);
        EditorToolbarButtonLook editorButtonLook = new EditorToolbarButtonLook((Editor)editor);
        EditorInspectionsActionToolbar statusToolbar2 = new EditorInspectionsActionToolbar(defaultActionGroup, editor, editorButtonLook){

            protected ActionButton createIconButton(AnAction action, String place, Presentation presentation, Supplier<? extends Dimension> minimumSize) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
                return (ActionButton)new EditorInspectionsActionToolbar.ToolbarActionButton(this, action, presentation, place, minimumSize){

                    public Dimension getPreferredSize() {
                        Dimension size = new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
                        size.width = Math.max(size.width, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width);
                        size.height = Math.max(size.height, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height);
                        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
                        return size;
                    }
                };
            }
        };
        statusToolbar2.setMiniMode(true);
        statusToolbar2.setCustomButtonLook((ActionButtonLook)editorButtonLook);
        JComponent toolbar = statusToolbar2.getComponent();
        toolbar.setLayout((LayoutManager)new EditorMarkupModelImpl.StatusComponentLayout());
        toolbar.setBorder(JBUI.Borders.empty((int)2));
        NonOpaquePanel statusPanel = new NonOpaquePanel();
        statusPanel.setVisible(true);
        statusPanel.setLayout((LayoutManager)new BoxLayout((Container)statusPanel, 0));
        statusPanel.add((Component)toolbar);
        JScrollPane jScrollPane = editor.getScrollPane();
        JBScrollPane jBScrollPane = jScrollPane instanceof JBScrollPane ? (JBScrollPane)jScrollPane : null;
        if (jBScrollPane == null) {
            return;
        }
        JBScrollPane scrollPane = jBScrollPane;
        scrollPane.setStatusComponent((JComponent)statusPanel);
        LayoutManager layoutManager = scrollPane.getLayout();
        JBScrollPane.Layout layout = layoutManager instanceof JBScrollPane.Layout ? (JBScrollPane.Layout)layoutManager : null;
        if (layout == null) {
            return;
        }
        JBScrollPane.Layout scrollPaneLayout = layout;
        scrollPaneLayout.syncWithScrollPane((JScrollPane)scrollPane);
    }
}

