/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.toolsets.terminal;

import com.intellij.mcpserver.McpServerBundle;
import com.intellij.mcpserver.McpToolset;
import com.intellij.mcpserver.ProjectContextElementKt;
import com.intellij.mcpserver.annotations.McpDescription;
import com.intellij.mcpserver.annotations.McpTool;
import com.intellij.mcpserver.toolsets.Constants;
import com.intellij.mcpserver.toolsets.terminal.TerminalToolset;
import com.intellij.mcpserver.toolsets.terminal.TerminalToolset$CommandExecutionResult$;
import com.intellij.mcpserver.toolsets.terminal.TerminalToolsetUtilKt;
import com.intellij.mcpserver.util.Execution_utilKt;
import com.intellij.mcpserver.util.TruncateMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.EncodeDefault;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\t2\b\b\u0003\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\f2\b\b\u0003\u0010\u000e\u001a\u00020\u000fH\u0087@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/mcpserver/toolsets/terminal/TerminalToolset;", "Lcom/intellij/mcpserver/McpToolset;", "<init>", "()V", "execute_terminal_command", "Lcom/intellij/mcpserver/toolsets/terminal/TerminalToolset$CommandExecutionResult;", "command", "", "executeInShell", "", "reuseExistingTerminalWindow", "timeout", "", "maxLinesCount", "truncateMode", "Lcom/intellij/mcpserver/util/TruncateMode;", "(Ljava/lang/String;ZZIILcom/intellij/mcpserver/util/TruncateMode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "CommandExecutionResult", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nTerminalToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalToolset.kt\ncom/intellij/mcpserver/toolsets/terminal/TerminalToolset\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,81:1\n374#2:82\n*S KotlinDebug\n*F\n+ 1 TerminalToolset.kt\ncom/intellij/mcpserver/toolsets/terminal/TerminalToolset\n*L\n56#1:82\n*E\n"})
public final class TerminalToolset
implements McpToolset {
    /*
     * Unable to fully structure code
     */
    @McpTool
    @McpDescription(description="\n        Executes a specified shell command in the IDE's integrated terminal.\n        Use this tool to run terminal commands within the IDE environment.\n        Requires a command parameter containing the shell command to execute.\n        Important features and limitations:\n        - Checks if process is running before collecting output\n        - Limits output to 2000 lines (truncates excess)\n        - Times out after specified timeout with notification\n        - Requires user confirmation unless \"Brave Mode\" is enabled in settings\n        Returns possible responses:\n        - Terminal output (truncated if > 2000 lines)\n        - Output with interruption notice if timed out\n        - Error messages for various failure cases\n    ")
    @Nullable
    public final Object execute_terminal_command(@McpDescription(description="Shell command to execute") @NotNull String command, @McpDescription(description="Whether to execute the command in a default user's shell (bash, zsh, etc.). \n      |Useful if the command is not a commandline but a shell script, or if it's important to preserve real environment of the user's terminal. \n      |In the case of 'false' value the command will be started as a process") boolean executeInShell, @McpDescription(description="Whether to reuse an existing terminal window. Allows to avoid creating multiple terminals") boolean reuseExistingTerminalWindow, @McpDescription(description="Timeout in milliseconds") int timeout, @McpDescription(description="Maximum number of lines to return") int maxLinesCount, @McpDescription(description="How to truncate the text: from the start, in the middle, at the end, or don't truncate at all") @NotNull TruncateMode truncateMode, @NotNull Continuation<? super CommandExecutionResult> $completion) {
        if (!($completion instanceof execute_terminal_command.1)) ** GOTO lbl-1000
        var12_8 = $completion;
        if ((var12_8.label & -2147483648) != 0) {
            var12_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                boolean Z$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalToolset this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute_terminal_command(null, false, false, 0, 0, null, (Continuation<? super CommandExecutionResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$currentCoroutineContext = false;
                project = ProjectContextElementKt.getProject($continuation.getContext());
                $continuation.L$0 = command;
                $continuation.L$1 = truncateMode;
                $continuation.L$2 = project;
                $continuation.Z$0 = executeInShell;
                $continuation.Z$1 = reuseExistingTerminalWindow;
                $continuation.I$0 = timeout;
                $continuation.I$1 = maxLinesCount;
                $continuation.label = 1;
                v0 = Execution_utilKt.checkUserConfirmationIfNeeded(McpServerBundle.INSTANCE.message("label.do.you.want.to.execute.command.in.terminal", new Object[0]), command, project, (Continuation<? super Unit>)$continuation);
                if (v0 == var13_10) {
                    return var13_10;
                }
                ** GOTO lbl37
            }
            case 1: {
                maxLinesCount = $continuation.I$1;
                timeout = $continuation.I$0;
                reuseExistingTerminalWindow = $continuation.Z$1;
                executeInShell = $continuation.Z$0;
                project = (Project)$continuation.L$2;
                truncateMode = (TruncateMode)$continuation.L$1;
                command = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                id = "mcp_session";
                window = ToolWindowManager.Companion.getInstance(project).getToolWindow("Terminal");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)truncateMode);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)id);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)window);
                $continuation.Z$0 = executeInShell;
                $continuation.Z$1 = reuseExistingTerminalWindow;
                $continuation.I$0 = timeout;
                $continuation.I$1 = maxLinesCount;
                $continuation.label = 2;
                v1 = TerminalToolsetUtilKt.executeShellCommand-Tu6dINM(window, project, command, executeInShell != false, reuseExistingTerminalWindow != false ? id : null, DurationKt.toDuration((int)60000, (DurationUnit)DurationUnit.MILLISECONDS), maxLinesCount, truncateMode, (Continuation<? super CommandExecutionResult>)$continuation);
                if (v1 == var13_10) {
                    return var13_10;
                }
                ** GOTO lbl66
            }
            case 2: {
                maxLinesCount = $continuation.I$1;
                timeout = $continuation.I$0;
                reuseExistingTerminalWindow = $continuation.Z$1;
                executeInShell = $continuation.Z$0;
                window = (ToolWindow)$continuation.L$4;
                id = (String)$continuation.L$3;
                project = (Project)$continuation.L$2;
                truncateMode = (TruncateMode)$continuation.L$1;
                command = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl66:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object execute_terminal_command$default(TerminalToolset terminalToolset, String string, boolean bl, boolean bl2, int n, int n2, TruncateMode truncateMode, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            bl2 = true;
        }
        if ((n3 & 8) != 0) {
            n = 60000;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 1000;
        }
        if ((n3 & 0x20) != 0) {
            truncateMode = Constants.INSTANCE.getTRUCATE_MODE_VALUE();
        }
        return terminalToolset.execute_terminal_command(string, bl, bl2, n, n2, truncateMode, (Continuation<? super CommandExecutionResult>)continuation);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0002 !B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB9\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\b\u0010\rJ%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\u001fR \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0011\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0002\u0010\u0010R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0015\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/intellij/mcpserver/toolsets/terminal/TerminalToolset$CommandExecutionResult;", "", "is_timed_out", "", "command_exit_code", "", "command_output", "", "<init>", "(Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/String;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "is_timed_out$annotations", "()V", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getCommand_exit_code$annotations", "getCommand_exit_code", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getCommand_output", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    public static final class CommandExecutionResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Boolean is_timed_out;
        @Nullable
        private final Integer command_exit_code;
        @NotNull
        private final String command_output;

        public CommandExecutionResult(@Nullable Boolean is_timed_out, @Nullable Integer command_exit_code, @NotNull String command_output) {
            Intrinsics.checkNotNullParameter((Object)command_output, (String)"command_output");
            this.is_timed_out = is_timed_out;
            this.command_exit_code = command_exit_code;
            this.command_output = command_output;
        }

        public /* synthetic */ CommandExecutionResult(Boolean bl, Integer n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            this(bl, n, string);
        }

        @Nullable
        public final Boolean is_timed_out() {
            return this.is_timed_out;
        }

        @EncodeDefault(mode=EncodeDefault.Mode.NEVER)
        public static /* synthetic */ void is_timed_out$annotations() {
        }

        @Nullable
        public final Integer getCommand_exit_code() {
            return this.command_exit_code;
        }

        @EncodeDefault(mode=EncodeDefault.Mode.NEVER)
        public static /* synthetic */ void getCommand_exit_code$annotations() {
        }

        @NotNull
        public final String getCommand_output() {
            return this.command_output;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(CommandExecutionResult self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (self.is_timed_out != null) {
                output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.is_timed_out);
            }
            if (self.command_exit_code != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)IntSerializer.INSTANCE, (Object)self.command_exit_code);
            }
            output.encodeStringElement(serialDesc, 2, self.command_output);
        }

        public /* synthetic */ CommandExecutionResult(int seen0, Boolean is_timed_out, Integer command_exit_code, String command_output, SerializationConstructorMarker serializationConstructorMarker) {
            if (4 != (4 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)4, (SerialDescriptor)CommandExecutionResult$$serializer.INSTANCE.getDescriptor());
            }
            this.is_timed_out = (seen0 & 1) == 0 ? null : is_timed_out;
            this.command_exit_code = (seen0 & 2) == 0 ? null : command_exit_code;
            this.command_output = command_output;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/toolsets/terminal/TerminalToolset$CommandExecutionResult$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/toolsets/terminal/TerminalToolset$CommandExecutionResult;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<CommandExecutionResult> serializer() {
                return (KSerializer)CommandExecutionResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

