/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.TextAutoSize;
import androidx.compose.foundation.text.modifiers.TextAutoSizeLayoutScope;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import androidx.compose.ui.unit.TextUnitType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u0003*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Landroidx/compose/foundation/text/AutoSizeStepBased;", "Landroidx/compose/foundation/text/TextAutoSize;", "minFontSize", "Landroidx/compose/ui/unit/TextUnit;", "maxFontSize", "stepSize", "(JJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "isLastLineEllipsized", "", "Landroidx/compose/ui/text/TextLayoutResult;", "(Landroidx/compose/ui/text/TextLayoutResult;)Z", "equals", "other", "", "hashCode", "", "getFontSize", "Landroidx/compose/foundation/text/modifiers/TextAutoSizeLayoutScope;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "text", "Landroidx/compose/ui/text/AnnotatedString;", "getFontSize-Ci0_558", "(Landroidx/compose/foundation/text/modifiers/TextAutoSizeLayoutScope;JLandroidx/compose/ui/text/AnnotatedString;)J", "foundation"})
@SourceDebugExtension(value={"SMAP\nTextAutoSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextAutoSize.kt\nandroidx/compose/foundation/text/AutoSizeStepBased\n+ 2 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n*L\n1#1,288:1\n182#2,2:289\n182#2,2:291\n*S KotlinDebug\n*F\n+ 1 TextAutoSize.kt\nandroidx/compose/foundation/text/AutoSizeStepBased\n*L\n187#1:289,2\n192#1:291,2\n*E\n"})
final class AutoSizeStepBased
implements TextAutoSize {
    private long minFontSize;
    private final long maxFontSize;
    private final long stepSize;

    private AutoSizeStepBased(long minFontSize, long maxFontSize, long stepSize) {
        long arg0$iv;
        boolean bl;
        long other$iv;
        this.minFontSize = minFontSize;
        this.maxFontSize = maxFontSize;
        this.stepSize = stepSize;
        if (TextUnit.equals-impl0(this.minFontSize, TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for minFontSize. Try using other values e.g. 10.sp");
        }
        if (TextUnit.equals-impl0(this.maxFontSize, TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for maxFontSize. Try using other values e.g. 100.sp");
        }
        if (TextUnit.equals-impl0(this.stepSize, TextUnit.Companion.getUnspecified-XSAIIZE())) {
            throw new IllegalArgumentException("AutoSize.StepBased: TextUnit.Unspecified is not a valid value for stepSize. Try using other values e.g. 0.25.sp");
        }
        if (TextUnitType.equals-impl0(TextUnit.getType-UIouoOA(this.minFontSize), TextUnit.getType-UIouoOA(this.maxFontSize))) {
            long l = this.minFontSize;
            other$iv = this.maxFontSize;
            bl = false;
            TextUnitKt.checkArithmetic-NB67dxo(arg0$iv, other$iv);
            if (Float.compare(TextUnit.getValue-impl(arg0$iv), TextUnit.getValue-impl(other$iv)) > 0) {
                this.minFontSize = this.maxFontSize;
            }
        }
        if (TextUnitType.equals-impl0(TextUnit.getType-UIouoOA(this.stepSize), TextUnitType.Companion.getSp-UIouoOA())) {
            arg0$iv = this.stepSize;
            other$iv = TextUnitKt.getSp(1.0E-4f);
            bl = false;
            TextUnitKt.checkArithmetic-NB67dxo(arg0$iv, other$iv);
            if (Float.compare(TextUnit.getValue-impl(arg0$iv), TextUnit.getValue-impl(other$iv)) < 0) {
                throw new IllegalArgumentException("AutoSize.StepBased: stepSize must be greater than or equal to 0.0001f.sp");
            }
        }
        if (TextUnit.getValue-impl(this.minFontSize) < 0.0f) {
            throw new IllegalArgumentException("AutoSize.StepBased: minFontSize must not be negative");
        }
        if (TextUnit.getValue-impl(this.maxFontSize) < 0.0f) {
            throw new IllegalArgumentException("AutoSize.StepBased: maxFontSize must not be negative");
        }
    }

    private final boolean isLastLineEllipsized(TextLayoutResult $this$isLastLineEllipsized) {
        return $this$isLastLineEllipsized.getLineCount() > 0 ? $this$isLastLineEllipsized.isLineEllipsized($this$isLastLineEllipsized.getLineCount() - 1) : false;
    }

    @Override
    public long getFontSize-Ci0_558(@NotNull TextAutoSizeLayoutScope $this$getFontSize_u2dCi0_558, long constraints, @NotNull AnnotatedString text) {
        boolean didOverflow;
        TextLayoutResult layoutResult2;
        Intrinsics.checkNotNullParameter((Object)$this$getFontSize_u2dCi0_558, (String)"$this$getFontSize");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float stepSize = $this$getFontSize_u2dCi0_558.toPx--R2X_6o(this.stepSize);
        float smallest = $this$getFontSize_u2dCi0_558.toPx--R2X_6o(this.minFontSize);
        float largest = $this$getFontSize_u2dCi0_558.toPx--R2X_6o(this.maxFontSize);
        float min = smallest;
        float max = largest;
        float current = (min + max) / (float)2;
        while (max - min >= stepSize) {
            boolean bl;
            layoutResult2 = $this$getFontSize_u2dCi0_558.performLayout-5ZSfY2I(constraints, text, $this$getFontSize_u2dCi0_558.toSp-kPz2Gy4(current));
            int n = layoutResult2.getLayoutInput().getOverflow-gIe3tQ8();
            if (TextOverflow.equals-impl0(n, TextOverflow.Companion.getClip-gIe3tQ8()) ? true : TextOverflow.equals-impl0(n, TextOverflow.Companion.getVisible-gIe3tQ8())) {
                bl = layoutResult2.getDidOverflowWidth() || layoutResult2.getDidOverflowHeight();
            } else if ((TextOverflow.equals-impl0(n, TextOverflow.Companion.getStartEllipsis-gIe3tQ8()) ? true : TextOverflow.equals-impl0(n, TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8())) ? true : TextOverflow.equals-impl0(n, TextOverflow.Companion.getEllipsis-gIe3tQ8())) {
                int lineIndex;
                for (lineIndex = 0; lineIndex < layoutResult2.getLineCount() && !layoutResult2.isLineEllipsized(lineIndex); ++lineIndex) {
                }
                bl = lineIndex > 0;
            } else {
                throw new IllegalArgumentException("TextOverflow type " + TextOverflow.toString-impl(layoutResult2.getLayoutInput().getOverflow-gIe3tQ8()) + " is not supported.");
            }
            didOverflow = bl;
            if (didOverflow) {
                max = current;
            } else {
                min = current;
            }
            current = (min + max) / (float)2;
        }
        current = (float)Math.floor((min - smallest) / stepSize) * stepSize + smallest;
        if (current + stepSize <= largest) {
            layoutResult2 = $this$getFontSize_u2dCi0_558.performLayout-5ZSfY2I(constraints, text, $this$getFontSize_u2dCi0_558.toSp-kPz2Gy4(current + stepSize));
            boolean bl = didOverflow = layoutResult2.getDidOverflowWidth() || layoutResult2.getDidOverflowHeight();
            if (!didOverflow) {
                current += stepSize;
            }
        }
        return $this$getFontSize_u2dCi0_558.toSp-kPz2Gy4(current);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AutoSizeStepBased)) {
            return false;
        }
        if (!TextUnit.equals-impl0(((AutoSizeStepBased)other).minFontSize, this.minFontSize)) {
            return false;
        }
        if (!TextUnit.equals-impl0(((AutoSizeStepBased)other).maxFontSize, this.maxFontSize)) {
            return false;
        }
        return TextUnit.equals-impl0(((AutoSizeStepBased)other).stepSize, this.stepSize);
    }

    @Override
    public int hashCode() {
        int result2 = TextUnit.hashCode-impl(this.minFontSize);
        result2 = 31 * result2 + TextUnit.hashCode-impl(this.maxFontSize);
        result2 = 31 * result2 + TextUnit.hashCode-impl(this.stepSize);
        return result2;
    }

    public /* synthetic */ AutoSizeStepBased(long minFontSize, long maxFontSize, long stepSize, DefaultConstructorMarker $constructor_marker) {
        this(minFontSize, maxFontSize, stepSize);
    }
}

