/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.collection.MutableVectorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b/\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00060\u0002j\u0002`\u0003:\u0003tuvB\u001f\b\u0001\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\bJ\u0019\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010 J\u001c\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001c\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000!J\u001c\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\u0014\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000!J\u0017\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0086\bJ+\u0010#\u001a\u00020\u00182\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\u0006\u0010'\u001a\u00020\u001bJ\u0016\u0010(\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010)\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010)\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000!J\u0014\u0010)\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\u0014\u0010*\u001a\u00020\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0011\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0007H\u0086\bJ\u000b\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J0\u0010.\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u0010/J2\u00101\u001a\u0004\u0018\u00018\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00100JS\u00102\u001a\u0002H3\"\u0004\b\u0001\u001032\u0006\u00104\u001a\u0002H32'\u00105\u001a#\u0012\u0013\u0012\u0011H3\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(9\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H306H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010:Jh\u0010;\u001a\u0002H3\"\u0004\b\u0001\u001032\u0006\u00104\u001a\u0002H32<\u00105\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u0011H3\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(9\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H30<H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010=JS\u0010>\u001a\u0002H3\"\u0004\b\u0001\u001032\u0006\u00104\u001a\u0002H32'\u00105\u001a#\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u0011H3\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(9\u0012\u0004\u0012\u0002H306H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010:Jh\u0010?\u001a\u0002H3\"\u0004\b\u0001\u001032\u0006\u00104\u001a\u0002H32<\u00105\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u0011H3\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(9\u0012\u0004\u0012\u0002H30<H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010=J+\u0010@\u001a\u00020\u001b2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b0%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J1\u0010B\u001a\u00020\u001b2\u0018\u0010A\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b06H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010C\u001a\u00020\u001b2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b0%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J1\u0010D\u001a\u00020\u001b2\u0018\u0010A\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b06H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0016\u0010E\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0007H\u0086\n\u00a2\u0006\u0002\u0010FJ\u0015\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005H\u0001\u00a2\u0006\u0002\u0010HJ\u0013\u0010I\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010JJ+\u0010K\u001a\u00020\u00072\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010L\u001a\u00020\u00072\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\t\u0010M\u001a\u00020\u0018H\u0086\bJ\t\u0010N\u001a\u00020\u0018H\u0086\bJ\u000b\u0010O\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J0\u0010O\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00100J\u0013\u0010P\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010JJ\u0010\u0010Q\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u0010/J2\u0010Q\u001a\u0004\u0018\u00018\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00100J>\u0010R\u001a\b\u0012\u0004\u0012\u0002H30\u0005\"\u0006\b\u0001\u00103\u0018\u00012\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H30%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u0010TJS\u0010U\u001a\b\u0012\u0004\u0012\u0002H30\u0005\"\u0006\b\u0001\u00103\u0018\u00012'\u0010S\u001a#\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H306H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u0010VJP\u0010W\u001a\b\u0012\u0004\u0012\u0002H30\u0000\"\u0006\b\u0001\u00103\u0018\u00012)\u0010S\u001a%\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H306H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J;\u0010X\u001a\b\u0012\u0004\u0012\u0002H30\u0000\"\u0006\b\u0001\u00103\u0018\u00012\u0014\u0010S\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H30%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0016\u0010Y\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010ZJ\u0016\u0010[\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010ZJ\u0013\u0010\\\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010]\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010]\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000!J\u0014\u0010]\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\u0013\u0010^\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\u0002\u0010FJ \u0010_\u001a\u00020\u001b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000J\u0016\u0010`\u001a\u00020\u001b2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u0007J\u0010\u0010c\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0007H\u0001J\u0014\u0010d\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000!J+\u0010e\u001a\u00020\u00182\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u001e\u0010f\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010gJ\u0010\u0010h\u001a\u00020\u001b2\u0006\u0010i\u001a\u00020\u0007H\u0001J\u001e\u0010j\u001a\u00020\u001b2\u0016\u0010k\u001a\u0012\u0012\u0004\u0012\u00028\u00000lj\b\u0012\u0004\u0012\u00028\u0000`mJ+\u0010n\u001a\u00020\u00072\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070%H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\t\u0010p\u001a\u00020qH\u0081\bJ\u0010\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020sH\u0001R\"\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\n\n\u0002\u0010\u000b\u0012\u0004\b\t\u0010\nR\u0012\u0010\f\u001a\u00020\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u00078\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006w"}, d2={"Landroidx/compose/runtime/collection/MutableVector;", "T", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "content", "", "size", "", "([Ljava/lang/Object;I)V", "getContent$annotations", "()V", "[Ljava/lang/Object;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "lastIndex", "getLastIndex", "()I", "list", "", "<set-?>", "getSize", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "([Ljava/lang/Object;)Z", "", "", "any", "predicate", "Lkotlin/Function1;", "asMutableList", "clear", "contains", "containsAll", "contentEquals", "other", "ensureCapacity", "capacity", "first", "()Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "firstOrNull", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "acc", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "foldIndexed", "Lkotlin/Function3;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "foldRight", "foldRightIndexed", "forEach", "block", "forEachIndexed", "forEachReversed", "forEachReversedIndexed", "get", "(I)Ljava/lang/Object;", "getContent", "()[Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "indexOfFirst", "indexOfLast", "isEmpty", "isNotEmpty", "last", "lastIndexOf", "lastOrNull", "map", "transform", "(Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "mapIndexed", "(Lkotlin/jvm/functions/Function2;)[Ljava/lang/Object;", "mapIndexedNotNull", "mapNotNull", "minusAssign", "(Ljava/lang/Object;)V", "plusAssign", "remove", "removeAll", "removeAt", "removeIf", "removeRange", "start", "end", "resizeStorage", "retainAll", "reversedAny", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "setSize", "newSize", "sortWith", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "sumBy", "selector", "throwNoSuchElementException", "", "message", "", "MutableVectorList", "SubList", "VectorListIterator", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 2 ArrayUtils.nonAndroid.kt\nandroidx/compose/runtime/collection/ArrayUtils_nonAndroidKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1110:1\n289#1,4:1111\n289#1,4:1115\n289#1,4:1120\n289#1,4:1125\n289#1,4:1131\n289#1,4:1136\n44#1:1145\n472#1:1146\n48#1:1149\n472#1:1150\n44#1:1151\n472#1:1152\n516#1:1154\n332#1:1155\n472#1:1156\n516#1:1157\n472#1:1158\n516#1:1159\n44#1:1160\n472#1:1161\n516#1:1162\n44#1:1163\n472#1:1164\n472#1:1165\n472#1:1166\n44#1:1167\n472#1:1168\n44#1:1171\n44#1:1174\n44#1:1175\n472#1:1176\n23#2:1119\n23#2:1124\n23#2:1129\n23#2:1130\n23#2:1135\n23#2:1140\n23#2:1153\n23#2:1172\n23#2:1173\n1872#3,3:1141\n1863#3,2:1147\n1863#3,2:1169\n1#4:1144\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n55#1:1111,4\n66#1:1115,4\n87#1:1120,4\n111#1:1125,4\n156#1:1131,4\n169#1:1136,4\n234#1:1145\n235#1:1146\n265#1:1149\n266#1:1150\n279#1:1151\n280#1:1152\n309#1:1154\n310#1:1155\n312#1:1156\n340#1:1157\n340#1:1158\n526#1:1159\n529#1:1160\n529#1:1161\n563#1:1162\n563#1:1163\n563#1:1164\n588#1:1165\n598#1:1166\n678#1:1167\n679#1:1168\n700#1:1171\n725#1:1174\n759#1:1175\n760#1:1176\n69#1:1119\n90#1:1124\n114#1:1129\n121#1:1130\n157#1:1135\n172#1:1140\n300#1:1153\n701#1:1172\n717#1:1173\n179#1:1141,3\n256#1:1147,2\n692#1:1169,2\n*E\n"})
public final class MutableVector<T>
implements RandomAccess {
    @JvmField
    @NotNull
    public T[] content;
    @Nullable
    private List<T> list;
    private int size;
    public static final int $stable = 8;

    @PublishedApi
    public MutableVector(@NotNull T[] content, int size2) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = content;
        this.size = size2;
    }

    @PublishedApi
    public static /* synthetic */ void getContent$annotations() {
    }

    public final int getSize() {
        return this.size;
    }

    public final int getLastIndex() {
        boolean $i$f$getLastIndex = false;
        return this.getSize() - 1;
    }

    @NotNull
    public final IntRange getIndices() {
        boolean $i$f$getIndices = false;
        return RangesKt.until((int)0, (int)this.getSize());
    }

    @PublishedApi
    @NotNull
    public final T[] getContent() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(T element) {
        void this_$iv;
        MutableVector mutableVector = this;
        int capacity$iv = this.size + 1;
        boolean $i$f$ensureCapacity = false;
        if (this_$iv.content.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv);
        }
        this.content[this.size] = element;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index2, T element) {
        void this_$iv;
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + 1;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content = this.content;
        if (index2 != this.size) {
            void endIndex$iv;
            void destinationOffset$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content;
            $i$f$ensureCapacity = index2 + 1;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content, (int)destinationOffset$iv, (int)index2, (int)endIndex$iv);
        }
        content[index2] = element;
        int n = this.size;
        this.size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index2, @NotNull List<? extends T> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int elementsSize = elements.size();
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content = this.content;
        if (index2 != this.size) {
            void endIndex$iv;
            void destinationOffset$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content;
            $i$f$ensureCapacity = index2 + elementsSize;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content, (int)destinationOffset$iv, (int)index2, (int)endIndex$iv);
        }
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            content[index2 + i] = elements.get(i);
        }
        this.size += elementsSize;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index2, @NotNull MutableVector<T> elements) {
        void startIndex$iv;
        int destinationOffset$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int elementsSize = elements.size;
        if (elementsSize == 0) {
            return false;
        }
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content = this.content;
        if (index2 != this.size) {
            void endIndex$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content;
            $i$f$ensureCapacity = index2 + elementsSize;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content, (int)destinationOffset$iv, (int)index2, (int)endIndex$iv);
        }
        Object[] $this$fastCopyInto$iv = elements.content;
        destinationOffset$iv = 0;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content, (int)index2, (int)startIndex$iv, (int)elementsSize);
        this.size += elementsSize;
        return true;
    }

    public final boolean addAll(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$addAll = false;
        return this.addAll(this.getSize(), elements);
    }

    public final boolean addAll(@NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$addAll = false;
        return this.addAll(this.getSize(), elements);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(@NotNull T[] elements) {
        void destinationOffset$iv;
        void destination$iv;
        void $this$fastCopyInto$iv;
        T[] this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int elementsSize = elements.length;
        if (elementsSize == 0) {
            return false;
        }
        MutableVector mutableVector = this;
        int capacity$iv22 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv22) {
            this_$iv.resizeStorage(capacity$iv22);
        }
        this_$iv = elements;
        T[] capacity$iv22 = this.content;
        $i$f$ensureCapacity = this.size;
        int startIndex$iv = 0;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])destination$iv, (int)destinationOffset$iv, (int)startIndex$iv, (int)elementsSize);
        this.size += elementsSize;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index2, @NotNull Collection<? extends T> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int elementsSize = elements.size();
        MutableVector mutableVector = this;
        int capacity$iv2 = this.size + elementsSize;
        int $i$f$ensureCapacity = 0;
        if (this_$iv.content.length < capacity$iv2) {
            this_$iv.resizeStorage(capacity$iv2);
        }
        Object[] content = this.content;
        if (index2 != this.size) {
            void endIndex$iv;
            void destinationOffset$iv;
            void $this$fastCopyInto$iv;
            Object[] capacity$iv2 = content;
            $i$f$ensureCapacity = index2 + elementsSize;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content, (int)destinationOffset$iv, (int)index2, (int)endIndex$iv);
        }
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            content[index2 + i] = item2;
        }
        this.size += elementsSize;
        return true;
    }

    public final boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.addAll(this.size, elements);
    }

    public final boolean any(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$any = false;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final boolean reversedAny(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$reversedAny = false;
        T[] content = this.content;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<T> asMutableList() {
        List list2 = this.list;
        if (list2 == null) {
            MutableVectorList mutableVectorList;
            MutableVectorList it = mutableVectorList = new MutableVectorList(this);
            boolean bl = false;
            this.list = it;
            list2 = mutableVectorList;
        }
        return list2;
    }

    public final void clear() {
        T[] content = this.content;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            content[i] = null;
        }
        this.size = 0;
    }

    public final boolean contains(T element) {
        int i = 0;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i <= n) {
            while (true) {
                this_$iv = this;
                boolean $i$f$get = false;
                if (Intrinsics.areEqual(this_$iv.content[i], element)) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean containsAll(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(elements.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (this.contains(it)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(@NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector<T> this_$iv = elements;
        boolean $i$f$getIndices = false;
        IntRange intRange = RangesKt.until((int)0, (int)this_$iv.getSize());
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                MutableVector<T> this_$iv2 = elements;
                boolean $i$f$get = false;
                if (!this.contains(this_$iv2.content[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public final boolean contentEquals(@NotNull MutableVector<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.size != this.size) {
            return false;
        }
        int i = 0;
        MutableVector<T> this_$iv = this;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i <= n) {
            while (true) {
                this_$iv = other;
                boolean $i$f$get = false;
                this_$iv = this;
                $i$f$get = false;
                if (!Intrinsics.areEqual(this_$iv.content[i], this_$iv.content[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public final void ensureCapacity(int capacity) {
        boolean $i$f$ensureCapacity = false;
        if (this.content.length < capacity) {
            this.resizeStorage(capacity);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final void resizeStorage(int capacity) {
        void destinationOffset$iv;
        void $this$fastCopyInto$iv;
        T[] oldContent = this.content;
        int oldSize = oldContent.length;
        int newSize = Math.max(capacity, oldSize * 2);
        Object[] newContent = new Object[newSize];
        T[] TArray = oldContent;
        boolean bl = false;
        int startIndex$iv = 0;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newContent, (int)destinationOffset$iv, (int)startIndex$iv, (int)oldSize);
        this.content = newContent;
    }

    public final T first() {
        MutableVector this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0) {
            this_$iv = this;
            boolean $i$f$throwNoSuchElementException = false;
            this_$iv.throwNoSuchElementException("MutableVector is empty.");
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        int index$iv = 0;
        boolean $i$f$get = false;
        return this_$iv.content[index$iv];
    }

    public final T first(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$first = false;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            T item2 = content[i];
            if (!((Boolean)predicate.invoke(item2)).booleanValue()) continue;
            return item2;
        }
        this.throwNoSuchElementException("MutableVector contains no element matching the predicate.");
        throw new KotlinNothingValueException();
    }

    @PublishedApi
    @NotNull
    public final Void throwNoSuchElementException() {
        boolean $i$f$throwNoSuchElementException = false;
        this.throwNoSuchElementException("MutableVector is empty.");
        throw new KotlinNothingValueException();
    }

    @PublishedApi
    @NotNull
    public final Void throwNoSuchElementException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new NoSuchElementException(message);
    }

    @Nullable
    public final T firstOrNull() {
        T t;
        boolean $i$f$firstOrNull = false;
        MutableVector this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0) {
            t = null;
        } else {
            this_$iv = this;
            int index$iv = 0;
            boolean $i$f$get = false;
            t = this_$iv.content[index$iv];
        }
        return t;
    }

    @Nullable
    public final T firstOrNull(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$firstOrNull = false;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            T item2 = content[i];
            if (!((Boolean)predicate.invoke(item2)).booleanValue()) continue;
            return item2;
        }
        return null;
    }

    public final <R> R fold(R initial, @NotNull Function2<? super R, ? super T, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$fold = false;
        Object acc = initial;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            acc = operation.invoke(acc, content[i]);
        }
        return acc;
    }

    public final <R> R foldIndexed(R initial, @NotNull Function3<? super Integer, ? super R, ? super T, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$foldIndexed = false;
        Object acc = initial;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            acc = operation.invoke((Object)i, acc, content[i]);
        }
        return acc;
    }

    public final <R> R foldRight(R initial, @NotNull Function2<? super T, ? super R, ? extends R> operation) {
        int i;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$foldRight = false;
        Object acc = initial;
        T[] content = this.content;
        if (i >= content.length) {
            return acc;
        }
        for (i = this.getSize() - 1; i >= 0; --i) {
            acc = operation.invoke(content[i], acc);
        }
        return acc;
    }

    public final <R> R foldRightIndexed(R initial, @NotNull Function3<? super Integer, ? super T, ? super R, ? extends R> operation) {
        int i;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        boolean $i$f$foldRightIndexed = false;
        Object acc = initial;
        T[] content = this.content;
        if (i >= content.length) {
            return acc;
        }
        for (i = this.getSize() - 1; i >= 0; --i) {
            acc = operation.invoke((Object)i, content[i], acc);
        }
        return acc;
    }

    public final void forEach(@NotNull Function1<? super T, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$forEach = false;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            block2.invoke(content[i]);
        }
    }

    public final void forEachIndexed(@NotNull Function2<? super Integer, ? super T, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$forEachIndexed = false;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            block2.invoke((Object)i, content[i]);
        }
    }

    public final void forEachReversed(@NotNull Function1<? super T, Unit> block2) {
        int i;
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$forEachReversed = false;
        T[] content = this.content;
        if (i >= content.length) {
            return;
        }
        for (i = this.getSize() - 1; i >= 0; --i) {
            block2.invoke(content[i]);
        }
    }

    public final void forEachReversedIndexed(@NotNull Function2<? super Integer, ? super T, Unit> block2) {
        int i;
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$forEachReversedIndexed = false;
        T[] content = this.content;
        if (i >= content.length) {
            return;
        }
        for (i = this.getSize() - 1; i >= 0; --i) {
            block2.invoke((Object)i, content[i]);
        }
    }

    public final T get(int index2) {
        boolean $i$f$get = false;
        return this.content[index2];
    }

    public final int indexOf(T element) {
        T[] content = this.content;
        int size2 = this.size;
        for (int i = 0; i < size2; ++i) {
            if (!Intrinsics.areEqual(element, content[i])) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfFirst(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$indexOfFirst = false;
        T[] content = this.content;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfLast(@NotNull Function1<? super T, Boolean> predicate) {
        int i;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$indexOfLast = false;
        T[] content = this.content;
        if (i < content.length) {
            for (i = this.getSize() - 1; i >= 0; --i) {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return i;
            }
        }
        return -1;
    }

    public final boolean isEmpty() {
        boolean $i$f$isEmpty = false;
        return this.getSize() == 0;
    }

    public final boolean isNotEmpty() {
        boolean $i$f$isNotEmpty = false;
        return this.getSize() != 0;
    }

    public final T last() {
        MutableVector this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0) {
            this.throwNoSuchElementException("MutableVector is empty.");
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        MutableVector this_$iv2 = this;
        boolean $i$f$getLastIndex = false;
        int index$iv = this_$iv2.getSize() - 1;
        boolean $i$f$get = false;
        return this_$iv.content[index$iv];
    }

    public final T last(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$last = false;
        T[] content = this.content;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            T item2 = content[i];
            if (!((Boolean)predicate.invoke(item2)).booleanValue()) continue;
            return item2;
        }
        this.throwNoSuchElementException("MutableVector contains no element matching the predicate.");
        throw new KotlinNothingValueException();
    }

    public final int lastIndexOf(T element) {
        T[] content = this.content;
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(element, content[i])) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public final T lastOrNull() {
        T t;
        boolean $i$f$lastOrNull = false;
        MutableVector this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv.getSize() == 0) {
            t = null;
        } else {
            this_$iv = this;
            MutableVector this_$iv2 = this;
            boolean $i$f$getLastIndex = false;
            int index$iv = this_$iv2.getSize() - 1;
            boolean $i$f$get = false;
            t = this_$iv.content[index$iv];
        }
        return t;
    }

    @Nullable
    public final T lastOrNull(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$lastOrNull = false;
        T[] content = this.content;
        for (int i = this.getSize() - 1; i >= 0; --i) {
            T item2 = content[i];
            if (!((Boolean)predicate.invoke(item2)).booleanValue()) continue;
            return item2;
        }
        return null;
    }

    public final /* synthetic */ <R> R[] map(Function1<? super T, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$map = false;
        int n = 0;
        int n2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            MutableVector this_$iv = this;
            boolean $i$f$get = false;
            objectArray[n3] = transform2.invoke(this_$iv.content[n3]);
        }
        return objectArray;
    }

    public final /* synthetic */ <R> R[] mapIndexed(Function2<? super Integer, ? super T, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$mapIndexed = false;
        int n = 0;
        int n2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            MutableVector this_$iv = this;
            boolean $i$f$get = false;
            objectArray[n3] = transform2.invoke((Object)n3, this_$iv.content[n3]);
        }
        return objectArray;
    }

    public final /* synthetic */ <R> MutableVector<R> mapIndexedNotNull(Function2<? super Integer, ? super T, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$mapIndexedNotNull = false;
        int size2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R?");
        Object[] arr = new Object[size2];
        int targetSize = 0;
        T[] content = this.content;
        for (int i = 0; i < size2; ++i) {
            Object target = transform2.invoke((Object)i, content[i]);
            if (target == null) continue;
            arr[targetSize++] = target;
        }
        return new MutableVector<Object>(arr, targetSize);
    }

    public final /* synthetic */ <R> MutableVector<R> mapNotNull(Function1<? super T, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$mapNotNull = false;
        int size2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R?");
        Object[] arr = new Object[size2];
        int targetSize = 0;
        T[] content = this.content;
        for (int i = 0; i < size2; ++i) {
            Object target = transform2.invoke(content[i]);
            if (target == null) continue;
            arr[targetSize++] = target;
        }
        return new MutableVector<Object>(arr, targetSize);
    }

    public final void plusAssign(T element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(T element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(T element) {
        int index2 = this.indexOf(element);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            this.remove(elements.get(i));
        }
        return initialSize != this.size;
    }

    public final boolean removeAll(@NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        int i = 0;
        MutableVector<T> this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i <= n) {
            while (true) {
                this_$iv = elements;
                boolean $i$f$get = false;
                this.remove(this_$iv.content[i]);
                if (i == n) break;
                ++i;
            }
        }
        return initialSize != this.size;
    }

    public final boolean removeAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int initialSize = this.size;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.remove(it);
        }
        return initialSize != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final T removeAt(int index2) {
        Object[] content = this.content;
        T item2 = content[index2];
        Object[] this_$iv = this;
        int $i$f$getLastIndex = 0;
        if (index2 != this_$iv.getSize() - 1) {
            void endIndex$iv;
            void startIndex$iv;
            void $this$fastCopyInto$iv;
            this_$iv = content;
            $i$f$getLastIndex = index2 + 1;
            int n = this.size;
            boolean $i$f$fastCopyInto = false;
            ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])content, (int)index2, (int)startIndex$iv, (int)endIndex$iv);
        }
        int n = this.size;
        this.size = n + -1;
        content[this.size] = null;
        return item2;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRange(int start, int end2) {
        if (end2 > start) {
            int newSize;
            int n;
            if (end2 < this.size) {
                void endIndex$iv;
                void destination$iv;
                void $this$fastCopyInto$iv;
                T[] TArray = this.content;
                T[] TArray2 = this.content;
                n = this.size;
                boolean $i$f$fastCopyInto = false;
                ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])destination$iv, (int)start, (int)end2, (int)endIndex$iv);
            }
            int i = newSize = this.size - (end2 - start);
            MutableVector this_$iv = this;
            boolean $i$f$getLastIndex = false;
            n = this_$iv.getSize() - 1;
            if (i <= n) {
                while (true) {
                    this.content[i] = null;
                    if (i == n) break;
                    ++i;
                }
            }
            this.size = newSize;
        }
    }

    @PublishedApi
    public final void setSize(int newSize) {
        this.size = newSize;
    }

    public final void removeIf(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeIf = false;
        int gap = 0;
        int size2 = this.getSize();
        for (int i = 0; i < size2; ++i) {
            if (((Boolean)predicate.invoke(this.content[i])).booleanValue()) {
                ++gap;
                continue;
            }
            if (gap <= 0) continue;
            this.content[i - gap] = this.content[i];
        }
        ArraysKt.fill((Object[])this.content, null, (int)(size2 - gap), (int)size2);
        this.setSize(size2 - gap);
    }

    public final boolean retainAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
            MutableVector this_$iv2 = this;
            boolean $i$f$get = false;
            T item2 = this_$iv2.content[i];
            if (elements.contains(item2)) continue;
            this.removeAt(i);
        }
        return initialSize != this.size;
    }

    public final T set(int index2, T element) {
        T[] content = this.content;
        T old = content[index2];
        content[index2] = element;
        return old;
    }

    public final void sortWith(@NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        ArraysKt.sortWith((Object[])this.content, comparator, (int)0, (int)this.size);
    }

    public final int sumBy(@NotNull Function1<? super T, Integer> selector) {
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        boolean $i$f$sumBy = false;
        int sum = 0;
        T[] content = this.content;
        for (int i = 0; i < this.getSize(); ++i) {
            sum += ((Number)selector.invoke(content[i])).intValue();
        }
        return sum;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dH\u0096\u0002J\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0015\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\"\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u001e\u0010%\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/collection/MutableVector$MutableVectorList;", "T", "", "vector", "Landroidx/compose/runtime/collection/MutableVector;", "(Landroidx/compose/runtime/collection/MutableVector;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "runtime"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,1110:1\n472#2:1111\n516#2:1112\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n*L\n850#1:1111\n855#1:1112\n*E\n"})
    private static final class MutableVectorList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final MutableVector<T> vector;

        public MutableVectorList(@NotNull MutableVector<T> vector2) {
            Intrinsics.checkNotNullParameter(vector2, (String)"vector");
            this.vector = vector2;
        }

        public int getSize() {
            return this.vector.getSize();
        }

        @Override
        public boolean contains(Object element) {
            return this.vector.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.containsAll(elements);
        }

        @Override
        public T get(int index2) {
            MutableVectorKt.checkIndex(this, index2);
            MutableVector<T> this_$iv = this.vector;
            boolean $i$f$get = false;
            return this_$iv.content[index2];
        }

        @Override
        public int indexOf(Object element) {
            return this.vector.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            MutableVector<T> this_$iv = this.vector;
            boolean $i$f$isEmpty = false;
            return this_$iv.getSize() == 0;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.vector.lastIndexOf(element);
        }

        @Override
        public boolean add(T element) {
            return this.vector.add(element);
        }

        @Override
        public void add(int index2, T element) {
            this.vector.add(index2, element);
        }

        @Override
        public boolean addAll(int index2, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll(index2, elements);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll(elements);
        }

        @Override
        public void clear() {
            this.vector.clear();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index2) {
            return new VectorListIterator(this, index2);
        }

        @Override
        public boolean remove(Object element) {
            return this.vector.remove(element);
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.removeAll(elements);
        }

        public T removeAt(int index2) {
            MutableVectorKt.checkIndex(this, index2);
            return this.vector.removeAt(index2);
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.retainAll(elements);
        }

        @Override
        public T set(int index2, T element) {
            MutableVectorKt.checkIndex(this, index2);
            return this.vector.set(index2, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            MutableVectorKt.checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0096\u0002J\u0015\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0015\u0010$\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u001e\u0010&\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/compose/runtime/collection/MutableVector$SubList;", "T", "", "list", "start", "", "end", "(Ljava/util/List;II)V", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "runtime"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1110:1\n1863#2,2:1111\n1863#2,2:1113\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n*L\n922#1:1111,2\n1006#1:1113,2\n*E\n"})
    private static final class SubList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final List<T> list;
        private final int start;
        private int end;

        public SubList(@NotNull List<T> list2, int start, int end2) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            this.list = list2;
            this.start = start;
            this.end = end2;
        }

        public int getSize() {
            return this.end - this.start;
        }

        @Override
        public boolean contains(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (this.contains(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public T get(int index2) {
            MutableVectorKt.checkIndex(this, index2);
            return this.list.get(index2 + this.start);
        }

        @Override
        public int indexOf(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return i - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i), (Object)element)) {
                        return i - this.start;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return -1;
        }

        @Override
        public boolean add(T element) {
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, element);
            return true;
        }

        @Override
        public void add(int index2, T element) {
            this.list.add(index2 + this.start, element);
            int n = this.end;
            this.end = n + 1;
        }

        @Override
        public boolean addAll(int index2, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(index2 + this.start, elements);
            int size2 = elements.size();
            this.end += size2;
            return size2 > 0;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(this.end, elements);
            int size2 = elements.size();
            this.end += size2;
            return size2 > 0;
        }

        @Override
        public void clear() {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    this.list.remove(i);
                    if (i == n) break;
                    --i;
                }
            }
            this.end = this.start;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index2) {
            return new VectorListIterator(this, index2);
        }

        @Override
        public boolean remove(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                this.list.remove(i);
                int n2 = this.end;
                this.end = n2 + -1;
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                this.remove(it);
            }
            return originalEnd != this.end;
        }

        public T removeAt(int index2) {
            MutableVectorKt.checkIndex(this, index2);
            T item2 = this.list.remove(index2 + this.start);
            int n = this.end;
            this.end = n + -1;
            return item2;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            int i = this.end - 1;
            int n = this.start;
            if (n <= i) {
                while (true) {
                    T item2;
                    if (!elements.contains(item2 = this.list.get(i))) {
                        this.list.remove(i);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return originalEnd != this.end;
        }

        @Override
        public T set(int index2, T element) {
            MutableVectorKt.checkIndex(this, index2);
            return this.list.set(index2 + this.start, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            MutableVectorKt.checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\r\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/runtime/collection/MutableVector$VectorListIterator;", "T", "", "list", "", "index", "", "(Ljava/util/List;I)V", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "runtime"})
    private static final class VectorListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final List<T> list;
        private int index;

        public VectorListIterator(@NotNull List<T> list2, int index2) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            this.list = list2;
            this.index = index2;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public T next() {
            int n = this.index;
            this.index = n + 1;
            return this.list.get(n);
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.list.remove(this.index);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public T previous() {
            int n = this.index;
            this.index = n + -1;
            return this.list.get(this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(T element) {
            this.list.add(this.index, element);
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public void set(T element) {
            this.list.set(this.index, element);
        }
    }
}

