/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public class StatsHttpResponse {
    private static final SimpleDateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final SimpleDateFormat RFC1036_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz");
    private static final SimpleDateFormat ASCTIME_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    private static final SimpleDateFormat[] DATE_FORMATS = new SimpleDateFormat[]{RFC1123_FORMAT, RFC1036_FORMAT, ASCTIME_FORMAT};
    private final HttpResponse<String> myHttpResponse;
    private final int myCode;

    public StatsHttpResponse(@Nullable HttpResponse<String> httpResponse, int code) {
        this.myHttpResponse = httpResponse;
        this.myCode = code;
    }

    public int getStatusCode() {
        return this.myCode;
    }

    @Nullable
    public Long lastModified() {
        return this.myHttpResponse == null ? null : (Long)this.myHttpResponse.headers().allValues("Last-Modified").stream().map(value -> StatsHttpResponse.parseDate(value)).filter(date -> date != null).map(date -> date.getTime()).max(Long::compareTo).orElse(null);
    }

    @Nullable
    public String readAsString() throws IOException {
        return this.myHttpResponse != null && this.myHttpResponse.body() != null ? this.myHttpResponse.body() : null;
    }

    @Nullable
    public InputStream read() throws IOException {
        return this.myHttpResponse != null && this.myHttpResponse.body() != null ? new ByteArrayInputStream(this.myHttpResponse.body().getBytes(StandardCharsets.UTF_8)) : null;
    }

    @Nullable
    private static Date parseDate(String string) {
        for (SimpleDateFormat format : DATE_FORMATS) {
            try {
                Date date = format.parse(string, new ParsePosition(0));
                if (date == null) continue;
                return date;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

