/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.dwarf;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebuggingSection;
import org.jetbrains.kotlin.backend.wasm.dwarf.DwForm;
import org.jetbrains.kotlin.backend.wasm.dwarf.entries.DwAttribute;
import org.jetbrains.kotlin.backend.wasm.dwarf.entries.DwTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/Abbreviation;", "", "tag", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/DwTag;", "hasChildren", "", "attributes", "", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/Abbreviation$Specification;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/DwTag;ZLjava/util/List;)V", "getTag", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/DwTag;", "getHasChildren", "()Z", "getAttributes", "()Ljava/util/List;", "write", "", "section", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebuggingSection$DebugAbbreviations;", "Specification", "backend.wasm"})
public final class Abbreviation {
    @NotNull
    private final DwTag tag;
    private final boolean hasChildren;
    @NotNull
    private final List<Specification> attributes;

    public Abbreviation(@NotNull DwTag tag, boolean hasChildren, @NotNull List<Specification> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.tag = tag;
        this.hasChildren = hasChildren;
        this.attributes = attributes;
    }

    @NotNull
    public final DwTag getTag() {
        return this.tag;
    }

    public final boolean getHasChildren() {
        return this.hasChildren;
    }

    @NotNull
    public final List<Specification> getAttributes() {
        return this.attributes;
    }

    public final void write(@NotNull DebuggingSection.DebugAbbreviations section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        section.getWriter().writeVarUInt32-WZ4Q5Ns(this.tag.getValue-pVg5ArA());
        section.getWriter().writeVarUInt1(this.hasChildren);
        for (Specification attribute : this.attributes) {
            attribute.write(section);
        }
        section.getWriter().writeUByte-7apg3OU((byte)0);
        section.getWriter().writeUByte-7apg3OU((byte)0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/Abbreviation$Specification;", "", "attribute", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/DwAttribute;", "form", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DwForm;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/DwAttribute;Lorg/jetbrains/kotlin/backend/wasm/dwarf/DwForm;)V", "getAttribute", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/DwAttribute;", "getForm", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/DwForm;", "write", "", "section", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebuggingSection$DebugAbbreviations;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.wasm"})
    public static final class Specification {
        @NotNull
        private final DwAttribute attribute;
        @NotNull
        private final DwForm form;

        public Specification(@NotNull DwAttribute attribute, @NotNull DwForm form) {
            Intrinsics.checkNotNullParameter((Object)((Object)attribute), (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)((Object)form), (String)"form");
            this.attribute = attribute;
            this.form = form;
        }

        @NotNull
        public final DwAttribute getAttribute() {
            return this.attribute;
        }

        @NotNull
        public final DwForm getForm() {
            return this.form;
        }

        public final void write(@NotNull DebuggingSection.DebugAbbreviations section) {
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            section.getWriter().writeVarUInt32-WZ4Q5Ns(this.attribute.getOpcode-pVg5ArA());
            section.getWriter().writeVarUInt32-WZ4Q5Ns(this.form.getOpcode-pVg5ArA());
        }

        @NotNull
        public final DwAttribute component1() {
            return this.attribute;
        }

        @NotNull
        public final DwForm component2() {
            return this.form;
        }

        @NotNull
        public final Specification copy(@NotNull DwAttribute attribute, @NotNull DwForm form) {
            Intrinsics.checkNotNullParameter((Object)((Object)attribute), (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)((Object)form), (String)"form");
            return new Specification(attribute, form);
        }

        public static /* synthetic */ Specification copy$default(Specification specification, DwAttribute dwAttribute, DwForm dwForm, int n, Object object) {
            if ((n & 1) != 0) {
                dwAttribute = specification.attribute;
            }
            if ((n & 2) != 0) {
                dwForm = specification.form;
            }
            return specification.copy(dwAttribute, dwForm);
        }

        @NotNull
        public String toString() {
            return "Specification(attribute=" + (Object)((Object)this.attribute) + ", form=" + (Object)((Object)this.form) + ')';
        }

        public int hashCode() {
            int result = this.attribute.hashCode();
            result = result * 31 + this.form.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Specification)) {
                return false;
            }
            Specification specification = (Specification)other;
            if (this.attribute != specification.attribute) {
                return false;
            }
            return this.form == specification.form;
        }
    }
}

