/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DelegationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDescriptor", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "delegatedDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "delegatedToDescriptor", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDelegationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DelegationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n774#3:77\n865#3,2:78\n774#3:80\n865#3,2:81\n*S KotlinDebug\n*F\n+ 1 DelegationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DelegationChecker\n*L\n58#1:77\n58#1:78,2\n61#1:80\n61#1:81,2\n*E\n"})
public final class DelegationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry specifier : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            ClassDescriptor superTypeDescriptor;
            Object superType;
            ClassifierDescriptor classifierDescriptor;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Object object = ((KtDelegatedSuperTypeEntry)specifier).getTypeReference();
            if (object == null) continue;
            KtTypeReference it = object;
            boolean bl = false;
            KotlinType kotlinType = (KotlinType)context.getTrace().get(BindingContext.TYPE, it);
            object = kotlinType;
            if (kotlinType == null || ((classifierDescriptor = ((KotlinType)(superType = object)).getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null) == null) continue;
            superTypeDescriptor = superTypeDescriptor;
            for (Map.Entry entry : DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, (ClassDescriptor)descriptor, superTypeDescriptor, null, 4, null).entrySet()) {
                CallableMemberDescriptor delegated = (CallableMemberDescriptor)entry.getKey();
                CallableMemberDescriptor delegatedTo = (CallableMemberDescriptor)entry.getValue();
                this.checkDescriptor((KtClassOrObject)declaration, delegated, delegatedTo, context.getTrace());
            }
        }
    }

    private final void checkDescriptor(KtClassOrObject classDeclaration, CallableMemberDescriptor delegatedDescriptor, CallableMemberDescriptor delegatedToDescriptor, DiagnosticSink diagnosticHolder) {
        CallableMemberDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatedDescriptor);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllOverriddenDescriptors(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.getKind().isReal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set set2 = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue(set2, (String)"filterOutOverridden(...)");
        Set reachableFromDelegated = SetsKt.minus(set2, (Object)DescriptorUtils.unwrapFakeOverride(delegatedToDescriptor).getOriginal());
        $this$filter$iv = reachableFromDelegated;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.OPEN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonAbstractReachable = (List)destination$iv$iv;
        if (!((Collection)nonAbstractReachable).isEmpty()) {
            diagnosticHolder.report(Errors.DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE.on((KtClassOrObject)((PsiElement)classDeclaration), delegatedDescriptor, nonAbstractReachable));
        }
    }
}

