/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class CompilerTestUtil {
    private static final Logger LOG = Logger.getInstance(CompilerTestUtil.class);

    private CompilerTestUtil() {
    }

    @TestOnly
    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    @TestOnly
    public static void saveApplicationSettings() {
        IComponentStore store = CompilerTestUtil.getApplicationStore();
        ProjectJdkTable.getInstance().saveOnDisk();
        store.saveComponent((PersistentStateComponent)FileTypeManager.getInstance());
        store.saveComponent((PersistentStateComponent)PathMacros.getInstance());
    }

    @NotNull
    public static IComponentStore getApplicationStore() {
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
        if (iComponentStore == null) {
            CompilerTestUtil.$$$reportNull$$$0(0);
        }
        return iComponentStore;
    }

    @TestOnly
    public static void saveApplicationComponent(@NotNull PersistentStateComponent<?> appComponent) {
        if (appComponent == null) {
            CompilerTestUtil.$$$reportNull$$$0(1);
        }
        EdtTestUtil.runInEdtAndWait(() -> CompilerTestUtil.getApplicationStore().saveComponent(appComponent));
    }

    @TestOnly
    public static void enableExternalCompiler() {
        JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
        WriteAction.runAndWait(() -> {
            Sdk jdk = table.getInternalJdk();
            if (table.findJdk(jdk.getName(), jdk.getSdkType().getName()) != jdk) {
                table.addJdk(jdk);
            }
        });
    }

    @TestOnly
    public static void disableExternalCompiler(@NotNull Project project) {
        if (project == null) {
            CompilerTestUtil.$$$reportNull$$$0(2);
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            ApplicationManager.getApplication().runWriteAction(() -> {
                Sdk internalJdk = table.getInternalJdk();
                for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    ModuleRootModificationUtil.setModuleSdk((Module)module2, null);
                }
                if (table.findJdk(internalJdk.getName(), internalJdk.getSdkType().getName()) == internalJdk) {
                    table.removeJdk(internalJdk);
                }
                BuildManager.getInstance().clearState(project);
            });
            CompilerTestUtil.saveApplicationSettings();
        });
    }

    public static void deleteBuildSystemDirectory(@NotNull Project project) {
        BuildManager buildManager;
        if (project == null) {
            CompilerTestUtil.$$$reportNull$$$0(3);
        }
        if ((buildManager = BuildManager.getInstance()) == null) {
            return;
        }
        Path buildSystemDirectory = buildManager.getBuildSystemDirectory(project);
        try {
            PathKt.delete((Path)buildSystemDirectory);
            return;
        }
        catch (Exception exception) {
            try {
                FileUtil.delete((File)buildSystemDirectory.toFile());
            }
            catch (Exception e) {
                LOG.warn("Unable to remove build system directory.", (Throwable)e);
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerTestUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationStore";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveApplicationComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disableExternalCompiler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteBuildSystemDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

