/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.treeView.PathElementIdProvider;
import com.intellij.ide.util.treeView.SerializablePathElement;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNodeKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.OriginInfo;
import com.intellij.openapi.vcs.impl.PlatformVcsPathPresenter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000 A*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u0004:\u0001AB\u0019\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u0004\u0018\u00010*J\u001d\u0010+\u001a\u00070*\u00a2\u0006\u0002\b,2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010-\u001a\u00020\rJ\u0014\u0010.\u001a\u00020\u001f2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0017J\b\u00100\u001a\u00020*H\u0016J\u0012\u00101\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u000102H\u0016J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0014H\u0002J\u001f\u00109\u001a\u00070*\u00a2\u0006\u0002\b,2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010-\u001a\u00020\rH\u0014J\b\u0010:\u001a\u00020*H\u0016J\b\u0010;\u001a\u00020*H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0015\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010@R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u00105\u001a\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006B"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "U", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/ide/util/treeView/PathElementIdProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$NodeWithCollapsedParents;", "userObject", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "<init>", "(Ljava/lang/Object;Lcom/intellij/openapi/vcs/FileStatus;)V", "getStatus", "()Lcom/intellij/openapi/vcs/FileStatus;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "flattenedParents", "", "Lcom/intellij/ide/util/treeView/SerializablePathElement;", "originInfo", "Lcom/intellij/openapi/vcs/changes/ui/OriginInfo;", "getOriginInfo", "()Lcom/intellij/openapi/vcs/changes/ui/OriginInfo;", "originInfo$delegate", "Lkotlin/Lazy;", "(Ljava/lang/Object;)Lcom/intellij/openapi/vcs/FilePath;", "originPath", "isFile", "", "isDirectory", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "getBackgroundColor", "Ljava/awt/Color;", "project", "Lcom/intellij/openapi/project/Project;", "getOriginText", "", "getRelativeFilePath", "Lcom/intellij/openapi/util/NlsSafe;", "path", "addCollapsedParent", "parentNode", "getPathElementId", "getFlattenedElements", "", "appendOriginText", "buildOriginInfo", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "getRelativePath", "getTextPresentation", "toString", "getSortWeight", "", "compareUserObjects", "o2", "(Ljava/lang/Object;)I", "Companion", "intellij.platform.vcs.impl"})
public abstract class AbstractChangesBrowserFilePathNode<U>
extends ChangesBrowserNode<U>
implements PathElementIdProvider,
ChangesBrowserNode.NodeWithCollapsedParents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FileStatus status;
    @NotNull
    private final List<SerializablePathElement> flattenedParents;
    @NotNull
    private final Lazy originInfo$delegate;

    public AbstractChangesBrowserFilePathNode(U userObject, @Nullable FileStatus status) {
        super(userObject);
        this.status = status;
        this.flattenedParents = new ArrayList();
        this.originInfo$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> AbstractChangesBrowserFilePathNode.originInfo_delegate$lambda$0(this));
    }

    @Nullable
    public final FileStatus getStatus() {
        return this.status;
    }

    private final FilePath getFilePath() {
        return this.filePath(this.getUserObject());
    }

    private final OriginInfo getOriginInfo() {
        Lazy lazy = this.originInfo$delegate;
        return (OriginInfo)lazy.getValue();
    }

    @NotNull
    protected abstract FilePath filePath(U var1);

    @Nullable
    protected FilePath originPath(U userObject) {
        return null;
    }

    @Override
    protected boolean isFile() {
        return !this.getFilePath().isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return this.getFilePath().isDirectory() && this.isLeaf();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        FilePath path = this.getFilePath();
        if (renderer.isShowFlatten() && this.isLeaf()) {
            renderer.append(path.getName(), this.getTextAttributes());
            this.appendOriginText(renderer);
            this.appendParentPath(renderer, path.getParentPath());
        } else {
            renderer.append(this.getRelativePath(renderer, path), this.getTextAttributes());
            this.appendOriginText(renderer);
        }
        if (!this.isLeaf()) {
            this.appendCount(renderer);
        }
        renderer.setIcon(path, path.isDirectory() || !this.isLeaf());
    }

    @Override
    @Nullable
    public Color getBackgroundColor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ChangesBrowserNode.getBackgroundColorFor(project, this.getFilePath());
    }

    @Nullable
    public final String getOriginText() {
        OriginInfo originInfo = this.getOriginInfo();
        return originInfo != null ? ChangesBrowserFilePathNodeKt.access$getText(originInfo) : null;
    }

    @NotNull
    public final String getRelativeFilePath(@Nullable Project project, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean isLocal = !path.isNonLocal();
        FilePath parentPath = Companion.safeCastToFilePath((ChangesBrowserNode<?>)this.getParent());
        if (parentPath != null) {
            String string;
            boolean caseSensitive = isLocal && SystemInfo.isFileSystemCaseSensitive;
            String relativePath = FileUtil.getRelativePath((String)parentPath.getPath(), (String)path.getPath(), (char)'/', (boolean)caseSensitive);
            String string2 = relativePath;
            if (string2 == null) {
                String string3 = path.getPath();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            }
            String prettyPath = string2;
            if (isLocal) {
                String string4 = FileUtil.toSystemDependentName((String)prettyPath);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toSystemDependentName(...)");
            } else {
                string = prettyPath;
            }
            return string;
        }
        if (isLocal) {
            String string = VcsUtil.getPresentablePath((Project)project, (FilePath)path, (boolean)true, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentablePath(...)");
            return string;
        }
        String string = path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Override
    @ApiStatus.Internal
    public void addCollapsedParent(@NotNull ChangesBrowserNode<?> parentNode) {
        Intrinsics.checkNotNullParameter(parentNode, (String)"parentNode");
        Object parentUserObject = parentNode.getUserObject();
        if (!(parentUserObject instanceof FilePath)) {
            return;
        }
        PathElementIdProvider pathElementIdProvider = parentNode instanceof PathElementIdProvider ? (PathElementIdProvider)parentNode : null;
        List parentsFromProvider = pathElementIdProvider != null ? pathElementIdProvider.getFlattenedElements() : null;
        boolean bl = parentsFromProvider != null ? this.flattenedParents.addAll(parentsFromProvider) : this.flattenedParents.add(new SerializablePathElement(((FilePath)parentUserObject).getName(), TreeState.defaultPathElementType(parentNode)));
    }

    @NotNull
    public String getPathElementId() {
        String string = this.getFilePath().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    public List<SerializablePathElement> getFlattenedElements() {
        if (this.flattenedParents.isEmpty()) {
            return null;
        }
        return CollectionsKt.plus((Collection)this.flattenedParents, (Object)new SerializablePathElement(this.getPathElementId(), TreeState.defaultPathElementType((Object)this)));
    }

    private final void appendOriginText(ChangesBrowserNodeRenderer renderer) {
        block0: {
            OriginInfo originInfo = this.getOriginInfo();
            if (originInfo == null) break block0;
            OriginInfo it = originInfo;
            boolean bl = false;
            renderer.append(FontUtil.spaceAndThinSpace() + ChangesBrowserFilePathNodeKt.access$getText(it), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private final OriginInfo buildOriginInfo() {
        OriginInfo originInfo;
        FilePath filePath = this.originPath(this.getUserObject());
        if (filePath == null) {
            return null;
        }
        FilePath originPath = filePath;
        FilePath path = this.getFilePath();
        boolean areParentsEqual = ChangesUtil.equalsCaseSensitive((FilePath)path.getParentPath(), (FilePath)originPath.getParentPath());
        if (!areParentsEqual) {
            String string = PlatformVcsPathPresenter.getPresentableRelativePath(path, originPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableRelativePath(...)");
            originInfo = new OriginInfo.Moved(string);
        } else if (!Intrinsics.areEqual((Object)path.getName(), (Object)originPath.getName())) {
            String string = originPath.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            originInfo = new OriginInfo.Renamed(string);
        } else {
            originInfo = null;
        }
        return originInfo;
    }

    private final SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes;
        if (this.status != null) {
            simpleTextAttributes = new SimpleTextAttributes(0, this.status.getColor());
        } else {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    @NotNull
    protected String getRelativePath(@Nullable ChangesBrowserNodeRenderer renderer, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ChangesBrowserNodeRenderer changesBrowserNodeRenderer = renderer;
        return this.getRelativeFilePath((Project)(changesBrowserNodeRenderer != null ? changesBrowserNodeRenderer.getProject() : null), path);
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        return this.getRelativePath(null, this.getFilePath());
    }

    @Override
    @NotNull
    public String toString() {
        String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    @Override
    public int getSortWeight() {
        return this.getFilePath().isDirectory() ? 5 : 6;
    }

    @Override
    public int compareUserObjects(U o2) {
        return ChangesBrowserNode.compareFilePaths(this.getFilePath(), this.filePath(o2));
    }

    private static final OriginInfo originInfo_delegate$lambda$0(AbstractChangesBrowserFilePathNode this$0) {
        return this$0.buildOriginInfo();
    }

    @JvmStatic
    @Nullable
    public static final FilePath safeCastToFilePath(@Nullable ChangesBrowserNode<?> node) {
        return Companion.safeCastToFilePath(node);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode$Companion;", "", "<init>", "()V", "safeCastToFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final FilePath safeCastToFilePath(@Nullable ChangesBrowserNode<?> node) {
            if (node == null) {
                return null;
            }
            if (node instanceof ChangesBrowserNode.NodeWithFilePath) {
                return ((ChangesBrowserNode.NodeWithFilePath)((Object)node)).getNodeFilePath();
            }
            Object o = node.getUserObject();
            if (o instanceof FilePath) {
                return (FilePath)o;
            }
            if (o instanceof Change) {
                return ChangesUtil.getAfterPath((Change)((Change)o));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

