/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.SourceRootPropertiesHelper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.utils.Url;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;

public final class MavenSourceFoldersModuleExtension
extends ModuleExtension {
    private ModifiableRootModel myRootModel;
    private JpsModule myDummyJpsModule;
    private JpsRootModel myDummyJpsRootModel;
    private final Set<JpsSourceFolder> myJpsSourceFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
    private boolean isJpsSourceFoldersChanged;
    private final Project myProject;

    MavenSourceFoldersModuleExtension(Module module) {
        this(module.getProject());
    }

    @NonInjectable
    MavenSourceFoldersModuleExtension(Project project) {
        this.myProject = project;
    }

    public void init(@NotNull Module module, @NotNull ModifiableRootModel modifiableRootModel) {
        if (module == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(0);
        }
        if (modifiableRootModel == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(1);
        }
        this.myRootModel = modifiableRootModel;
        this.myDummyJpsModule = JpsElementFactory.getInstance().createModule(module.getName(), (JpsModuleType)JpsJavaModuleType.INSTANCE, (JpsElement)JpsElementFactory.getInstance().createDummyElement());
        this.myDummyJpsRootModel = new JpsRootModel(module, this.myDummyJpsModule);
        for (JpsSourceFolder folder : this.myJpsSourceFolders) {
            Disposer.dispose((Disposable)folder);
        }
        this.myJpsSourceFolders.clear();
        for (ContentEntry eachEntry : modifiableRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                JpsModuleSourceRootType rootType = eachFolder.getRootType();
                JpsModuleSourceRoot jpsModuleSourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(eachFolder.getUrl(), rootType, SourceRootPropertiesHelper.createPropertiesCopy((JpsElement)eachFolder.getJpsElement().getProperties(), (JpsModuleSourceRootType)rootType));
                this.addJspSourceFolder(jpsModuleSourceRoot, eachFolder.getUrl());
            }
        }
    }

    @NotNull
    public ModuleExtension getModifiableModel(boolean writable) {
        return new MavenSourceFoldersModuleExtension(this.myProject);
    }

    public void commit() {
        if (!this.isJpsSourceFoldersChanged) {
            return;
        }
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                boolean found = false;
                for (JpsSourceFolder jpsSourceFolder : this.myJpsSourceFolders) {
                    if (!StringUtil.equals((CharSequence)jpsSourceFolder.getUrl(), (CharSequence)eachFolder.getUrl()) || !eachFolder.getRootType().equals(jpsSourceFolder.getRootType())) continue;
                    found = true;
                    if (eachFolder.getRootType() instanceof JavaSourceRootType) {
                        JavaSourceRootProperties jpsJavaSourceRootProperties = (JavaSourceRootProperties)jpsSourceFolder.getJpsElement().getProperties((JpsModuleSourceRootType)((JavaSourceRootType)eachFolder.getRootType()));
                        JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)eachFolder.getJpsElement().getProperties((JpsModuleSourceRootType)((JavaSourceRootType)eachFolder.getRootType()));
                        if (javaSourceRootProperties != null && jpsJavaSourceRootProperties != null) {
                            javaSourceRootProperties.setPackagePrefix(jpsJavaSourceRootProperties.getPackagePrefix());
                            javaSourceRootProperties.setForGeneratedSources(jpsJavaSourceRootProperties.isForGeneratedSources());
                        }
                    }
                    this.myJpsSourceFolders.remove(jpsSourceFolder);
                    Disposer.dispose((Disposable)jpsSourceFolder);
                    break;
                }
                if (found) continue;
                eachEntry.removeSourceFolder(eachFolder);
            }
        }
        for (JpsSourceFolder jpsSourceFolder : this.myJpsSourceFolders) {
            Url url = new Url(jpsSourceFolder.getUrl());
            ContentEntry e = this.getContentRootFor(url);
            if (e == null) continue;
            JpsModuleSourceRootType sourceRootType = jpsSourceFolder.getRootType();
            JpsElementBase properties = (JpsElementBase)jpsSourceFolder.getSourceRoot().getProperties();
            properties.setParent(null);
            e.addSourceFolder(url.getUrl(), sourceRootType, (JpsElement)properties, MavenRootModelAdapter.getMavenExternalSource());
        }
        this.isJpsSourceFoldersChanged = false;
    }

    public boolean isChanged() {
        return this.isJpsSourceFoldersChanged;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(2);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(3);
        }
    }

    public <P extends JpsElement> void addSourceFolder(@NotNull Url url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (url == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(4);
        }
        if (rootType == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(6);
        }
        Iterator<JpsSourceFolder> iterator = this.myJpsSourceFolders.iterator();
        while (iterator.hasNext()) {
            JpsSourceFolder eachFolder = iterator.next();
            if (!VfsUtilCore.isEqualOrAncestor((String)url.getUrl(), (String)eachFolder.getUrl()) && !VfsUtilCore.isEqualOrAncestor((String)eachFolder.getUrl(), (String)url.getUrl())) continue;
            iterator.remove();
            Disposer.dispose((Disposable)eachFolder);
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url.getUrl(), rootType, properties);
        this.addJspSourceFolder(jpsModuleSourceRoot, url.getUrl());
        this.isJpsSourceFoldersChanged = true;
    }

    @Nullable
    private ContentEntry getContentRootFor(@NotNull Url url) {
        if (url == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(7);
        }
        for (ContentEntry e : this.myRootModel.getContentEntries()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)e.getUrl(), (String)url.getUrl())) continue;
            return e;
        }
        return null;
    }

    public void unregisterAll(@NotNull Url url, boolean under) {
        if (url == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(8);
        }
        Iterator<JpsSourceFolder> iterator = this.myJpsSourceFolders.iterator();
        while (iterator.hasNext()) {
            String child;
            JpsSourceFolder eachFolder = iterator.next();
            String ancestor = under ? url.getUrl() : eachFolder.getUrl();
            if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = under ? eachFolder.getUrl() : url.getUrl()))) continue;
            iterator.remove();
            Disposer.dispose((Disposable)eachFolder);
            this.isJpsSourceFoldersChanged = true;
        }
    }

    private void addJspSourceFolder(@NotNull JpsModuleSourceRoot jpsModuleSourceRoot, @NotNull String url) {
        if (jpsModuleSourceRoot == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(9);
        }
        if (url == null) {
            MavenSourceFoldersModuleExtension.$$$reportNull$$$0(10);
        }
        JpsContentEntry dummyJpsContentEntry = new JpsContentEntry(this.myDummyJpsModule, this.myDummyJpsRootModel, url);
        JpsSourceFolder jpsSourceFolder = new JpsSourceFolder(jpsModuleSourceRoot, dummyJpsContentEntry);
        this.myJpsSourceFolders.add(jpsSourceFolder);
        Disposer.register((Disposable)jpsSourceFolder, (Disposable)dummyJpsContentEntry);
        Disposable parentDisposable = (Disposable)this.myProject.getService(ProjectLevelDisposableService.class);
        Disposer.register((Disposable)parentDisposable, (Disposable)jpsSourceFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jpsModuleSourceRoot";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourceFolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentRootFor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterAll";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addJspSourceFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(@NotNull ContentFolder o1, @NotNull ContentFolder o2) {
            if (o1 == null) {
                ContentFolderComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                ContentFolderComparator.$$$reportNull$$$0(1);
            }
            return StringUtil.naturalCompare((String)o1.getUrl(), (String)o2.getUrl());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/MavenSourceFoldersModuleExtension$ContentFolderComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Service(value={Service.Level.PROJECT})
    static final class ProjectLevelDisposableService
    implements Disposable {
        ProjectLevelDisposableService() {
        }

        public void dispose() {
        }
    }
}

