/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public abstract class YamlMetaType {
    @NotNull
    private final String myTypeName;
    @Nullable
    private String myDisplayName;

    protected YamlMetaType(@NonNls @NotNull String typeName, @NonNls @NotNull String displayName) {
        if (typeName == null) {
            YamlMetaType.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            YamlMetaType.$$$reportNull$$$0(1);
        }
        this.myTypeName = typeName;
        this.myDisplayName = displayName;
    }

    protected YamlMetaType(@NonNls @NotNull String typeName) {
        if (typeName == null) {
            YamlMetaType.$$$reportNull$$$0(2);
        }
        this.myTypeName = typeName;
        this.myDisplayName = null;
    }

    @Contract(pure=true)
    @NotNull
    public final String getTypeName() {
        String string = this.myTypeName;
        if (string == null) {
            YamlMetaType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName == null ? this.myTypeName : this.myDisplayName;
        if (string == null) {
            YamlMetaType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Json.Object;
        if (icon == null) {
            YamlMetaType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Deprecated(forRemoval=true)
    public void setDisplayName(@NonNls @NotNull String displayName) {
        if (displayName == null) {
            YamlMetaType.$$$reportNull$$$0(6);
        }
        if (this.myDisplayName != null) {
            Logger.getInstance(YamlMetaType.class).error("reinitialising 'myDisplayName' with value '" + displayName + "', previous value: '" + this.myDisplayName + "'. Please avoid calling the `setDisplayName` method out of initialisation step, or better switch to constructor 'YamlMetaType(String typeName, String displayName)' for initialisation");
        }
        this.myDisplayName = displayName;
    }

    @Nullable
    public abstract Field findFeatureByName(@NotNull String var1);

    @NotNull
    public abstract List<String> computeMissingFields(@NotNull Set<String> var1);

    @NotNull
    public abstract List<Field> computeKeyCompletions(@Nullable YAMLMapping var1);

    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        if (keyValue == null) {
            YamlMetaType.$$$reportNull$$$0(7);
        }
        if (problemsHolder == null) {
            YamlMetaType.$$$reportNull$$$0(8);
        }
    }

    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        if (value == null) {
            YamlMetaType.$$$reportNull$$$0(9);
        }
        if (problemsHolder == null) {
            YamlMetaType.$$$reportNull$$$0(10);
        }
    }

    public void validateDeep(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        if (value == null) {
            YamlMetaType.$$$reportNull$$$0(11);
        }
        if (problemsHolder == null) {
            YamlMetaType.$$$reportNull$$$0(12);
        }
        this.validateValue(value, problemsHolder);
        if (value instanceof YAMLMapping) {
            YAMLMapping mapping = (YAMLMapping)value;
            Collection keyValues = mapping.getKeyValues();
            List<String> missingKeys = this.computeMissingFields(keyValues.stream().map(it -> it.getKeyText().trim()).collect(Collectors.toSet()));
            if (!missingKeys.isEmpty()) {
                String msg = YAMLBundle.message((String)"YamlMissingKeysInspectionBase.missing.keys", (Object[])new Object[]{String.join((CharSequence)", ", missingKeys)});
                problemsHolder.registerProblem((PsiElement)mapping, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            for (YAMLKeyValue keyValue : keyValues) {
                String featureName = keyValue.getKeyText().trim();
                if (featureName.isEmpty()) continue;
                Field feature = this.findFeatureByName(featureName);
                if (feature == null) {
                    String msg = YAMLBundle.message((String)"YamlUnknownKeysInspectionBase.unknown.key", (Object[])new Object[]{keyValue.getKeyText()});
                    PsiElement key = keyValue.getKey();
                    assert (key != null);
                    problemsHolder.registerProblem(key, msg, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                    continue;
                }
                YAMLValue subValue = keyValue.getValue();
                if (subValue == null) {
                    if (feature.isEmptyValueAllowed()) continue;
                    continue;
                }
                Field.Relation relation = subValue instanceof YAMLScalar ? Field.Relation.SCALAR_VALUE : (subValue instanceof YAMLSequence ? Field.Relation.SEQUENCE_ITEM : Field.Relation.OBJECT_CONTENTS);
                YamlMetaType subType = feature.getType(relation);
                if (!(subValue instanceof YAMLSequence)) {
                    subType.validateDeep(subValue, problemsHolder);
                    continue;
                }
                List sequenceItems = ((YAMLSequence)subValue).getItems();
                for (YAMLSequenceItem item : sequenceItems) {
                    YAMLValue itemValue = item.getValue();
                    if (itemValue == null) {
                        if (feature.isEmptyValueAllowed()) continue;
                        continue;
                    }
                    subType.validateDeep(itemValue, problemsHolder);
                }
            }
        }
    }

    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        if (insertedScalar == null) {
            YamlMetaType.$$$reportNull$$$0(13);
        }
        List list = Collections.emptyList();
        if (list == null) {
            YamlMetaType.$$$reportNull$$$0(14);
        }
        return list;
    }

    public abstract void buildInsertionSuffixMarkup(@NotNull YamlInsertionMarkup var1, @NotNull Field.Relation var2, @NotNull ForcedCompletionPath.Iteration var3);

    protected static void buildCompleteKeyMarkup(@NotNull YamlInsertionMarkup markup, @NotNull Field feature, @NotNull ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlMetaType.$$$reportNull$$$0(15);
        }
        if (feature == null) {
            YamlMetaType.$$$reportNull$$$0(16);
        }
        if (iteration == null) {
            YamlMetaType.$$$reportNull$$$0(17);
        }
        markup.append(feature.getName());
        Field.Relation defaultRelation = feature.getDefaultRelation();
        YamlMetaType defaultType = feature.getType(defaultRelation);
        defaultType.buildInsertionSuffixMarkup(markup, defaultRelation, iteration);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.myTypeName + "@" + Integer.toHexString(this.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLookups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateKey";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validateDeep";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValueLookups";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildCompleteKeyMarkup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 14 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class YamlInsertionMarkup {
        public static final String CRLF_MARKUP = "<crlf>";
        public static final String CARET_MARKUP = "<caret>";
        public static final String SEQUENCE_ITEM_MARKUP = "- ";
        private final StringBuilder myOutput;
        private final String myTabSymbol;
        private int myLevel;
        private boolean myCaretAppended;
        private final YAMLCodeStyleSettings mySettings;

        public YamlInsertionMarkup(@NotNull InsertionContext context) {
            if (context == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(0);
            }
            this(YamlInsertionMarkup.getTabSymbol(context), (YAMLCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getFile(), YAMLCodeStyleSettings.class));
        }

        public YamlInsertionMarkup(@NotNull String tabSymbol, YAMLCodeStyleSettings settings) {
            if (tabSymbol == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(1);
            }
            this.myOutput = new StringBuilder();
            this.myTabSymbol = tabSymbol;
            this.mySettings = settings;
        }

        public void append(@NotNull String text) {
            if (text == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(2);
            }
            this.myOutput.append(text);
        }

        public void newLineAndTabs() {
            this.newLineAndTabs(false);
        }

        public void newLineAndTabs(boolean withSequenceItemMark) {
            if (withSequenceItemMark) assert (this.myLevel > 0);
            this.append(CRLF_MARKUP);
            if (withSequenceItemMark) {
                this.append(this.tabs(this.myLevel - 1));
                this.append(this.sequenceItemPrefix());
            } else {
                this.append(this.tabs(this.myLevel));
            }
        }

        @NotNull
        private String sequenceItemPrefix() {
            Object result = SEQUENCE_ITEM_MARKUP;
            if (this.myTabSymbol.length() > ((String)result).length()) {
                result = (String)result + this.myTabSymbol.substring(((String)result).length());
            }
            String string = result;
            if (string == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void doTabbedBlockForSequenceItem(Runnable doWhenTabbed) {
            int indent = this.mySettings.INDENT_SEQUENCE_VALUE ? 2 : 1;
            this.doTabbedBlock(indent, () -> {
                this.newLineAndTabs(true);
                doWhenTabbed.run();
            });
        }

        public void doTabbedBlockForSequenceItem() {
            this.doTabbedBlockForSequenceItem(() -> {});
        }

        public void appendCaret() {
            if (!this.myCaretAppended) {
                this.append(CARET_MARKUP);
            }
            this.myCaretAppended = true;
        }

        public String getMarkup() {
            return this.myOutput.toString();
        }

        public void increaseTabs(int indent) {
            assert (indent > 0);
            this.myLevel += indent;
        }

        public void doTabbedBlock(int indent, @NotNull Runnable doWhenTabbed) {
            if (doWhenTabbed == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(4);
            }
            this.increaseTabs(indent);
            try {
                doWhenTabbed.run();
            }
            finally {
                this.decreaseTabs(indent);
            }
        }

        @NotNull
        public String getTabSymbol() {
            String string = this.myTabSymbol;
            if (string == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void decreaseTabs(int indent) {
            assert (indent <= this.myLevel);
            this.myLevel -= indent;
        }

        private String tabs(int level) {
            return StringUtil.repeat((String)this.myTabSymbol, (int)level);
        }

        @NotNull
        private static String getTabSymbol(@NotNull InsertionContext context) {
            if (context == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(6);
            }
            String string = StringUtil.repeatSymbol((char)' ', (int)CodeStyle.getIndentSize((PsiFile)context.getFile()));
            if (string == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(7);
            }
            return string;
        }

        public void insertStringAndCaret(Editor editor, String commonPadding) {
            String insertionMarkup = this.getMarkup();
            String suffixWithCaret = insertionMarkup.replace(CRLF_MARKUP, "\n" + commonPadding);
            int caretIndex = suffixWithCaret.indexOf(CARET_MARKUP);
            String suffix = suffixWithCaret.replace(CARET_MARKUP, "");
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)suffix, (boolean)false, (boolean)true, (int)caretIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabSymbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$YamlInsertionMarkup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doWhenTabbed";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$YamlInsertionMarkup";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sequenceItemPrefix";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doTabbedBlock";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTabSymbol";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class ForcedCompletionPath {
        private static final Iteration OFF_PATH_ITERATION = new OffPathIteration();
        private static final Iteration NULL_ITERATION = new NullIteration();
        private static final ForcedCompletionPath NULL_PATH = new ForcedCompletionPath(null);
        @Nullable
        private final List<Field> myCompletionPath;

        @NotNull
        public static ForcedCompletionPath forDeepCompletion(@NotNull List<Field> completionPath) {
            if (completionPath == null) {
                ForcedCompletionPath.$$$reportNull$$$0(0);
            }
            return new ForcedCompletionPath(completionPath);
        }

        @NotNull
        public static ForcedCompletionPath nullPath() {
            ForcedCompletionPath forcedCompletionPath = NULL_PATH;
            if (forcedCompletionPath == null) {
                ForcedCompletionPath.$$$reportNull$$$0(1);
            }
            return forcedCompletionPath;
        }

        private ForcedCompletionPath(@Nullable List<Field> completionPath) {
            this.myCompletionPath = completionPath;
        }

        @NotNull
        public String getName() {
            if (this.myCompletionPath == null) {
                return "<null>";
            }
            String string = this.myCompletionPath.stream().map(Field::getName).collect(Collectors.joining("."));
            if (string == null) {
                ForcedCompletionPath.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public YamlMetaType getFinalizingType() {
            if (this.myCompletionPath == null || this.myCompletionPath.size() < 2) {
                return null;
            }
            return this.myCompletionPath.get(this.myCompletionPath.size() - 2).getDefaultType();
        }

        @Nullable
        public Field getFinalizingField() {
            if (this.myCompletionPath == null || this.myCompletionPath.isEmpty()) {
                return null;
            }
            return this.myCompletionPath.get(this.myCompletionPath.size() - 1);
        }

        public Iteration start() {
            return this.myCompletionPath != null ? new OnPathIteration(1) : NULL_ITERATION;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getName() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionPath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nullPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forDeepCompletion";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }

        private final class OnPathIteration
        implements Iteration {
            private final int myPosition;

            private OnPathIteration(int position) {
                this.myPosition = position;
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                if (field == null) {
                    OnPathIteration.$$$reportNull$$$0(0);
                }
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return !this.isEndOfPathReached() && field.equals(ForcedCompletionPath.this.myCompletionPath.get(this.myPosition));
            }

            @Override
            public boolean isEndOfPathReached() {
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return this.myPosition >= ForcedCompletionPath.this.myCompletionPath.size();
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                if (field == null) {
                    OnPathIteration.$$$reportNull$$$0(1);
                }
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                Iteration iteration = this.isEndOfPathReached() || field.equals(ForcedCompletionPath.this.myCompletionPath.get(this.myPosition)) ? new OnPathIteration(this.myPosition + 1) : OFF_PATH_ITERATION;
                if (iteration == null) {
                    OnPathIteration.$$$reportNull$$$0(2);
                }
                return iteration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OnPathIteration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OnPathIteration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextIterationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isNextOnPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "nextIterationFor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        public static interface Iteration {
            public boolean isEndOfPathReached();

            public boolean isNextOnPath(@NotNull Field var1);

            @NotNull
            public Iteration nextIterationFor(@NotNull Field var1);
        }

        private static class OffPathIteration
        implements Iteration {
            private OffPathIteration() {
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                if (field == null) {
                    OffPathIteration.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public boolean isEndOfPathReached() {
                return false;
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                if (field == null) {
                    OffPathIteration.$$$reportNull$$$0(1);
                }
                OffPathIteration offPathIteration = this;
                if (offPathIteration == null) {
                    OffPathIteration.$$$reportNull$$$0(2);
                }
                return offPathIteration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OffPathIteration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OffPathIteration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextIterationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isNextOnPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "nextIterationFor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        private static class NullIteration
        implements Iteration {
            private NullIteration() {
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                if (field == null) {
                    NullIteration.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public boolean isEndOfPathReached() {
                return true;
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                if (field == null) {
                    NullIteration.$$$reportNull$$$0(1);
                }
                NullIteration nullIteration = this;
                if (nullIteration == null) {
                    NullIteration.$$$reportNull$$$0(2);
                }
                return nullIteration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$NullIteration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$NullIteration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextIterationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isNextOnPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "nextIterationFor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

