/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestInClassConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestUniqueId;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public final class UniqueIdConfigurationProducer
extends JUnitConfigurationProducer
implements DumbAware {
    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        String[] nodeIds;
        if (configuration == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((nodeIds = UniqueIdConfigurationProducer.getNodeIds(context)) == null || nodeIds.length == 0) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setUniqueIds(nodeIds);
        data.TEST_OBJECT = "uniqueId";
        AbstractTestProxy selectedProxy = (AbstractTestProxy)context.getDataContext().getData(AbstractTestProxy.DATA_KEY);
        if (selectedProxy != null) {
            configuration.setName(UniqueIdConfigurationProducer.getGeneratedName(selectedProxy, configuration));
        } else {
            configuration.setGeneratedName();
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        return true;
    }

    private static String getGeneratedName(@NotNull AbstractTestProxy selectedProxy, @NotNull JUnitConfiguration configuration) {
        Location location;
        GlobalSearchScope searchScope;
        if (selectedProxy == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((searchScope = configuration.getSearchScope()) != null && (location = selectedProxy.getLocation(configuration.getProject(), searchScope)) instanceof MethodLocation) {
            MethodLocation methodLocation = (MethodLocation)location;
            StringJoiner stringJoiner = new StringJoiner(".");
            stringJoiner.add(methodLocation.getContainingClass().getName());
            String methodName = methodLocation.getPsiElement().getName();
            String proxyName = selectedProxy.getName();
            if (!proxyName.startsWith(methodName + "(")) {
                stringJoiner.add(methodName);
            }
            stringJoiner.add(proxyName);
            return stringJoiner.toString();
        }
        return selectedProxy.getName();
    }

    protected boolean isConfiguredByElement(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull PsiElement element) {
        if (configuration == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (element == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(7);
        }
        return Arrays.equals(configuration.getPersistentData().getUniqueIds(), UniqueIdConfigurationProducer.getNodeIds(context));
    }

    public static String[] getNodeIds(ConfigurationContext context) {
        GlobalSearchScope searchScope;
        Module module;
        DataContext dataContext = context.getDataContext();
        AbstractTestProxy[] testProxies = (AbstractTestProxy[])dataContext.getData(AbstractTestProxy.DATA_KEYS);
        if (testProxies == null) {
            return null;
        }
        RunConfiguration runConfiguration = (RunConfiguration)dataContext.getData(RunConfiguration.DATA_KEY);
        if (runConfiguration instanceof JUnitConfiguration) {
            module = ((JavaRunConfigurationModule)((JUnitConfiguration)runConfiguration).getConfigurationModule()).getModule();
        } else if (runConfiguration == null) {
            module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
            if (module == null) {
                return null;
            }
        } else {
            return null;
        }
        Project project = context.getProject();
        GlobalSearchScope globalSearchScope = searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)project);
        if (!((Boolean)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> JUnitUtil.isJUnit5((GlobalSearchScope)searchScope, (Project)project) || TestObject.hasJUnit5EnginesAPI(searchScope, JavaPsiFacade.getInstance((Project)project)))).booleanValue()) {
            return null;
        }
        return (String[])Arrays.stream(testProxies).map(testProxy -> TestUniqueId.getEffectiveNodeId(testProxy, project, searchScope)).filter(Objects::nonNull).toArray(String[]::new);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "uniqueId".equals(type);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (other == null) {
            UniqueIdConfigurationProducer.$$$reportNull$$$0(9);
        }
        return self.isProducedBy(UniqueIdConfigurationProducer.class) && (other.isProducedBy(TestInClassConfigurationProducer.class) || other.isProducedBy(PatternConfigurationProducer.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProxy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/UniqueIdConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGeneratedName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfiguredByElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldReplace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

