/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.testDiscovery;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class JUnitTestDiscoveryConfigurationProducer
extends TestDiscoveryConfigurationProducer {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = JUnitConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected void setPosition(JavaTestConfigurationBase configuration, PsiLocation<PsiMethod> position) {
        ((JUnitConfiguration)configuration).beFromSourcePosition(position);
    }

    protected Pair<String, String> getPosition(JavaTestConfigurationBase configuration) {
        JUnitConfiguration.Data data = ((JUnitConfiguration)configuration).getPersistentData();
        if (data.TEST_OBJECT.equals("source location")) {
            return Pair.create((Object)data.getMainClassName(), (Object)data.getMethodName());
        }
        return null;
    }

    public boolean isApplicable(@NotNull Location<PsiMethod> testMethod) {
        if (testMethod == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(1);
        }
        return JUnitUtil.isTestMethod(testMethod);
    }

    @NotNull
    public RunProfileState createProfile(Location<PsiMethod> @NotNull [] testMethods, final Module module, RunConfiguration configuration, ExecutionEnvironment environment) {
        if (testMethods == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(2);
        }
        JUnitConfiguration.Data data = ((JUnitConfiguration)configuration).getPersistentData();
        data.setPatterns(JUnitTestDiscoveryConfigurationProducer.collectMethodPatterns(testMethods));
        data.TEST_OBJECT = "pattern";
        final Map<Module, Module> toRoot = JUnitTestDiscoveryConfigurationProducer.splitModulesIntoChunks(testMethods, module);
        return new TestsPattern((JUnitConfiguration)configuration, environment){

            protected boolean forkPerModule() {
                return module == null;
            }

            @Override
            protected void fillForkModule(Map<Module, List<String>> perModule, Module module2, String name) {
                super.fillForkModule(perModule, (Module)toRoot.get(module2), name);
            }
        };
    }

    private static Map<Module, Module> splitModulesIntoChunks(Location<PsiMethod> @NotNull [] testMethods, Module module) {
        if (testMethods == null) {
            JUnitTestDiscoveryConfigurationProducer.$$$reportNull$$$0(3);
        }
        HashMap<Module, Module> toRoot = new HashMap<Module, Module>();
        if (module == null) {
            Set usedModules = Arrays.stream(testMethods).map(Location::getModule).collect(Collectors.toSet());
            while (!usedModules.isEmpty()) {
                HashMap<Module, Set> allDeps = new HashMap<Module, Set>();
                for (Module usedModule : usedModules) {
                    List rootModules = ModuleUtilCore.getAllDependentModules((Module)usedModule);
                    for (Module rootModule : rootModules) {
                        allDeps.computeIfAbsent(rootModule, __ -> new LinkedHashSet()).add(usedModule);
                    }
                    allDeps.computeIfAbsent(usedModule, __ -> new LinkedHashSet()).add(usedModule);
                }
                Optional<Map.Entry> maxDependency = allDeps.entrySet().stream().max(Comparator.comparingInt(e -> ((Set)e.getValue()).size()));
                if (!maxDependency.isPresent()) break;
                Map.Entry entry = maxDependency.get();
                Module rootModule = (Module)entry.getKey();
                Set srcModules = (Set)entry.getValue();
                for (Module srcModule : srcModules) {
                    toRoot.put(srcModule, rootModule);
                }
                usedModules.removeAll(srcModules);
            }
        }
        return toRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfigurationProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/testDiscovery/JUnitTestDiscoveryConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProfile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitModulesIntoChunks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

