/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFileReferenceProvider;

public final class JavaFxReferencesContributor
extends PsiReferenceContributor {
    public static final PsiJavaElementPattern.Capture<PsiLiteralExpression> STYLESHEET_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().methodCallParameter((ElementPattern)PsiJavaPatterns.psiMethod())).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiExpression psiExpression = JavaFxReferencesContributor.getParentElement((PsiLiteralExpression)context);
            if (psiExpression != null) {
                PsiType psiType = psiExpression.getType();
                return psiType != null && psiType.equalsToText("javafx.scene.Parent");
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));
    public static final PsiJavaElementPattern.Capture<PsiLiteralExpression> FXML_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().methodCallParameter((ElementPattern)PsiJavaPatterns.psiMethod().withName("getResource"))).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement resolve;
            PsiJavaCodeReferenceElement reference;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)context;
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)literalExpression, PsiMethodCallExpression.class);
            PsiCallExpression superCall = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, PsiCallExpression.class, (boolean)true);
            if (superCall instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)superCall).getMethodExpression();
                if ("load".equals(methodExpression.getReferenceName())) {
                    PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                    PsiClass psiClass = null;
                    if (qualifierExpression instanceof PsiReferenceExpression) {
                        PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
                        if (resolve2 instanceof PsiClass) {
                            psiClass = (PsiClass)resolve2;
                        }
                    } else if (qualifierExpression != null) {
                        psiClass = PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType());
                    }
                    if (psiClass != null && "javafx.fxml.FXMLLoader".equals(psiClass.getQualifiedName())) {
                        return true;
                    }
                }
            } else if (superCall instanceof PsiNewExpression && (reference = ((PsiNewExpression)superCall).getClassOrAnonymousClassReference()) != null && (resolve = reference.resolve()) instanceof PsiClass && "javafx.fxml.FXMLLoader".equals(((PsiClass)resolve).getQualifiedName())) {
                return true;
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public static PsiExpression getParentElement(PsiLiteralExpression context) {
        PsiMethod psiMethod;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethodCallExpression.class);
        Object value = context.getValue();
        if (value instanceof String && ((String)value).endsWith(".bss")) {
            PsiExpressionList addArgumentsList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiExpressionList.class);
            methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)addArgumentsList, PsiMethodCallExpression.class);
        }
        if (methodCallExpression != null && (psiMethod = methodCallExpression.resolveMethod()) != null) {
            PsiReferenceExpression getStylesheetsMethodExpression;
            PsiExpression qualifierExpression;
            PsiClass containingClass;
            if ("getResource".equals(psiMethod.getName())) {
                PsiExpressionList addArgumentsList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiExpressionList.class);
                PsiMethod psiMethod2 = psiMethod = (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)addArgumentsList, PsiMethodCallExpression.class)) != null ? methodCallExpression.resolveMethod() : null;
                if (psiMethod == null) {
                    return null;
                }
            }
            if ("add".equals(psiMethod.getName()) && (containingClass = psiMethod.getContainingClass()) != null && (qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && "getStylesheets".equals((getStylesheetsMethodExpression = ((PsiMethodCallExpression)qualifierExpression).getMethodExpression()).getReferenceName())) {
                return getStylesheetsMethodExpression.getQualifierExpression();
            }
        }
        return null;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JavaFxReferencesContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(FXML_PATTERN, (PsiReferenceProvider)new JavaFxFileReferenceProvider("fxml"));
        registrar.registerReferenceProvider(STYLESHEET_PATTERN, (PsiReferenceProvider)new JavaFxFileReferenceProvider("css"){

            @Override
            protected String preprocessValue(String value) {
                if (value.endsWith(".bss")) {
                    return StringUtil.trimEnd((String)value, (String)".bss") + ".css";
                }
                return value;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxReferencesContributor", "registerReferenceProviders"));
    }
}

