/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.NestedTableGridPagingModel;
import com.intellij.database.run.actions.ChangePageSizeAction;
import com.intellij.database.run.actions.ChangePageSizeActionGroupKt;
import com.intellij.database.run.actions.ChangePageSizeActionState;
import com.intellij.database.run.actions.ChangePageSizeUtilKt;
import com.intellij.database.run.actions.MyCountRowsAction;
import com.intellij.database.run.actions.SetCustomPageSizeAction;
import com.intellij.database.run.actions.SetDefaultPageSizeAction;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/run/actions/ChangePageSizeActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setActions", "", "sizes", "", "", "isSinglePage", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updatePresentation", "state", "Lcom/intellij/database/run/actions/ChangePageSizeActionState;", "settings", "Lcom/intellij/database/settings/DataGridSettings;", "intellij.grid.impl"})
public final class ChangePageSizeActionGroup
extends DefaultActionGroup
implements CustomComponentAction,
DumbAware {
    public ChangePageSizeActionGroup() {
        this.setPopup(true);
        this.setActions(ChangePageSizeActionGroupKt.access$getDEFAULT_PAGE_SIZES$p(), false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final void setActions(List<Integer> sizes, boolean isSinglePage) {
        this.removeAll();
        if (isSinglePage) {
            this.add((AnAction)new MyCountRowsAction());
        }
        this.addSeparator(DataGridBundle.message((String)"separator.page.size", (Object[])new Object[0]));
        Iterator<Integer> iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int pageSize = ((Number)iterator.next()).intValue();
            this.add((AnAction)new ChangePageSizeAction(pageSize));
        }
        this.add((AnAction)new ChangePageSizeAction(-1));
        this.add((AnAction)new SetCustomPageSizeAction());
        this.add((AnAction)new Separator());
        this.add((AnAction)new SetDefaultPageSizeAction());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null || grid.getDataHookup() instanceof DocumentDataHookUp) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GridPagingModel gridPagingModel = grid.getDataHookup().getPageModel();
        NestedTableGridPagingModel nestedTableGridPagingModel = gridPagingModel instanceof NestedTableGridPagingModel ? (NestedTableGridPagingModel)gridPagingModel : null;
        boolean bl = nestedTableGridPagingModel != null ? nestedTableGridPagingModel.isStatic() : false;
        if (bl) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (FloatingPagingManager.Companion.adjustAction(e) == FloatingPagingManager.AdjustmentResult.HIDDEN) {
            return;
        }
        ChangePageSizeActionState state = ChangePageSizeActionGroupKt.access$getActionState(grid);
        if (GridUtil.hidePageActions(grid, e.getPlace())) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            this.updatePresentation(state, presentation, GridUtil.getSettings(grid));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component component = (Component)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), null, true, null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        JBPopup popup = (JBPopup)listPopup;
        if (component == null) {
            DataGridUIUtil.showPopup(popup, null, e);
            return;
        }
        popup.showUnderneathOf(component);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return ChangePageSizeUtilKt.createCustomComponentForResultViewToolbar((AnAction)this, presentation, place);
    }

    private final void updatePresentation(ChangePageSizeActionState state, Presentation presentation, DataGridSettings settings) {
        ChangePageSizeActionState oldState = ChangePageSizeActionGroupKt.access$getActionState(presentation);
        if (Intrinsics.areEqual((Object)oldState, (Object)state)) {
            return;
        }
        presentation.setText(state.getText());
        presentation.setDescription(state.getDescription());
        presentation.setEnabled(state.getEnabled());
        presentation.putClientProperty(ChangePageSizeActionGroupKt.access$getPAGE_SIZE_KEY$p(), (Object)state.getPageSize());
        presentation.putClientProperty(ChangePageSizeActionGroupKt.access$getSHOW_COUNT_ALL_ACTION_KEY$p(), (Object)state.getShowCountAllAction());
        JComponent component = (JComponent)presentation.getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(state.getTooltip());
            component.repaint();
        }
        List pageSizes = new ArrayList(ChangePageSizeActionGroupKt.access$getDEFAULT_PAGE_SIZES$p());
        pageSizes.add(GridUtilCore.getPageSize((DataGridSettings)settings));
        if (state.getPageSize() > 0) {
            pageSizes.add(state.getPageSize() * 2);
            int halfSize = state.getPageSize() / 2;
            if (halfSize > 0) {
                pageSizes.add(halfSize);
            }
            Object[] objectArray = new Integer[]{state.getPageSize()};
            ContainerUtil.removeAll((Collection)pageSizes, (Object[])objectArray);
        }
        ContainerUtil.removeDuplicates((Collection)pageSizes);
        ContainerUtil.sort((List)pageSizes);
        this.setActions(pageSizes, state.getShowCountAllAction());
    }
}

