/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrVariableStubBase;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrVariableBaseImpl<T extends GrVariableStubBase>
extends GrStubElementBase<T>
implements GrVariable,
StubBasedPsiElement<T> {
    protected static final Logger LOG = Logger.getInstance(GrVariableBaseImpl.class);

    protected GrVariableBaseImpl(ASTNode node) {
        super(node);
    }

    protected GrVariableBaseImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Nullable
    public PsiTypeElement getTypeElement() {
        return PsiImplUtil.getOrCreateTypeElement(this.getTypeElementGroovy());
    }

    @Nullable
    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Nullable
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        PsiElement prev = PsiUtil.getPrevNonSpace(this);
        PsiElement next = PsiUtil.getNextNonSpace(this);
        ASTNode parentNode = parent.getNode();
        assert (parentNode != null);
        if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
            parent.deleteChildRange(prev, this.getPrevSibling());
        } else if (next instanceof LeafPsiElement && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
            parent.deleteChildRange(this.getNextSibling(), next);
        }
        super.delete();
        if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).getVariables().length == 0) {
            parent.delete();
        }
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String property) {
        GrModifierList modifierList;
        if (property == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(0);
        }
        return (modifierList = this.getModifierList()) != null && modifierList.hasModifierProperty(property);
    }

    @NotNull
    public PsiType getType() {
        PsiType type = this.getDeclaredType();
        Object object = type != null ? type : TypesUtil.getJavaLangObject(this);
        if (object == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(1);
        }
        return object;
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        GrVariableStubBase stub = (GrVariableStubBase)this.getStub();
        if (stub != null) {
            return stub.getTypeElement();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration) {
            return ((GrVariableDeclaration)parent).getTypeElementGroovyForVariable(this);
        }
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        GrTypeElement typeElement = this.getTypeElementGroovy();
        PsiType declaredType = null;
        if (typeElement != null && !((declaredType = typeElement.getType()) instanceof PsiClassType)) {
            return declaredType;
        }
        PsiType initializerType = (PsiType)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, this::getInitializerType);
        if (declaredType == null) {
            return initializerType;
        }
        if (initializerType instanceof PsiClassType && TypesUtil.isAssignableWithoutConversions(declaredType, initializerType)) {
            return initializerType;
        }
        return declaredType;
    }

    @Override
    public void setType(@Nullable PsiType type) {
        GrTypeElement newTypeElement;
        GrVariableDeclaration variableDeclaration = this.getDeclaration();
        if (variableDeclaration == null) {
            return;
        }
        GrTypeElement typeElement = variableDeclaration.getTypeElementGroovyForVariable(this);
        if (type == null) {
            if (typeElement != null) {
                if (!variableDeclaration.isTuple() && variableDeclaration.getModifierList().getModifiers().length == 0) {
                    variableDeclaration.getModifierList().setModifierProperty("def", true);
                }
                typeElement.delete();
            }
            return;
        }
        type = TypesUtil.unboxPrimitiveTypeWrapper(type);
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        newTypeElement = typeElement == null ? (GrTypeElement)this.getParent().addBefore((PsiElement)newTypeElement, (PsiElement)this) : (GrTypeElement)typeElement.replace(newTypeElement);
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement ident = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (ident != null) : this.getText();
        PsiElement psiElement = ident;
        if (psiElement == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrExpression getInitializerGroovy() {
        return GroovyPsiElementImpl.findExpressionChild(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(3);
        }
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        return this;
    }

    @NotNull
    public SearchScope getUseScope() {
        GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrVariableDeclarationOwner.class);
        if (owner != null) {
            return new LocalSearchScope((PsiElement)owner);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public String getName() {
        String name;
        GrVariableStubBase stub = (GrVariableStubBase)this.getGreenStub();
        if (stub != null && (name = stub.getName()) != null) {
            String string = name;
            if (string == null) {
                GrVariableBaseImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = PsiImplUtil.getName(this);
        if (string == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = PsiUtil.getJavaNameIdentifier(this);
        if (psiIdentifier == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(7);
        }
        return psiIdentifier;
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        GrVariableDeclaration variableDeclaration = this.getDeclaration();
        if (variableDeclaration != null) {
            return variableDeclaration.getModifierList();
        }
        return null;
    }

    @Nullable
    private GrVariableDeclaration getDeclaration() {
        PsiElement parent = this.getParent();
        if (parent instanceof GrVariableDeclaration) {
            return (GrVariableDeclaration)parent;
        }
        return null;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            GrVariableBaseImpl.$$$reportNull$$$0(8);
        }
        if ((psi = child.getPsi()) == this.getInitializerGroovy()) {
            this.deleteChildInternal(this.findNotNullChildByType(GroovyTokenTypes.mASSIGN).getNode());
        }
        super.deleteChildInternal(child);
    }

    @Override
    public void setInitializerGroovy(GrExpression initializer) {
        if (this.getParent() instanceof GrVariableDeclaration && ((GrVariableDeclaration)this.getParent()).isTuple()) {
            throw new UnsupportedOperationException("don't invoke 'setInitializer()' for tuple declaration");
        }
        GrExpression oldInitializer = this.getInitializerGroovy();
        if (initializer == null) {
            if (oldInitializer != null) {
                oldInitializer.delete();
                PsiElement assign = this.findChildByType(GroovyTokenTypes.mASSIGN);
                if (assign != null) {
                    assign.delete();
                }
            }
            return;
        }
        if (oldInitializer != null) {
            oldInitializer.replaceWithExpression(initializer, true);
        } else {
            this.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", null);
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", null);
            this.addAfter(initializer, this.getLastChild());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableBaseImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifierGroovy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

