/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.api.Error;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class ConstantLookupSite {
    private final RubySymbol name;
    private final String id;
    private ConstantCache cache;

    public ConstantLookupSite(RubySymbol name2) {
        this.name = name2;
        this.id = name2.idString();
    }

    private IRubyObject cacheSearchConst(ThreadContext context, StaticScope staticScope, boolean publicOnly) {
        String id2 = this.id;
        IRubyObject constant = staticScope.getScopedConstant(context, id2);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope.getModule();
            IRubyObject iRubyObject = constant = publicOnly ? module.getConstantFromNoConstMissing(context, id2, false) : module.getConstantNoConstMissing(context, id2);
        }
        if (constant == null) {
            constant = module.callMethod(context, "const_missing", (IRubyObject)this.name);
        } else {
            Invalidator invalidator = context.runtime.getConstantInvalidator(id2);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator);
        }
        return constant;
    }

    public IRubyObject searchConst(ThreadContext context, StaticScope currScope, boolean publicOnly) {
        ConstantCache cache = this.cache;
        if (!ConstantCache.isCached(cache)) {
            return this.cacheSearchConst(context, currScope, publicOnly);
        }
        return cache.value;
    }

    private IRubyObject cacheLexicalSearchConst(ThreadContext context, StaticScope staticScope) {
        IRubyObject constant = staticScope.getConstantDefined(context, this.id);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            Invalidator invalidator = context.runtime.getConstantInvalidator(this.id);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator);
        }
        return constant;
    }

    public IRubyObject lexicalSearchConst(ThreadContext context, StaticScope staticScope) {
        ConstantCache cache = this.cache;
        if (!ConstantCache.isCached(cache)) {
            return this.cacheLexicalSearchConst(context, staticScope);
        }
        return cache.value;
    }

    private IRubyObject cacheInheritanceSearchConst(ThreadContext context, RubyModule module) {
        String id2 = this.id;
        IRubyObject constant = module.getConstantNoConstMissingSkipAutoload(context, id2);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            Invalidator invalidator = context.runtime.getConstantInvalidator(id2);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator, module.id);
        }
        return constant;
    }

    public IRubyObject inheritanceSearchConst(ThreadContext context, IRubyObject cmVal) {
        if (!(cmVal instanceof RubyModule)) {
            throw Error.typeError(context, "", cmVal, " is not a class/module");
        }
        RubyModule module = (RubyModule)cmVal;
        ConstantCache cache = this.cache;
        return !ConstantCache.isCachedFrom(module, cache) ? this.cacheInheritanceSearchConst(context, module) : cache.value;
    }

    private IRubyObject cacheSearchModuleForConst(ThreadContext context, RubyModule module, boolean publicOnly) {
        IRubyObject constant;
        String id2 = this.id;
        IRubyObject iRubyObject = constant = publicOnly ? module.getConstantFromNoConstMissing(context, id2, false) : module.getConstantNoConstMissing(context, id2);
        if (constant != null) {
            Invalidator invalidator = context.runtime.getConstantInvalidator(id2);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator, module.id);
        }
        return constant;
    }

    public IRubyObject searchModuleForConst(ThreadContext context, IRubyObject cmVal, boolean publicOnly, boolean callConstMissing) {
        IRubyObject result2;
        if (!(cmVal instanceof RubyModule)) {
            throw Error.typeError(context, "", cmVal, " is not a class/module");
        }
        RubyModule module = (RubyModule)cmVal;
        ConstantCache cache = this.cache;
        IRubyObject iRubyObject = result2 = !ConstantCache.isCachedFrom(module, cache) ? this.cacheSearchModuleForConst(context, module, publicOnly) : cache.value;
        if (result2 != null) {
            return result2;
        }
        return callConstMissing ? module.callMethod(context, "const_missing", (IRubyObject)this.name) : UndefinedValue.UNDEFINED;
    }
}

