/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParserFactory {
    private static XMLParser parser = null;
    private static String officedtdurl = null;

    private XMLParserFactory() {
    }

    public static synchronized XMLParser getParser() {
        if (parser == null) {
            parser = new DefaultParser();
        }
        return parser;
    }

    public static void setOfficeDTDURL(String string) {
        officedtdurl = string;
    }

    private static class DefaultParser
    implements XMLParser {
        private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        @Override
        public Document parse(InputStream inputStream) throws IOException {
            Document document = null;
            try {
                DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
                InputSource inputSource = new InputSource(inputStream);
                if (officedtdurl != null) {
                    inputSource.setSystemId(officedtdurl);
                }
                document = documentBuilder.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
                IOException iOException = new IOException();
                iOException.initCause(sAXParseException);
                throw iOException;
            }
            catch (SAXException sAXException) {
                IOException iOException = new IOException();
                iOException.initCause(sAXException);
                throw iOException;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                IOException iOException = new IOException();
                iOException.initCause(parserConfigurationException);
                throw iOException;
            }
            return document;
        }

        @Override
        public void write(Document document, OutputStream outputStream) throws IOException {
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(outputStream));
            }
            catch (TransformerException transformerException) {
                IOException iOException = new IOException();
                iOException.initCause(transformerException);
                throw iOException;
            }
        }
    }
}

