/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExample;
import org.openapitools.openapidiff.core.model.ChangedExamples;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;
import org.openapitools.openapidiff.core.model.schema.ChangedEnum;
import org.openapitools.openapidiff.core.model.schema.ChangedMaxItems;
import org.openapitools.openapidiff.core.model.schema.ChangedMaxLength;
import org.openapitools.openapidiff.core.model.schema.ChangedMaxProperties;
import org.openapitools.openapidiff.core.model.schema.ChangedMinItems;
import org.openapitools.openapidiff.core.model.schema.ChangedMinProperties;
import org.openapitools.openapidiff.core.model.schema.ChangedMultipleOf;
import org.openapitools.openapidiff.core.model.schema.ChangedNullable;
import org.openapitools.openapidiff.core.model.schema.ChangedNumericRange;
import org.openapitools.openapidiff.core.model.schema.ChangedOneOfSchema;
import org.openapitools.openapidiff.core.model.schema.ChangedPattern;
import org.openapitools.openapidiff.core.model.schema.ChangedReadOnly;
import org.openapitools.openapidiff.core.model.schema.ChangedRequired;
import org.openapitools.openapidiff.core.model.schema.ChangedUniqueItems;
import org.openapitools.openapidiff.core.model.schema.ChangedWriteOnly;

public class ChangedSchema
implements ComposedChanged {
    protected DiffContext context;
    protected Schema<?> oldSchema;
    protected Schema<?> newSchema;
    protected String type;
    protected Map<String, ChangedSchema> changedProperties;
    protected Map<String, Schema<?>> increasedProperties = new LinkedHashMap();
    protected Map<String, Schema<?>> missingProperties = new LinkedHashMap();
    protected boolean changeDeprecated;
    protected ChangedMetadata description;
    protected ChangedExamples examples;
    protected ChangedExample example;
    protected boolean changeTitle;
    protected ChangedRequired required;
    protected boolean changeDefault;
    protected ChangedEnum<?> enumeration;
    protected boolean changeFormat;
    protected ChangedReadOnly readOnly;
    protected ChangedWriteOnly writeOnly;
    protected boolean changedType;
    protected ChangedMaxLength maxLength;
    protected ChangedNumericRange numericRange;
    protected ChangedMultipleOf multipleOf;
    protected ChangedMaxItems maxItems;
    protected ChangedMinItems minItems;
    protected ChangedMaxProperties maxProperties;
    protected ChangedMinProperties minProperties;
    protected ChangedNullable nullable;
    protected ChangedUniqueItems uniqueItems;
    protected boolean discriminatorPropertyChanged;
    protected ChangedPattern pattern;
    protected ChangedSchema items;
    protected ChangedOneOfSchema oneOfSchema;
    protected ChangedSchema addProp;
    private ChangedExtensions extensions;
    private boolean gettingChangedElements = false;
    private boolean gettingIsChanged = false;
    private DiffResult changed;
    private DiffResult coreChanged;
    private List<Changed> changedElements;

    public ChangedSchema() {
        this.changedProperties = new LinkedHashMap<String, ChangedSchema>();
    }

    private void clearChangedCache() {
        this.changed = null;
        this.coreChanged = null;
        this.changedElements = null;
    }

    @Override
    public DiffResult isChanged() {
        if (this.gettingIsChanged) {
            return DiffResult.NO_CHANGES;
        }
        this.gettingIsChanged = true;
        if (this.changed == null) {
            DiffResult elementsResult = DiffResult.fromWeight(this.getChangedElements().stream().filter(Objects::nonNull).map(Changed::isChanged).mapToInt(DiffResult::getWeight).max().orElse(0));
            DiffResult result = this.isCoreChanged().getWeight() > elementsResult.getWeight() ? this.isCoreChanged() : elementsResult;
            this.changed = result;
        }
        this.gettingIsChanged = false;
        return this.changed;
    }

    @Override
    public List<Changed> getChangedElements() {
        if (this.gettingChangedElements) {
            return Collections.emptyList();
        }
        this.gettingChangedElements = true;
        if (this.changedElements == null) {
            this.changedElements = Stream.concat(this.changedProperties.values().stream(), Stream.of(this.description, this.examples, this.example, this.readOnly, this.writeOnly, this.items, this.oneOfSchema, this.addProp, this.enumeration, this.required, this.maxLength, this.numericRange, this.multipleOf, this.maxItems, this.minItems, this.maxProperties, this.minProperties, this.nullable, this.uniqueItems, this.pattern, this.extensions)).collect(Collectors.toList());
        }
        this.gettingChangedElements = false;
        return this.changedElements;
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.coreChanged == null) {
            this.coreChanged = this.calculateCoreChanged();
        }
        return this.coreChanged;
    }

    private DiffResult calculateCoreChanged() {
        if (!this.changedType && (this.oldSchema == null && this.newSchema == null || this.oldSchema != null && this.newSchema != null) && !this.changeFormat && !this.changeDefault && this.increasedProperties.isEmpty() && this.missingProperties.isEmpty() && this.changedProperties.values().isEmpty() && !this.changeDeprecated && !this.discriminatorPropertyChanged) {
            return DiffResult.NO_CHANGES;
        }
        if (this.changedType && BackwardIncompatibleProp.SCHEMA_TYPE_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.discriminatorPropertyChanged && BackwardIncompatibleProp.SCHEMA_DISCRIMINATOR_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (!this.compatibleForRequest() || !this.compatibleForResponse()) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    private boolean compatibleForRequest() {
        return !this.context.isRequest() || this.oldSchema != null || this.newSchema == null;
    }

    private boolean compatibleForResponse() {
        if (this.context.isResponse() && this.oldSchema != null) {
            if (this.newSchema == null) {
                return false;
            }
            if (this.oldSchema.getRequired() != null && this.missingProperties.keySet().stream().anyMatch(prop -> this.oldSchema.getRequired().contains(prop)) && BackwardIncompatibleProp.RESPONSE_REQUIRED_DECREASED.enabled(this.context, new Object[0])) {
                return false;
            }
        }
        return true;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Schema<?> getOldSchema() {
        return this.oldSchema;
    }

    public Schema<?> getNewSchema() {
        return this.newSchema;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, ChangedSchema> getChangedProperties() {
        return this.changedProperties;
    }

    public Map<String, Schema<?>> getIncreasedProperties() {
        return this.increasedProperties;
    }

    public Map<String, Schema<?>> getMissingProperties() {
        return this.missingProperties;
    }

    public boolean isChangeDeprecated() {
        return this.changeDeprecated;
    }

    public ChangedExamples getExamples() {
        return this.examples;
    }

    public ChangedExample getExample() {
        return this.example;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public boolean isChangeTitle() {
        return this.changeTitle;
    }

    public ChangedRequired getRequired() {
        return this.required;
    }

    public boolean isChangeDefault() {
        return this.changeDefault;
    }

    public ChangedEnum<?> getEnumeration() {
        return this.enumeration;
    }

    public boolean isChangeFormat() {
        return this.changeFormat;
    }

    public ChangedReadOnly getReadOnly() {
        return this.readOnly;
    }

    public ChangedWriteOnly getWriteOnly() {
        return this.writeOnly;
    }

    public boolean isChangedType() {
        return this.changedType;
    }

    public ChangedMaxLength getMaxLength() {
        return this.maxLength;
    }

    public ChangedNumericRange getNumericRange() {
        return this.numericRange;
    }

    public ChangedMultipleOf getMultipleOf() {
        return this.multipleOf;
    }

    public ChangedMaxItems getMaxItems() {
        return this.maxItems;
    }

    public ChangedMinItems getMinItems() {
        return this.minItems;
    }

    public ChangedNullable getNullable() {
        return this.nullable;
    }

    public ChangedUniqueItems getUniqueItems() {
        return this.uniqueItems;
    }

    public ChangedPattern getPattern() {
        return this.pattern;
    }

    public boolean isDiscriminatorPropertyChanged() {
        return this.discriminatorPropertyChanged;
    }

    public ChangedSchema getItems() {
        return this.items;
    }

    public ChangedOneOfSchema getOneOfSchema() {
        return this.oneOfSchema;
    }

    public ChangedSchema getAddProp() {
        return this.addProp;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedMaxProperties getMaxProperties() {
        return this.maxProperties;
    }

    public ChangedMinProperties getMinProperties() {
        return this.minProperties;
    }

    public ChangedSchema setContext(DiffContext context) {
        this.context = context;
        return this;
    }

    public ChangedSchema setOldSchema(Schema<?> oldSchema) {
        this.oldSchema = oldSchema;
        return this;
    }

    public ChangedSchema setNewSchema(Schema<?> newSchema) {
        this.newSchema = newSchema;
        return this;
    }

    public ChangedSchema setType(String type) {
        this.type = type;
        return this;
    }

    public ChangedSchema setChangedProperties(Map<String, ChangedSchema> changedProperties) {
        this.clearChangedCache();
        this.changedProperties = changedProperties;
        return this;
    }

    public ChangedSchema setIncreasedProperties(Map<String, Schema<?>> increasedProperties) {
        this.clearChangedCache();
        this.increasedProperties = increasedProperties;
        return this;
    }

    public ChangedSchema setMissingProperties(Map<String, Schema<?>> missingProperties) {
        this.clearChangedCache();
        this.missingProperties = missingProperties;
        return this;
    }

    public ChangedSchema setChangeDeprecated(boolean changeDeprecated) {
        this.clearChangedCache();
        this.changeDeprecated = changeDeprecated;
        return this;
    }

    public ChangedSchema setDescription(ChangedMetadata description) {
        this.clearChangedCache();
        this.description = description;
        return this;
    }

    public ChangedSchema setExamples(ChangedExamples examples) {
        this.clearChangedCache();
        this.examples = examples;
        return this;
    }

    public ChangedSchema setExample(ChangedExample example) {
        this.clearChangedCache();
        this.example = example;
        return this;
    }

    public ChangedSchema setChangeTitle(boolean changeTitle) {
        this.clearChangedCache();
        this.changeTitle = changeTitle;
        return this;
    }

    public ChangedSchema setRequired(ChangedRequired required) {
        this.clearChangedCache();
        this.required = required;
        return this;
    }

    public ChangedSchema setChangeDefault(boolean changeDefault) {
        this.clearChangedCache();
        this.changeDefault = changeDefault;
        return this;
    }

    public ChangedSchema setEnumeration(ChangedEnum<?> enumeration) {
        this.clearChangedCache();
        this.enumeration = enumeration;
        return this;
    }

    public ChangedSchema setChangeFormat(boolean changeFormat) {
        this.clearChangedCache();
        this.changeFormat = changeFormat;
        return this;
    }

    public ChangedSchema setReadOnly(ChangedReadOnly readOnly) {
        this.clearChangedCache();
        this.readOnly = readOnly;
        return this;
    }

    public ChangedSchema setWriteOnly(ChangedWriteOnly writeOnly) {
        this.clearChangedCache();
        this.writeOnly = writeOnly;
        return this;
    }

    public ChangedSchema setChangedType(boolean changedType) {
        this.clearChangedCache();
        this.changedType = changedType;
        return this;
    }

    public ChangedSchema setMaxLength(ChangedMaxLength maxLength) {
        this.clearChangedCache();
        this.maxLength = maxLength;
        return this;
    }

    public ChangedSchema setNumericRange(ChangedNumericRange numericRange) {
        this.clearChangedCache();
        this.numericRange = numericRange;
        return this;
    }

    public ChangedSchema setMultipleOf(ChangedMultipleOf multipleOf) {
        this.clearChangedCache();
        this.multipleOf = multipleOf;
        return this;
    }

    public ChangedSchema setMaxItems(ChangedMaxItems maxItems) {
        this.clearChangedCache();
        this.maxItems = maxItems;
        return this;
    }

    public ChangedSchema setMinItems(ChangedMinItems minItems) {
        this.clearChangedCache();
        this.minItems = minItems;
        return this;
    }

    public ChangedSchema setNullable(ChangedNullable nullable) {
        this.clearChangedCache();
        this.nullable = nullable;
        return this;
    }

    public ChangedSchema setUniqueItems(ChangedUniqueItems uniqueItems) {
        this.clearChangedCache();
        this.uniqueItems = uniqueItems;
        return this;
    }

    public ChangedSchema setPattern(ChangedPattern pattern) {
        this.clearChangedCache();
        this.pattern = pattern;
        return this;
    }

    public ChangedSchema setDiscriminatorPropertyChanged(boolean discriminatorPropertyChanged) {
        this.clearChangedCache();
        this.discriminatorPropertyChanged = discriminatorPropertyChanged;
        return this;
    }

    public ChangedSchema setItems(ChangedSchema items) {
        this.clearChangedCache();
        this.items = items;
        return this;
    }

    public ChangedSchema setOneOfSchema(ChangedOneOfSchema oneOfSchema) {
        this.clearChangedCache();
        this.oneOfSchema = oneOfSchema;
        return this;
    }

    public ChangedSchema setAddProp(ChangedSchema addProp) {
        this.clearChangedCache();
        this.addProp = addProp;
        return this;
    }

    public ChangedSchema setExtensions(ChangedExtensions extensions) {
        this.clearChangedCache();
        this.extensions = extensions;
        return this;
    }

    public ChangedSchema setMaxProperties(ChangedMaxProperties maxProperties) {
        this.clearChangedCache();
        this.maxProperties = maxProperties;
        return this;
    }

    public ChangedSchema setMinProperties(ChangedMinProperties minProperties) {
        this.clearChangedCache();
        this.minProperties = minProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedSchema that = (ChangedSchema)o;
        return this.changeDeprecated == that.changeDeprecated && this.changeTitle == that.changeTitle && this.changeDefault == that.changeDefault && this.changeFormat == that.changeFormat && this.changedType == that.changedType && this.discriminatorPropertyChanged == that.discriminatorPropertyChanged && Objects.equals(this.context, that.context) && Objects.equals(this.oldSchema, that.oldSchema) && Objects.equals(this.newSchema, that.newSchema) && Objects.equals(this.type, that.type) && Objects.equals(this.changedProperties, that.changedProperties) && Objects.equals(this.increasedProperties, that.increasedProperties) && Objects.equals(this.missingProperties, that.missingProperties) && Objects.equals(this.description, that.description) && Objects.equals(this.examples, that.examples) && Objects.equals(this.example, that.example) && Objects.equals(this.required, that.required) && Objects.equals(this.enumeration, that.enumeration) && Objects.equals(this.readOnly, that.readOnly) && Objects.equals(this.writeOnly, that.writeOnly) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.numericRange, that.numericRange) && Objects.equals(this.multipleOf, that.multipleOf) && Objects.equals(this.maxItems, that.maxItems) && Objects.equals(this.minItems, that.minItems) && Objects.equals(this.nullable, that.nullable) && Objects.equals(this.uniqueItems, that.uniqueItems) && Objects.equals(this.items, that.items) && Objects.equals(this.oneOfSchema, that.oneOfSchema) && Objects.equals(this.addProp, that.addProp) && Objects.equals(this.extensions, that.extensions) && Objects.equals(this.maxProperties, that.maxProperties) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.minProperties, that.minProperties);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.oldSchema, this.newSchema, this.type, this.changedProperties, this.increasedProperties, this.missingProperties, this.changeDeprecated, this.description, this.examples, this.example, this.changeTitle, this.required, this.changeDefault, this.enumeration, this.changeFormat, this.readOnly, this.writeOnly, this.changedType, this.maxLength, this.numericRange, this.multipleOf, this.maxItems, this.minItems, this.nullable, this.uniqueItems, this.discriminatorPropertyChanged, this.items, this.oneOfSchema, this.addProp, this.extensions, this.maxProperties, this.pattern, this.minProperties);
    }

    public String toString() {
        return "ChangedSchema(context=" + this.getContext() + ", oldSchema=" + this.getOldSchema() + ", newSchema=" + this.getNewSchema() + ", type=" + this.getType() + ", changedProperties=" + this.getChangedProperties() + ", increasedProperties=" + this.getIncreasedProperties() + ", missingProperties=" + this.getMissingProperties() + ", changeDeprecated=" + this.isChangeDeprecated() + ", description=" + this.getDescription() + ", examples=" + this.getExamples() + ", example=" + this.getExample() + ", changeTitle=" + this.isChangeTitle() + ", required=" + this.getRequired() + ", changeDefault=" + this.isChangeDefault() + ", enumeration=" + this.getEnumeration() + ", changeFormat=" + this.isChangeFormat() + ", readOnly=" + this.getReadOnly() + ", writeOnly=" + this.getWriteOnly() + ", changedType=" + this.isChangedType() + ", maxLength=" + this.getMaxLength() + ", numericRange=" + this.getNumericRange() + ", multipleOf=" + this.getMultipleOf() + ", maxItems=" + this.getMaxItems() + ", minItems=" + this.getMinItems() + ", nullable=" + this.getNullable() + ", uniqueItems=" + this.getUniqueItems() + ", discriminatorPropertyChanged=" + this.isDiscriminatorPropertyChanged() + ", items=" + this.getItems() + ", oneOfSchema=" + this.getOneOfSchema() + ", addProp=" + this.getAddProp() + ", extensions=" + this.getExtensions() + ", maxProperties=" + this.getMaxProperties() + ", minProperties=" + this.getMinProperties() + ", pattern=" + this.getPattern() + ")";
    }
}

