/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRunnable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.InputStreamWithMetadata;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.blobstore.transfer.RemoteTransferContainer;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeFileInputStream;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.store.exception.ChecksumCombinationException;
import org.opensearch.index.translog.ChannelFactory;
import org.opensearch.index.translog.transfer.FileSnapshot;
import org.opensearch.index.translog.transfer.FileTransferException;
import org.opensearch.index.translog.transfer.TransferService;
import org.opensearch.threadpool.ThreadPool;

public class BlobStoreTransferService
implements TransferService {
    private final BlobStore blobStore;
    private final ThreadPool threadPool;
    private static final int CHECKSUM_BYTES_LENGTH = 8;
    private static final Logger logger = LogManager.getLogger(BlobStoreTransferService.class);

    public BlobStoreTransferService(BlobStore blobStore, ThreadPool threadPool) {
        this.blobStore = blobStore;
        this.threadPool = threadPool;
    }

    @Override
    public void uploadBlob(String threadPoolName, FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath, ActionListener<FileSnapshot.TransferFileSnapshot> listener, WritePriority writePriority) {
        assert (remoteTransferPath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        this.threadPool.executor(threadPoolName).execute(ActionRunnable.wrap(listener, l -> {
            try {
                this.uploadBlob(fileSnapshot, blobPath, writePriority);
                l.onResponse((Object)fileSnapshot);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)e);
                l.onFailure((Exception)new FileTransferException(fileSnapshot, (Throwable)e));
            }
        }));
    }

    @Override
    public void uploadBlob(FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath, WritePriority writePriority) throws IOException {
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        try (InputStream inputStream = fileSnapshot.inputStream();){
            this.blobStore.blobContainer(blobPath).writeBlobAtomic(fileSnapshot.getName(), inputStream, fileSnapshot.getContentLength(), true);
        }
    }

    @Override
    public void uploadBlobs(Set<FileSnapshot.TransferFileSnapshot> fileSnapshots, Map<Long, BlobPath> blobPaths, ActionListener<FileSnapshot.TransferFileSnapshot> listener, WritePriority writePriority) {
        fileSnapshots.forEach(fileSnapshot -> {
            BlobPath blobPath = (BlobPath)blobPaths.get(fileSnapshot.getPrimaryTerm());
            if (!(this.blobStore.blobContainer(blobPath) instanceof AsyncMultiStreamBlobContainer)) {
                this.uploadBlob("translog_transfer", (FileSnapshot.TransferFileSnapshot)fileSnapshot, blobPath, listener, writePriority);
            } else {
                this.uploadBlob((FileSnapshot.TransferFileSnapshot)fileSnapshot, listener, blobPath, writePriority);
            }
        });
    }

    @Override
    public void uploadBlob(InputStream inputStream, Iterable<String> remotePath, String fileName, WritePriority writePriority, ActionListener<Void> listener) throws IOException {
        assert (remotePath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remotePath;
        BlobContainer blobContainer = this.blobStore.blobContainer(blobPath);
        if (!(blobContainer instanceof AsyncMultiStreamBlobContainer)) {
            blobContainer.writeBlob(fileName, inputStream, inputStream.available(), false);
            listener.onResponse(null);
            return;
        }
        String resourceDescription = "BlobStoreTransferService.uploadBlob(blob=\"" + fileName + "\")";
        byte[] bytes = inputStream.readAllBytes();
        long expectedChecksum = BlobStoreTransferService.computeChecksum(bytes, resourceDescription);
        this.uploadBlobAsyncInternal(fileName, fileName, bytes.length, blobPath, writePriority, (size, position) -> new OffsetRangeIndexInputStream(new ByteArrayIndexInput(resourceDescription, bytes), size, position), expectedChecksum, listener, null);
    }

    static Map<String, String> buildTransferFileMetadata(InputStream metadataInputStream) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[128];
            int totalBytesRead = 0;
            while ((bytesRead = metadataInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
                if ((totalBytesRead += bytesRead) <= 1024) continue;
                throw new IOException("Input stream exceeds 1KB limit");
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String metadataString = Base64.getEncoder().encodeToString(bytes);
            metadata.put("ckp-data", metadataString);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadBlob(FileSnapshot.TransferFileSnapshot fileSnapshot, ActionListener<FileSnapshot.TransferFileSnapshot> listener, BlobPath blobPath, WritePriority writePriority) {
        try {
            long contentLength;
            ChannelFactory channelFactory = FileChannel::open;
            Map<String, String> metadata = null;
            if (fileSnapshot.getMetadataFileInputStream() != null) {
                metadata = BlobStoreTransferService.buildTransferFileMetadata(fileSnapshot.getMetadataFileInputStream());
            }
            try (FileChannel channel = channelFactory.open(fileSnapshot.getPath(), StandardOpenOption.READ);){
                contentLength = channel.size();
            }
            ActionListener completionListener = ActionListener.wrap(resp -> listener.onResponse((Object)fileSnapshot), ex -> {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)ex);
                listener.onFailure((Exception)new FileTransferException(fileSnapshot, (Throwable)ex));
            });
            Objects.requireNonNull(fileSnapshot.getChecksum());
            this.uploadBlobAsyncInternal(fileSnapshot.getName(), fileSnapshot.getName(), contentLength, blobPath, writePriority, (size, position) -> new OffsetRangeFileInputStream(fileSnapshot.getPath(), size, position), fileSnapshot.getChecksum(), (ActionListener<Void>)completionListener, metadata);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)e);
            listener.onFailure((Exception)new FileTransferException(fileSnapshot, (Throwable)e));
        }
        finally {
            try {
                fileSnapshot.close();
            }
            catch (IOException e) {
                logger.warn("Error while closing TransferFileSnapshot", (Throwable)e);
            }
        }
    }

    void uploadBlobAsyncInternal(String fileName, String remoteFileName, long contentLength, BlobPath blobPath, WritePriority writePriority, RemoteTransferContainer.OffsetRangeInputStreamSupplier inputStreamSupplier, long expectedChecksum, ActionListener<Void> completionListener, Map<String, String> metadata) throws IOException {
        BlobContainer blobContainer = this.blobStore.blobContainer(blobPath);
        assert (blobContainer instanceof AsyncMultiStreamBlobContainer);
        boolean remoteIntegrityEnabled = ((AsyncMultiStreamBlobContainer)blobContainer).remoteIntegrityCheckSupported();
        try (RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(fileName, remoteFileName, contentLength, true, writePriority, inputStreamSupplier, expectedChecksum, remoteIntegrityEnabled, metadata);){
            ((AsyncMultiStreamBlobContainer)blobContainer).asyncBlobUpload(remoteTransferContainer.createWriteContext(), completionListener);
        }
    }

    @Override
    public InputStream downloadBlob(Iterable<String> path, String fileName) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).readBlob(fileName);
    }

    @Override
    @ExperimentalApi
    public InputStreamWithMetadata downloadBlobWithMetadata(Iterable<String> path, String fileName) throws IOException {
        assert (this.blobStore.isBlobMetadataEnabled());
        return this.blobStore.blobContainer((BlobPath)path).readBlobWithMetadata(fileName);
    }

    @Override
    public void deleteBlobs(Iterable<String> path, List<String> fileNames) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).deleteBlobsIgnoringIfNotExists(fileNames);
    }

    @Override
    public void deleteBlobsAsync(String threadpoolName, Iterable<String> path, List<String> fileNames, ActionListener<Void> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                this.deleteBlobs(path, fileNames);
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    @Override
    public void delete(Iterable<String> path) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).delete();
    }

    @Override
    public void deleteAsync(String threadpoolName, Iterable<String> path, ActionListener<Void> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                this.delete(path);
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    @Override
    public Set<String> listAll(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).listBlobs().keySet();
    }

    @Override
    public Set<String> listFolders(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).children().keySet();
    }

    @Override
    public void listFoldersAsync(String threadpoolName, Iterable<String> path, ActionListener<Set<String>> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                listener.onResponse(this.listFolders(path));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    @Override
    public void listAllInSortedOrder(Iterable<String> path, String filenamePrefix, int limit, ActionListener<List<BlobMetadata>> listener) {
        this.blobStore.blobContainer((BlobPath)path).listBlobsByPrefixInSortedOrder(filenamePrefix, limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC, listener);
    }

    @Override
    public void listAllInSortedOrderAsync(String threadpoolName, Iterable<String> path, String filenamePrefix, int limit, ActionListener<List<BlobMetadata>> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> this.listAllInSortedOrder(path, filenamePrefix, limit, listener));
    }

    private static long computeChecksum(byte[] bytes, String resourceDescription) throws ChecksumCombinationException {
        long expectedChecksum;
        try (ByteArrayIndexInput indexInput = new ByteArrayIndexInput(resourceDescription, bytes);){
            expectedChecksum = RemoteTransferContainer.checksumOfChecksum(indexInput, 8);
        }
        catch (Exception e) {
            throw new ChecksumCombinationException("Potentially corrupted file: Checksum combination failed while combining stored checksum and calculated checksum of stored checksum", resourceDescription, e);
        }
        return expectedChecksum;
    }
}

