/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.collapse;

import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.query.InnerHitBuilder;

@PublicApi(since="1.0.0")
public class CollapseContext {
    private final String fieldName;
    private final MappedFieldType fieldType;
    private final List<InnerHitBuilder> innerHits;

    public CollapseContext(String fieldName, MappedFieldType fieldType, List<InnerHitBuilder> innerHits) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.innerHits = innerHits;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MappedFieldType getFieldType() {
        return this.fieldType;
    }

    public List<InnerHitBuilder> getInnerHit() {
        return this.innerHits;
    }

    public CollapsingTopDocsCollector<?> createTopDocs(Sort sort, int topN) {
        if (this.fieldType != null && this.fieldType.unwrap() instanceof KeywordFieldMapper.KeywordFieldType) {
            return CollapsingTopDocsCollector.createKeyword(this.fieldName, this.fieldType, sort, topN);
        }
        if (this.fieldType != null && this.fieldType.unwrap() instanceof NumberFieldMapper.NumberFieldType) {
            return CollapsingTopDocsCollector.createNumeric(this.fieldName, this.fieldType, sort, topN);
        }
        throw new IllegalStateException("unknown type for collapse field " + this.fieldName + ", only keywords and numbers are accepted");
    }
}

