/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.validation;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.indexstatemanagement.validation.ValidateSnapshot;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Validate;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.monitor.jvm.JvmService;

@OpenForTesting
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0012J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0012R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateSnapshot;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Validate;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "jvmService", "Lorg/opensearch/monitor/jvm/JvmService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/monitor/jvm/JvmService;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "execute", "indexName", "", "indexExists", "", "validIndex", "Companion", "opensearch-index-management"})
public class ValidateSnapshot
extends Validate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    public static final String name = "validate_snapshot";

    public ValidateSnapshot(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull JvmService jvmService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)jvmService, (String)"jvmService");
        super(settings, clusterService, jvmService);
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public Validate execute(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        if (!this.indexExists(indexName) || !this.validIndex(indexName)) {
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            return this;
        }
        this.setValidationMessage(Companion.getValidationPassedMessage(indexName));
        return this;
    }

    private boolean indexExists(String indexName) {
        boolean indexExists = this.getClusterService().state().getMetadata().getIndices().containsKey(indexName);
        if (!indexExists) {
            String message = Companion.getNoIndexMessage(indexName);
            this.logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private boolean validIndex(String indexName) {
        Function2 exceptionGenerator2 = validIndex.exceptionGenerator.1.INSTANCE;
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, (arg_0, arg_1) -> ValidateSnapshot.validIndex$lambda$0(exceptionGenerator2, arg_0, arg_1));
        }
        catch (Exception e) {
            String message = Companion.getIndexNotValidMessage(indexName);
            this.logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private static final RuntimeException validIndex$lambda$0(Function2 $tmp0, String p0, String p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RuntimeException)$tmp0.invoke((Object)p0, (Object)p1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/validation/ValidateSnapshot$Companion;", "", "()V", "name", "", "getIndexNotValidMessage", "index", "getNoIndexMessage", "getValidationPassedMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNoIndexMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Index [index=" + index2 + "] does not exist for snapshot action.";
        }

        @NotNull
        public final String getIndexNotValidMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Index [index=" + index2 + "] is not valid for snapshot action.";
        }

        @NotNull
        public final String getValidationPassedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Snapshot action validation passed for [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

