/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.refreshanalyzer;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerRequest;
import org.opensearch.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerResponse;
import org.opensearch.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerShardResponse;
import org.opensearch.indices.IndicesService;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B9\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0014J3\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001cH\u0014\u00a2\u0006\u0002\u0010\u001eJL\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0%2\u0006\u0010(\u001a\u00020\u0018H\u0014J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0014J\u0012\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020+H\u0014J\u0018\u0010-\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0014J3\u00100\u001a\u0004\u0018\u0001012\u0006\u0010(\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001cH\u0014\u00a2\u0006\u0002\u00102R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/opensearch/indexmanagement/refreshanalyzer/TransportRefreshSearchAnalyzerAction;", "Lorg/opensearch/action/support/broadcast/node/TransportBroadcastByNodeAction;", "Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerRequest;", "Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerResponse;", "Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerShardResponse;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "transportService", "Lorg/opensearch/transport/TransportService;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "analysisRegistry", "Lorg/opensearch/index/analysis/AnalysisRegistry;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/TransportService;Lorg/opensearch/indices/IndicesService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/index/analysis/AnalysisRegistry;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "checkGlobalBlock", "Lorg/opensearch/cluster/block/ClusterBlockException;", "state", "Lorg/opensearch/cluster/ClusterState;", "request", "checkRequestBlock", "concreteIndices", "", "", "(Lorg/opensearch/cluster/ClusterState;Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerRequest;[Ljava/lang/String;)Lorg/opensearch/cluster/block/ClusterBlockException;", "newResponse", "totalShards", "", "successfulShards", "failedShards", "shardResponses", "", "shardFailures", "Lorg/opensearch/core/action/support/DefaultShardOperationFailedException;", "clusterState", "readRequestFrom", "si", "Lorg/opensearch/core/common/io/stream/StreamInput;", "readShardResult", "shardOperation", "shardRouting", "Lorg/opensearch/cluster/routing/ShardRouting;", "shards", "Lorg/opensearch/cluster/routing/ShardsIterator;", "(Lorg/opensearch/cluster/ClusterState;Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerRequest;[Ljava/lang/String;)Lorg/opensearch/cluster/routing/ShardsIterator;", "opensearch-index-management"})
public final class TransportRefreshSearchAnalyzerAction
extends TransportBroadcastByNodeAction<RefreshSearchAnalyzerRequest, RefreshSearchAnalyzerResponse, RefreshSearchAnalyzerShardResponse> {
    private final Logger log;
    @NotNull
    private final IndicesService indicesService;
    @NotNull
    private final AnalysisRegistry analysisRegistry;

    @Inject
    public TransportRefreshSearchAnalyzerAction(@NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull IndicesService indicesService, @NotNull ActionFilters actionFilters, @NotNull AnalysisRegistry analysisRegistry, @Nullable IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)analysisRegistry, (String)"analysisRegistry");
        super("indices:admin/refresh_search_analyzers", clusterService, transportService, actionFilters, indexNameExpressionResolver, TransportRefreshSearchAnalyzerAction::_init_$lambda$0, "management");
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.analysisRegistry = analysisRegistry;
        this.indicesService = indicesService;
    }

    @Nullable
    protected RefreshSearchAnalyzerShardResponse readShardResult(@NotNull StreamInput si) throws IOException {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return new RefreshSearchAnalyzerShardResponse(si);
    }

    @NotNull
    protected RefreshSearchAnalyzerResponse newResponse(@NotNull RefreshSearchAnalyzerRequest request, int totalShards, int successfulShards, int failedShards, @NotNull List<RefreshSearchAnalyzerShardResponse> shardResponses, @NotNull List<? extends DefaultShardOperationFailedException> shardFailures, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(shardResponses, (String)"shardResponses");
        Intrinsics.checkNotNullParameter(shardFailures, (String)"shardFailures");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        return new RefreshSearchAnalyzerResponse(totalShards, successfulShards, failedShards, shardFailures, shardResponses);
    }

    @NotNull
    protected RefreshSearchAnalyzerRequest readRequestFrom(@NotNull StreamInput si) throws IOException {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return new RefreshSearchAnalyzerRequest(si);
    }

    @NotNull
    protected RefreshSearchAnalyzerShardResponse shardOperation(@NotNull RefreshSearchAnalyzerRequest request, @NotNull ShardRouting shardRouting) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)shardRouting, (String)"shardRouting");
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        Intrinsics.checkNotNullExpressionValue((Object)indexShard, (String)"indicesService.indexServ\u2026rdRouting.shardId().id())");
        IndexShard indexShard2 = indexShard;
        List list = indexShard2.mapperService().reloadSearchAnalyzers(this.analysisRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"indexShard.mapperService\u2026alyzers(analysisRegistry)");
        List reloadedAnalyzers = list;
        this.log.info("Reload successful, index: " + shardRouting.shardId().getIndex().getName() + ", shard: " + shardRouting.shardId().getId() + ", is_primary: " + shardRouting.primary());
        ShardId shardId = shardRouting.shardId();
        Intrinsics.checkNotNullExpressionValue((Object)shardId, (String)"shardRouting.shardId()");
        return new RefreshSearchAnalyzerShardResponse(shardId, reloadedAnalyzers);
    }

    @Nullable
    protected ShardsIterator shards(@NotNull ClusterState clusterState, @Nullable RefreshSearchAnalyzerRequest request, @Nullable String[] concreteIndices) {
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        return clusterState.routingTable().allShards(concreteIndices);
    }

    @Nullable
    protected ClusterBlockException checkGlobalBlock(@NotNull ClusterState state, @Nullable RefreshSearchAnalyzerRequest request) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Nullable
    protected ClusterBlockException checkRequestBlock(@NotNull ClusterState state, @Nullable RefreshSearchAnalyzerRequest request, @Nullable String[] concreteIndices) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    private static final RefreshSearchAnalyzerRequest _init_$lambda$0(StreamInput it) {
        return new RefreshSearchAnalyzerRequest(new String[0]);
    }
}

