/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.RollupSearchResult;
import org.opensearch.indexmanagement.rollup.RollupSearchService;
import org.opensearch.indexmanagement.rollup.model.ContinuousMetadata;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupSearchService;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/client/Client;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/client/Client;)V", "cancelAfterTimeInterval", "Lorg/opensearch/common/unit/TimeValue;", "kotlin.jvm.PlatformType", "getClient", "()Lorg/opensearch/client/Client;", "logger", "Lorg/apache/logging/log4j/Logger;", "retrySearchPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "executeCompositeSearch", "Lorg/opensearch/indexmanagement/rollup/RollupSearchResult;", "job", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCancelAfterTimeInterval", "", "givenInterval", "hasNextFullWindow", "", "rollup", "shouldProcessRollup", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupSearchService.kt\norg/opensearch/indexmanagement/rollup/RollupSearchService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,165:1\n19273#2,7:166\n*S KotlinDebug\n*F\n+ 1 RollupSearchService.kt\norg/opensearch/indexmanagement/rollup/RollupSearchService\n*L\n130#1:166,7\n*E\n"})
public final class RollupSearchService {
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy retrySearchPolicy;
    private volatile TimeValue cancelAfterTimeInterval;

    public RollupSearchService(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_MILLIS().get(settings);
        Object object = RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROLLUP_SEARCH_BACKOFF_COUNT.get(settings)");
        this.retrySearchPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        this.cancelAfterTimeInterval = (TimeValue)TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_MILLIS(), RollupSettings.Companion.getROLLUP_SEARCH_BACKOFF_COUNT(), (arg_0, arg_1) -> RollupSearchService._init_$lambda$0(this, arg_0, arg_1));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING, arg_0 -> RollupSearchService._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public final boolean shouldProcessRollup(@NotNull Rollup rollup2, @Nullable RollupMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        if (!rollup2.getEnabled()) {
            return false;
        }
        if (metadata2 == null) {
            return true;
        }
        if (metadata2.getStatus() == RollupMetadata.Status.RETRY) {
            return true;
        }
        RollupMetadata.Status[] statusArray = new RollupMetadata.Status[]{RollupMetadata.Status.STOPPED, RollupMetadata.Status.FAILED};
        if (CollectionsKt.listOf((Object[])statusArray).contains((Object)metadata2.getStatus())) {
            return false;
        }
        if (metadata2.getAfterKey() != null) {
            return true;
        }
        if (!rollup2.getContinuous()) {
            statusArray = new RollupMetadata.Status[]{RollupMetadata.Status.INIT, RollupMetadata.Status.STARTED};
            if (CollectionsKt.listOf((Object[])statusArray).contains((Object)metadata2.getStatus())) {
                return true;
            }
            this.logger.debug("Non-continuous job [" + rollup2.getId() + "] is not processing next window [" + metadata2 + "]");
            return false;
        }
        return this.hasNextFullWindow(rollup2, metadata2);
    }

    private final boolean hasNextFullWindow(Rollup rollup2, RollupMetadata metadata2) {
        Instant instant = Instant.now();
        ContinuousMetadata continuousMetadata = metadata2.getContinuous();
        Intrinsics.checkNotNull((Object)continuousMetadata);
        Long l = rollup2.getDelay();
        return instant.isAfter(continuousMetadata.getNextWindowEndTime().plusMillis(l != null ? l : 0L));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeCompositeSearch(@NotNull Rollup var1_1, @NotNull RollupMetadata var2_2, @NotNull Continuation<? super RollupSearchResult> var3_3) {
        if (!(var3_3 instanceof executeCompositeSearch.1)) ** GOTO lbl-1000
        var16_4 = var3_3;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeCompositeSearch(null, null, (Continuation<? super RollupSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryCount = new Ref.IntRef();
                v0 = this.retrySearchPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"retrySearchPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.retry$default(v0, v1, null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(retryCount, this, (Rollup)job, (RollupMetadata)metadata, null){
                    int label;
                    final /* synthetic */ Ref.IntRef $retryCount;
                    final /* synthetic */ RollupSearchService this$0;
                    final /* synthetic */ Rollup $job;
                    final /* synthetic */ RollupMetadata $metadata;
                    {
                        this.$retryCount = $retryCount;
                        this.this$0 = $receiver;
                        this.$job = $job;
                        this.$metadata = $metadata;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                float f = 2.0f;
                                int n = this.$retryCount.element;
                                this.$retryCount.element = n + 1;
                                float decay = (float)Math.pow(f, n);
                                this.label = 1;
                                Object object3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.this$0.getClient(), (Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(this.$job, decay, this.this$0, this.$retryCount, this.$metadata){
                                    final /* synthetic */ Rollup $job;
                                    final /* synthetic */ float $decay;
                                    final /* synthetic */ RollupSearchService this$0;
                                    final /* synthetic */ Ref.IntRef $retryCount;
                                    final /* synthetic */ RollupMetadata $metadata;
                                    {
                                        this.$job = $job;
                                        this.$decay = $decay;
                                        this.this$0 = $receiver;
                                        this.$retryCount = $retryCount;
                                        this.$metadata = $metadata;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> listener) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(listener, (String)"listener");
                                        int pageSize = Math.max(1, this.$job.getPageSize() / (int)this.$decay);
                                        if (this.$decay > 1.0f) {
                                            RollupSearchService.access$getLogger$p(this.this$0).warn("Composite search failed for rollup, retrying [#" + (this.$retryCount.element - 1) + "] - reducing page size of composite aggregation from " + this.$job.getPageSize() + " to " + pageSize);
                                        }
                                        SearchRequest searchRequest = RollupUtilsKt.getRollupSearchRequest(Rollup.copy$default(this.$job, null, 0L, 0L, false, 0L, null, null, null, null, null, null, null, null, pageSize, null, false, null, null, null, 516095, null), this.$metadata);
                                        TimeValue cancelTimeoutTimeValue = TimeValue.timeValueMinutes((long)RollupSearchService.access$getCancelAfterTimeInterval(this.this$0, RollupSearchService.access$getCancelAfterTimeInterval$p(this.this$0).getMinutes()));
                                        searchRequest.setCancelAfterTimeInterval(cancelTimeoutTimeValue);
                                        $this$suspendUntil.search(searchRequest, listener);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super SearchResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v2 != var18_6) goto lbl24
lbl23:
                // 1 sources

                return var18_6;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                this = (RollupSearchService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl31:
                    // 2 sources

                    var17_8 = (SearchResponse)v2;
                    var4_7 = new RollupSearchResult.Success(var17_8);
                }
                catch (SearchPhaseExecutionException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v3 = e.shardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"e.shardFailures()");
                    if (((Object[])v3).length == 0) {
                        var6_15 = ExceptionsHelper.unwrapCause((Throwable)e);
                        Intrinsics.checkNotNull((Object)var6_15, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        v4 = new RollupSearchResult.Failure(null, (Exception)var6_15, 1, null);
                        v5 = v4;
                    } else {
                        var7_17 = e.shardFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)var7_17, (String)"e.shardFailures()");
                        $this$reduce$iv = var7_17;
                        $i$f$reduce = false;
                        if ($this$reduce$iv.length == 0) {
                            throw new UnsupportedOperationException("Empty array can't be reduced.");
                        }
                        accumulator$iv = $this$reduce$iv[0];
                        var10_20 = new IntRange(1, ArraysKt.getLastIndex((Object[])$this$reduce$iv)).iterator();
                        while (var10_20.hasNext()) {
                            index$iv = var10_20.nextInt();
                            var12_22 = (ShardSearchFailure)$this$reduce$iv[index$iv];
                            s1 = (ShardSearchFailure)accumulator$iv;
                            $i$a$-reduce-RollupSearchService$executeCompositeSearch$shardFailure$1 = false;
                            accumulator$iv = s1.status().getStatus() > s2.status().getStatus() ? s1 : s2;
                        }
                        shardFailure = (ShardSearchFailure)accumulator$iv;
                        v6 = ExceptionsHelper.unwrapCause((Throwable)shardFailure.getCause());
                        Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        v5 = new RollupSearchResult.Failure(null, (Exception)v6, 1, null);
                    }
                    var4_7 = v5;
                }
                catch (RemoteTransportException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v7 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    var4_7 = new RollupSearchResult.Failure(null, (Exception)v7, 1, null);
                }
                catch (CircuitBreakingException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure(null, (Exception)e, 1, null);
                }
                catch (MultiBucketConsumerService.TooManyBucketsException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure(null, (Exception)e, 1, null);
                }
                catch (OpenSearchSecurityException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure("Cannot search data in source index/s - missing required index permissions: " + e.getLocalizedMessage(), (Exception)e);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    var4_7 = new RollupSearchResult.Failure(null, e, 1, null);
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final long getCancelAfterTimeInterval(long givenInterval) {
        if (givenInterval == -1L) {
            return givenInterval;
        }
        return Math.max(this.cancelAfterTimeInterval.minutes(), 10L);
    }

    private static final void _init_$lambda$0(RollupSearchService this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        this$0.retrySearchPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    private static final void _init_$lambda$1(RollupSearchService this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cancelAfterTimeInterval = it;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RollupSearchService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ long access$getCancelAfterTimeInterval(RollupSearchService $this, long givenInterval) {
        return $this.getCancelAfterTimeInterval(givenInterval);
    }

    public static final /* synthetic */ TimeValue access$getCancelAfterTimeInterval$p(RollupSearchService $this) {
        return $this.cancelAfterTimeInterval;
    }
}

