/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.action.stop;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.transform.action.stop.StopTransformRequest;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.model.TransformMetadata;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014J&\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002J&\u0010)\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002J.\u0010*\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/transform/action/stop/TransportStopTransformAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/transform/action/stop/StopTransformRequest;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "retrieveAndUpdateTransformMetadata", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "updateTransformJob", "updateTransformMetadata", "metadata", "Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;", "opensearch-index-management"})
public final class TransportStopTransformAction
extends HandledTransportAction<StopTransformRequest, AcknowledgedResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportStopTransformAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/transform/stop", transportService, actionFilters, StopTransformRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportStopTransformAction._init_$lambda$0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull StopTransformRequest request, @NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        this.log.debug("Executing StopTransformAction on " + request.id());
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.id());
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, user, request){
                final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
                final /* synthetic */ TransportStopTransformAction this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ StopTransformRequest $request;
                {
                    this.$actionListener = $actionListener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$request = $request;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Transform transform2 = null;
                    try {
                        transform2 = (Transform)OpenSearchExtensionsKt.parseFromGetResponse(response2, this.this$0.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Transform>((Object)Transform.Companion){

                            @NotNull
                            public final Transform invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return ((Transform.Companion)this.receiver).parse(p0, p1, p2, p3);
                            }
                        });
                    }
                    catch (IllegalArgumentException e) {
                        this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    User user = transform2.getUser();
                    Boolean bl = TransportStopTransformAction.access$getFilterByEnabled$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
                    if (!SecurityUtils.Companion.userHasPermissionForResource(this.$user, user, bl, "transform", transform2.getId(), this.$actionListener)) {
                        return;
                    }
                    if (transform2.getMetadataId() != null) {
                        TransportStopTransformAction.access$retrieveAndUpdateTransformMetadata(this.this$0, transform2, this.$request, this.$actionListener);
                    } else {
                        TransportStopTransformAction.access$updateTransformJob(this.this$0, transform2, this.$request, this.$actionListener);
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    this.$actionListener.onFailure((Exception)throwable);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void retrieveAndUpdateTransformMetadata(Transform transform2, StopTransformRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        GetRequest req = new GetRequest(".opendistro-ism-config", transform2.getMetadataId()).routing(transform2.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(this, transform2, request, actionListener){
            final /* synthetic */ TransportStopTransformAction this$0;
            final /* synthetic */ Transform $transform;
            final /* synthetic */ StopTransformRequest $request;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.this$0 = $receiver;
                this.$transform = $transform;
                this.$request = $request;
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull GetResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isExists() || response2.isSourceEmpty()) {
                    TransportStopTransformAction.access$updateTransformJob(this.this$0, this.$transform, this.$request, this.$actionListener);
                } else {
                    TransformMetadata metadata2;
                    TransformMetadata transformMetadata2;
                    BytesReference bytesReference = response2.getSourceAsBytesRef();
                    if (bytesReference != null) {
                        BytesReference it = bytesReference;
                        boolean bl = false;
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)it, (MediaType)((MediaType)XContentType.JSON));
                        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                        transformMetadata2 = (TransformMetadata)OpenSearchExtensionsKt.parseWithType(xcp, string, response2.getSeqNo(), response2.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, TransformMetadata>((Object)TransformMetadata.Companion){

                            @NotNull
                            public final TransformMetadata invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                return ((TransformMetadata.Companion)this.receiver).parse(p0, p1, p2, p3);
                            }
                        });
                    } else {
                        transformMetadata2 = metadata2 = null;
                    }
                    if (metadata2 == null) {
                        TransportStopTransformAction.access$updateTransformJob(this.this$0, this.$transform, this.$request, this.$actionListener);
                    } else {
                        TransportStopTransformAction.access$updateTransformMetadata(this.this$0, this.$transform, metadata2, this.$request, this.$actionListener);
                    }
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private final void updateTransformMetadata(Transform transform2, TransformMetadata metadata2, StopTransformRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        TransformMetadata.Status status;
        long now = Instant.now().toEpochMilli();
        switch (WhenMappings.$EnumSwitchMapping$0[metadata2.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                status = TransformMetadata.Status.STOPPED;
                break;
            }
            case 4: 
            case 5: {
                status = metadata2.getStatus();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TransformMetadata.Status updatedStatus = status;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"status", (Object)updatedStatus.getType()), TuplesKt.to((Object)"last_updated_at", (Object)now)};
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", transform2.getMetadataId()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"transform_metadata", (Object)MapsKt.mapOf((Pair[])pairArray)))).routing(transform2.getId());
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(this, transform2, request, actionListener){
            final /* synthetic */ TransportStopTransformAction this$0;
            final /* synthetic */ Transform $transform;
            final /* synthetic */ StopTransformRequest $request;
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.this$0 = $receiver;
                this.$transform = $transform;
                this.$request = $request;
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull UpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.getResult() == DocWriteResponse.Result.UPDATED) {
                    TransportStopTransformAction.access$updateTransformJob(this.this$0, this.$transform, this.$request, this.$actionListener);
                } else {
                    this.$actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private final void updateTransformJob(Transform transform2, StopTransformRequest request, ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"enabled", (Object)false), TuplesKt.to((Object)"enabled_at", null), TuplesKt.to((Object)"updated_at", (Object)now)};
        ((UpdateRequest)request.index(".opendistro-ism-config")).setIfSeqNo(transform2.getSeqNo()).setIfPrimaryTerm(transform2.getPrimaryTerm()).doc(MapsKt.mapOf((Pair)TuplesKt.to((Object)"transform", (Object)MapsKt.mapOf((Pair[])pairArray))));
        this.client.update((UpdateRequest)request, (ActionListener)new ActionListener<UpdateResponse>(actionListener){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
            {
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull UpdateResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)new AcknowledgedResponse(response2.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                this.$actionListener.onFailure((Exception)throwable);
            }
        });
    }

    private static final void _init_$lambda$0(TransportStopTransformAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ void access$updateTransformJob(TransportStopTransformAction $this, Transform transform2, StopTransformRequest request, ActionListener actionListener) {
        $this.updateTransformJob(transform2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ void access$updateTransformMetadata(TransportStopTransformAction $this, Transform transform2, TransformMetadata metadata2, StopTransformRequest request, ActionListener actionListener) {
        $this.updateTransformMetadata(transform2, metadata2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportStopTransformAction $this) {
        return $this.filterByEnabled;
    }

    public static final /* synthetic */ void access$retrieveAndUpdateTransformMetadata(TransportStopTransformAction $this, Transform transform2, StopTransformRequest request, ActionListener actionListener) {
        $this.retrieveAndUpdateTransformMetadata(transform2, request, (ActionListener<AcknowledgedResponse>)actionListener);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransformMetadata.Status.values().length];
            try {
                nArray[TransformMetadata.Status.STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.INIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

