/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.opensearch.common.Nullable;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.codec.KNN9120Codec.DerivedSourceStoredFieldsReader;
import org.opensearch.knn.index.codec.KNN9120Codec.DerivedSourceStoredFieldsWriter;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReadersSupplier;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;

public class DerivedSourceStoredFieldsFormat
extends StoredFieldsFormat {
    private final StoredFieldsFormat delegate;
    private final DerivedSourceReadersSupplier derivedSourceReadersSupplier;
    @Nullable
    private final MapperService mapperService;

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext ioContext) throws IOException {
        ArrayList<FieldInfo> derivedVectorFields = null;
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!"true".equals(fieldInfo.attributes().get("knn-derived-source-enabled"))) continue;
            if (derivedVectorFields == null) {
                derivedVectorFields = new ArrayList<FieldInfo>();
            }
            derivedVectorFields.add(fieldInfo);
        }
        if (derivedVectorFields == null || derivedVectorFields.isEmpty()) {
            return this.delegate.fieldsReader(directory, segmentInfo, fieldInfos, ioContext);
        }
        SegmentReadState segmentReadState = new SegmentReadState(directory, segmentInfo, fieldInfos, ioContext);
        DerivedSourceReaders derivedSourceReaders = this.derivedSourceReadersSupplier.getReaders(segmentReadState);
        return new DerivedSourceStoredFieldsReader(this.delegate.fieldsReader(directory, segmentInfo, fieldInfos, ioContext), derivedVectorFields, derivedSourceReaders, segmentReadState);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo segmentInfo, IOContext ioContext) throws IOException {
        StoredFieldsWriter delegateWriter = this.delegate.fieldsWriter(directory, segmentInfo, ioContext);
        if (this.mapperService != null && KNNSettings.isKNNDerivedSourceEnabled(this.mapperService.getIndexSettings().getSettings())) {
            ArrayList<String> vectorFieldTypes = new ArrayList<String>();
            for (MappedFieldType fieldType : this.mapperService.fieldTypes()) {
                if (!(fieldType instanceof KNNVectorFieldType)) continue;
                vectorFieldTypes.add(fieldType.name());
            }
            if (!vectorFieldTypes.isEmpty()) {
                return new DerivedSourceStoredFieldsWriter(delegateWriter, vectorFieldTypes);
            }
        }
        return delegateWriter;
    }

    @Generated
    public DerivedSourceStoredFieldsFormat(StoredFieldsFormat delegate, DerivedSourceReadersSupplier derivedSourceReadersSupplier, MapperService mapperService) {
        this.delegate = delegate;
        this.derivedSourceReadersSupplier = derivedSourceReadersSupplier;
        this.mapperService = mapperService;
    }
}

