/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.qframe;

import java.util.Locale;
import org.apache.lucene.analysis.util.CSVUtil;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;

public class QuantizationConfigParser {
    public static final String SEPARATOR = "=";
    public static final String TYPE_NAME = "type";
    public static final String BINARY_TYPE = "binary";
    public static final String BIT_COUNT_NAME = "bits";

    public static String toCsv(QuantizationConfig quantizationConfig) {
        if (quantizationConfig == null || quantizationConfig == QuantizationConfig.EMPTY || quantizationConfig.getQuantizationType() == null) {
            return "";
        }
        return "type=binary,bits=" + quantizationConfig.getQuantizationType().getId();
    }

    public static QuantizationConfig fromCsv(String csv) {
        if (csv == null || csv.isEmpty()) {
            return QuantizationConfig.EMPTY;
        }
        String[] csvArray = CSVUtil.parse((String)csv);
        if (csvArray.length != 2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid csv for quantization config: \"%s\"", csv));
        }
        String typeValue = QuantizationConfigParser.getValueOrThrow(TYPE_NAME, csvArray[0]);
        if (!typeValue.equals(BINARY_TYPE)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported quantization type: \"%s\"", typeValue));
        }
        String bitsValue = QuantizationConfigParser.getValueOrThrow(BIT_COUNT_NAME, csvArray[1]);
        int bitCount = Integer.parseInt(bitsValue);
        ScalarQuantizationType quantizationType = ScalarQuantizationType.fromId(bitCount);
        return QuantizationConfig.builder().quantizationType(quantizationType).build();
    }

    private static String getValueOrThrow(String expectedKey, String keyValue) {
        String[] keyValueArr = keyValue.split(SEPARATOR);
        if (keyValueArr.length != 2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid csv value for quantization config: \"%s\"", keyValue));
        }
        if (!keyValueArr[0].equals(expectedKey)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected: \"%s\" But got: \"%s\"", expectedKey, keyValue));
        }
        return keyValueArr[1];
    }
}

