/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering.evaluation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tribuo.Prediction;
import org.tribuo.clustering.ClusterID;
import org.tribuo.clustering.evaluation.ClusteringEvaluation;
import org.tribuo.clustering.evaluation.ClusteringMetric;
import org.tribuo.clustering.evaluation.ClusteringMetrics;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.provenance.EvaluationProvenance;

final class ClusteringEvaluationImpl
implements ClusteringEvaluation {
    private final Map<MetricID<ClusterID>, Double> results;
    private final ClusteringMetric.Context context;
    private final EvaluationProvenance provenance;

    ClusteringEvaluationImpl(Map<MetricID<ClusterID>, Double> results, ClusteringMetric.Context context, EvaluationProvenance provenance) {
        this.results = results;
        this.context = context;
        this.provenance = provenance;
    }

    public List<Prediction<ClusterID>> getPredictions() {
        return this.context.getPredictions();
    }

    @Override
    public double normalizedMI() {
        MetricTarget target = new MetricTarget(EvaluationMetric.Average.MICRO);
        return this.get((MetricTarget<ClusterID>)target, ClusteringMetrics.NORMALIZED_MI);
    }

    @Override
    public double adjustedMI() {
        MetricTarget target = new MetricTarget(EvaluationMetric.Average.MICRO);
        return this.get((MetricTarget<ClusterID>)target, ClusteringMetrics.ADJUSTED_MI);
    }

    public Map<MetricID<ClusterID>, Double> asMap() {
        return Collections.unmodifiableMap(this.results);
    }

    public EvaluationProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        return "Clustering Evaluation\nNormalized MI = " + this.normalizedMI() + "\nAdjusted MI = " + this.adjustedMI();
    }

    private double get(MetricTarget<ClusterID> target, ClusteringMetrics metric) {
        return this.get(metric.forTarget(target).getID());
    }
}

