/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.remote.metadata.client.SdkClientDelegate;

public abstract class AbstractSdkClient
implements SdkClientDelegate {
    protected String tenantIdField;
    protected String remoteMetadataType;
    protected String remoteMetadataEndpoint;
    protected String region;
    protected String serviceName;

    @Override
    public void initialize(Map<String, String> metadataSettings) {
        this.tenantIdField = metadataSettings.get("tenant_id");
        this.remoteMetadataType = metadataSettings.get("remote_metadata_type");
        this.remoteMetadataEndpoint = metadataSettings.get("remote_metadata_endpoint");
        this.region = metadataSettings.get("remote_metadata_region");
        this.serviceName = metadataSettings.get("remote_metadata_service_name");
    }

    protected <T> CompletionStage<T> executePrivilegedAsync(PrivilegedAction<T> action, Executor executor) {
        return CompletableFuture.supplyAsync(() -> ThreadContextAccess.doPrivileged((PrivilegedAction)action), executor);
    }
}

