/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.util;

import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public final class TableDataProcessor {
    private static final String COLUMN_KEY_NAME = "\u540d\u79f0";
    private static final String COLUMN_VALUE_NAME = "\u503c";
    private static final String RESP_JSON_RESULT_KEY = "ResultCode";
    private static final String RESP_JSON_CONTENT_KEY = "Content";
    protected static final int RESP_SUCCESS_RESULT = 1;
    private static final Log LOG = LogFactory.getLog(TableDataProcessor.class);

    private TableDataProcessor() {
    }

    public static ColumnData row2col(ArrayList<LinkedHashMap<String, Object>> rowData, String keyword) {
        ColumnData data2 = new ColumnData();
        ArrayList<LinkedHashMap<String, Object>> colData = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<String> colNames = new ArrayList<String>();
        int rowCount = 0;
        int colCount = 0;
        for (LinkedHashMap<String, Object> row : rowData) {
            if (keyword != null) {
                String keyNow = row.remove(keyword).toString();
                colNames.add(keyNow);
            }
            ++rowCount;
            for (Map.Entry<String, Object> element : row.entrySet()) {
                LinkedHashMap<String, Object> colDataItem = new LinkedHashMap<String, Object>();
                colDataItem.put(COLUMN_KEY_NAME, element.getKey());
                colDataItem.put(COLUMN_VALUE_NAME, element.getValue());
                colData.add(colDataItem);
                if (rowCount != 1) continue;
                ++colCount;
            }
        }
        data2.setCount(colCount);
        data2.setData(colData);
        data2.setNames(colNames);
        return data2;
    }

    public static ColumnData multiRow2Col(ArrayList<LinkedHashMap<String, Object>> rowData, String keyword) {
        ColumnData data2 = new ColumnData();
        ArrayList<ArrayList<LinkedHashMap<String, Object>>> tableData = new ArrayList<ArrayList<LinkedHashMap<String, Object>>>();
        ArrayList<String> colNames = new ArrayList<String>();
        int rowCount = 0;
        for (LinkedHashMap<String, Object> row : rowData) {
            if (keyword != null) {
                String keyNow = row.remove(keyword).toString();
                colNames.add(keyNow);
            }
            ++rowCount;
            ArrayList colData = new ArrayList();
            for (Map.Entry<String, Object> element : row.entrySet()) {
                LinkedHashMap<String, Object> colDataItem = new LinkedHashMap<String, Object>();
                colDataItem.put(COLUMN_KEY_NAME, element.getKey());
                colDataItem.put(COLUMN_VALUE_NAME, element.getValue());
                colData.add(colDataItem);
            }
            tableData.add(colData);
        }
        data2.setCount(rowCount);
        data2.setTableData(tableData);
        data2.setNames(colNames);
        return data2;
    }

    public static ColumnData row2col(ArrayList<LinkedHashMap<String, Object>> rowData) {
        return TableDataProcessor.row2col(rowData, null);
    }

    public static ArrayList<LinkedHashMap<String, Object>> parseData(Object respData) {
        LinkedHashMap map;
        int rv;
        ArrayList<LinkedHashMap> data2 = null;
        if (respData instanceof Map && (rv = ((Integer)(map = (LinkedHashMap)respData).get(RESP_JSON_RESULT_KEY)).intValue()) == 1) {
            Object content = map.get(RESP_JSON_CONTENT_KEY);
            if (content instanceof List) {
                data2 = (ArrayList<LinkedHashMap>)content;
            } else if (content instanceof Map) {
                LinkedHashMap contentEle = (LinkedHashMap)content;
                data2 = new ArrayList<LinkedHashMap>();
                data2.add(contentEle);
            }
        }
        return data2;
    }

    public static Object getData(String url, MBeanServerConnection conn) throws Exception {
        Object o = null;
        ObjectName name = new ObjectName("com.alibaba.druid:type=DruidStatService");
        String result2 = (String)conn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
        o = JSONUtils.parse(result2);
        if (LOG.isDebugEnabled()) {
            LOG.debug(o.toString());
        }
        return o;
    }

    public static class ColumnData {
        private ArrayList<String> names;
        private ArrayList<LinkedHashMap<String, Object>> data;
        private ArrayList<ArrayList<LinkedHashMap<String, Object>>> tableData;
        private int count;

        public ArrayList<String> getNames() {
            return this.names;
        }

        public void setNames(ArrayList<String> names) {
            this.names = names;
        }

        public ArrayList<LinkedHashMap<String, Object>> getData() {
            return this.data;
        }

        public void setData(ArrayList<LinkedHashMap<String, Object>> data2) {
            this.data = data2;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public ArrayList<ArrayList<LinkedHashMap<String, Object>>> getTableData() {
            return this.tableData;
        }

        public void setTableData(ArrayList<ArrayList<LinkedHashMap<String, Object>>> tableData) {
            this.tableData = tableData;
        }
    }
}

