/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.emrserverless.model.ApplicationState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String nextToken;
    private Integer maxResults;
    private List<String> states;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListApplicationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public ListApplicationsRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public ListApplicationsRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public ListApplicationsRequest withStates(ApplicationState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (ApplicationState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        return other.getStates() == null || other.getStates().equals(this.getStates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getStates() == null ? 0 : this.getStates().hashCode());
        return hashCode2;
    }

    @Override
    public ListApplicationsRequest clone() {
        return (ListApplicationsRequest)super.clone();
    }
}

