/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.AdditiveValue;
import com.google.uzaygezen.core.Assessment;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.RegionInspector;
import com.google.uzaygezen.core.ranges.Measurable;
import com.google.uzaygezen.core.ranges.Range;
import com.google.uzaygezen.core.ranges.RangeHome;
import com.google.uzaygezen.core.ranges.RangeUtil;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Preconditions;

public class SimpleRegionInspector<F, T, V extends AdditiveValue<V>, R extends Measurable<V>>
implements RegionInspector<F, V> {
    private final List<? extends List<R>> queryRegion;
    private final V minOverlappingContent;
    private final Function<? super R, F> filterFactory;
    private final RangeHome<T, V, R> rangeHome;
    private final V zero;

    public static <F, T, V extends Content<V>, R extends Range<T, V>> SimpleRegionInspector<F, T, V, R> create(List<? extends List<R>> queryRegion, V minOverlappingContent, Function<? super R, F> filterFactory, RangeHome<T, V, R> rangeHome, V zero2) {
        return new SimpleRegionInspector<F, T, V, R>(queryRegion, minOverlappingContent, filterFactory, rangeHome, zero2);
    }

    private SimpleRegionInspector(List<? extends List<R>> queryRegion, V minOverlappingContent, Function<? super R, F> filterFactory, RangeHome<T, V, R> rangeHome, V zero2) {
        Iterator<List<R>> queryRegionIterator = queryRegion.iterator();
        List<R> firstOrthotope = queryRegionIterator.next();
        while (queryRegionIterator.hasNext()) {
            List<R> orthotope = queryRegionIterator.next();
            Preconditions.checkArgument(firstOrthotope.size() == orthotope.size());
        }
        this.queryRegion = queryRegion;
        Preconditions.checkArgument(!minOverlappingContent.isZero(), "minOverlappingContent must be positive but it is %s.", new Object[]{minOverlappingContent});
        this.minOverlappingContent = minOverlappingContent;
        this.filterFactory = filterFactory;
        this.rangeHome = rangeHome;
        this.zero = zero2;
    }

    @Override
    public Assessment<F, V> assess(Pow2LengthBitSetRange indexBitSetRange, List<Pow2LengthBitSetRange> orthotope) {
        assert (indexBitSetRange.getLevel() == Pow2LengthBitSetRange.levelSum(orthotope)) : String.format("rangeLevel=%s but content=%s", indexBitSetRange.getLevel(), Pow2LengthBitSetRange.levelSum(orthotope));
        AdditiveValue commonContent = (AdditiveValue)this.zero.clone();
        RangeUtil.overlapSum(RangeUtil.toOrthotope(orthotope, this.rangeHome), this.queryRegion, this.rangeHome, commonContent);
        Measurable indexRange = (Measurable)this.rangeHome.toRange(indexBitSetRange);
        AdditiveValue rangeLength = (AdditiveValue)indexRange.length();
        int cmp = commonContent.compareTo(rangeLength);
        if (cmp == 0) {
            return Assessment.makeCovered(this.filterFactory.apply((R)indexRange), false, this.zero);
        }
        if (commonContent.equals(this.zero)) {
            return Assessment.makeDisjoint(rangeLength);
        }
        if (rangeLength.compareTo(this.minOverlappingContent) >= 0) {
            return Assessment.makeOverlaps(this.zero);
        }
        return Assessment.makeCovered(this.filterFactory.apply((R)indexRange), true, this.zero);
    }

    @Override
    public int getNumberOfDimensions() {
        return this.queryRegion.get(0).size();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

