/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.mapper;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonMappingProvider
implements MappingProvider {
    private static final Logger logger = LoggerFactory.getLogger(GsonMappingProvider.class);
    private final Callable<Gson> factory;

    public GsonMappingProvider(final Gson gson) {
        this(new Callable<Gson>(){

            @Override
            public Gson call() {
                return gson;
            }
        });
    }

    public GsonMappingProvider(Callable<Gson> factory2) {
        this.factory = factory2;
    }

    public GsonMappingProvider() {
        try {
            Class.forName("com.google.gson.Gson");
            this.factory = new Callable<Gson>(){

                @Override
                public Gson call() {
                    return new Gson();
                }
            };
        }
        catch (ClassNotFoundException e) {
            logger.error("Gson not found on class path. No converters configured.");
            throw new JsonPathException("Gson not found on path", e);
        }
    }

    @Override
    public <T> T map(Object source2, Class<T> targetType, Configuration configuration) {
        if (source2 == null) {
            return null;
        }
        try {
            return this.factory.call().getAdapter(targetType).fromJsonTree((JsonElement)source2);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source2, TypeRef<T> targetType, Configuration configuration) {
        if (source2 == null) {
            return null;
        }
        try {
            return (T)this.factory.call().getAdapter(TypeToken.get(targetType.getType())).fromJsonTree((JsonElement)source2);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

