/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hash;

import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.hash.MurmurHash3;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class MurmurHash3Adaptor {
    private static final long BIT62 = 0x4000000000000000L;
    private static final long MAX_LONG = Long.MAX_VALUE;
    private static final long INT_MASK = Integer.MAX_VALUE;
    private static final long PRIME = 9219741426499971445L;

    private MurmurHash3Adaptor() {
    }

    public static byte[] hashToBytes(long datum, long seed) {
        long[] data2 = new long[]{datum};
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static byte[] hashToBytes(long[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static byte[] hashToBytes(int[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static byte[] hashToBytes(char[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static byte[] hashToBytes(byte[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static byte[] hashToBytes(double datum, long seed) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data2 = new long[]{Double.doubleToLongBits(d)};
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static byte[] hashToBytes(String datum, long seed) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data2 = datum.getBytes(StandardCharsets.UTF_8);
        return MurmurHash3Adaptor.toByteArray(MurmurHash3.hash(data2, seed));
    }

    public static long[] hashToLongs(long datum, long seed) {
        long[] data2 = new long[]{datum};
        return MurmurHash3.hash(data2, seed);
    }

    public static long[] hashToLongs(long[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3.hash(data2, seed);
    }

    public static long[] hashToLongs(int[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3.hash(data2, seed);
    }

    public static long[] hashToLongs(char[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3.hash(data2, seed);
    }

    public static long[] hashToLongs(byte[] data2, long seed) {
        if (data2 == null || data2.length == 0) {
            return null;
        }
        return MurmurHash3.hash(data2, seed);
    }

    public static long[] hashToLongs(double datum, long seed) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data2 = new long[]{Double.doubleToLongBits(d)};
        return MurmurHash3.hash(data2, seed);
    }

    public static long[] hashToLongs(String datum, long seed) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data2 = datum.getBytes(StandardCharsets.UTF_8);
        return MurmurHash3.hash(data2, seed);
    }

    public static int asInt(long[] data2, int n) {
        if (data2 == null || data2.length == 0) {
            throw new SketchesArgumentException("Input is null or empty.");
        }
        return MurmurHash3Adaptor.asInteger(data2, n);
    }

    public static int asInt(int[] data2, int n) {
        if (data2 == null || data2.length == 0) {
            throw new SketchesArgumentException("Input is null or empty.");
        }
        return MurmurHash3Adaptor.asInteger(MurmurHash3Adaptor.toLongArray(data2), n);
    }

    public static int asInt(byte[] data2, int n) {
        if (data2 == null || data2.length == 0) {
            throw new SketchesArgumentException("Input is null or empty.");
        }
        return MurmurHash3Adaptor.asInteger(MurmurHash3Adaptor.toLongArray(data2), n);
    }

    public static int asInt(long datum, int n) {
        long[] data2 = new long[]{datum};
        return MurmurHash3Adaptor.asInteger(data2, n);
    }

    public static int asInt(double datum, int n) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data2 = new long[]{Double.doubleToLongBits(d)};
        return MurmurHash3Adaptor.asInteger(data2, n);
    }

    public static int asInt(String datum, int n) {
        if (datum == null || datum.isEmpty()) {
            throw new SketchesArgumentException("Input is null or empty.");
        }
        byte[] data2 = datum.getBytes(StandardCharsets.UTF_8);
        return MurmurHash3Adaptor.asInteger(MurmurHash3Adaptor.toLongArray(data2), n);
    }

    private static int asInteger(long[] data2, int n) {
        int cnt = 0;
        long seed = 0L;
        if (n < 2) {
            throw new SketchesArgumentException("Given value of n must be &gt; 1.");
        }
        if (n > 0x40000000) {
            while (++cnt < 10000) {
                long[] h2 = MurmurHash3.hash(data2, seed);
                int t2 = (int)(h2[0] & Integer.MAX_VALUE);
                if (t2 < n) {
                    return t2;
                }
                t2 = (int)(h2[0] >>> 33);
                if (t2 < n) {
                    return t2;
                }
                t2 = (int)(h2[1] & Integer.MAX_VALUE);
                if (t2 < n) {
                    return t2;
                }
                t2 = (int)(h2[1] >>> 33);
                if (t2 < n) {
                    return t2;
                }
                seed += 9219741426499971445L;
            }
            throw new SketchesStateException("Internal Error: Failed to find integer &lt; n within 10000 iterations.");
        }
        long mask = MurmurHash3Adaptor.ceilingPowerOf2(n) - 1;
        while (++cnt < 10000) {
            long[] h3 = MurmurHash3.hash(data2, seed);
            int t3 = (int)(h3[0] & mask);
            if (t3 < n) {
                return t3;
            }
            t3 = (int)(h3[0] >>> 33 & mask);
            if (t3 < n) {
                return t3;
            }
            t3 = (int)(h3[1] & mask);
            if (t3 < n) {
                return t3;
            }
            t3 = (int)(h3[1] >>> 33 & mask);
            if (t3 < n) {
                return t3;
            }
            seed += 9219741426499971445L;
        }
        throw new SketchesStateException("Internal Error: Failed to find integer &lt; n within 10000 iterations.");
    }

    public static double asDouble(long[] hash) {
        return (double)(hash[0] >>> 12) * 2.220446049250313E-16;
    }

    public static int modulo(long h0, long h1, int divisor) {
        long d = divisor;
        long modH0 = h0 < 0L ? MurmurHash3Adaptor.addRule(MurmurHash3Adaptor.mulRule(0x4000000000000000L, 2L, d), h0 & Long.MAX_VALUE, d) : h0 % d;
        long modH1 = h1 < 0L ? MurmurHash3Adaptor.addRule(MurmurHash3Adaptor.mulRule(0x4000000000000000L, 2L, d), h1 & Long.MAX_VALUE, d) : h1 % d;
        long modTop = MurmurHash3Adaptor.mulRule(MurmurHash3Adaptor.mulRule(0x4000000000000000L, 4L, d), modH1, d);
        return (int)MurmurHash3Adaptor.addRule(modTop, modH0, d);
    }

    public static int modulo(long[] hash, int divisor) {
        return MurmurHash3Adaptor.modulo(hash[0], hash[1], divisor);
    }

    private static long addRule(long a, long b, long d) {
        return (a % d + b % d) % d;
    }

    private static long mulRule(long a, long b, long d) {
        return a % d * (b % d) % d;
    }

    private static byte[] toByteArray(long[] hash) {
        byte[] bArr = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(bArr);
        bb.putLong(hash[0]);
        bb.putLong(hash[1]);
        return bArr;
    }

    private static long[] toLongArray(byte[] data2) {
        int dataLen = data2.length;
        int longLen = (dataLen + 7) / 8;
        long[] longArr = new long[longLen];
        for (int bi = 0; bi < dataLen; ++bi) {
            int li;
            int n = li = bi / 8;
            longArr[n] = longArr[n] | (long)data2[bi] << bi * 8 % 64;
        }
        return longArr;
    }

    private static long[] toLongArray(int[] data2) {
        int dataLen = data2.length;
        int longLen = (dataLen + 1) / 2;
        long[] longArr = new long[longLen];
        for (int ii = 0; ii < dataLen; ++ii) {
            int li;
            int n = li = ii / 2;
            longArr[n] = longArr[n] | (long)data2[ii] << ii * 32 % 64;
        }
        return longArr;
    }

    private static int ceilingPowerOf2(int n) {
        if (n <= 1) {
            return 1;
        }
        int topPwrOf2 = 0x40000000;
        return n >= 0x40000000 ? 0x40000000 : Integer.highestOneBit(n - 1 << 1);
    }
}

