/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.github.resilience4j.retry.internal.RetryImpl;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Retry {
    public static Retry of(String name, RetryConfig retryConfig) {
        return Retry.of(name, retryConfig, HashMap.empty());
    }

    public static Retry of(String name, RetryConfig retryConfig, Map<String, String> tags) {
        return new RetryImpl(name, retryConfig, tags);
    }

    public static Retry of(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return Retry.of(name, retryConfigSupplier.get(), HashMap.empty());
    }

    public static Retry of(String name, Supplier<RetryConfig> retryConfigSupplier, Map<String, String> tags) {
        return new RetryImpl(name, retryConfigSupplier.get(), tags);
    }

    public static Retry ofDefaults(String name) {
        return Retry.of(name, RetryConfig.ofDefaults(), HashMap.empty());
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(Retry retry, ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            AsyncRetryBlock block = new AsyncRetryBlock(scheduler, retry.asyncContext(), supplier, promise);
            block.run();
            return promise;
        };
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Retry retry, CheckedFunction0<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result2;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result2 = supplier.apply())) {
                    }
                    context.onComplete();
                    return result2;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Retry retry, CheckedRunnable runnable2) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable2.run();
                    context.onComplete();
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Retry retry, CheckedFunction1<T, R> function) {
        return t2 -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result2;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result2 = function.apply(t2))) {
                    }
                    context.onComplete();
                    return result2;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Retry retry, Supplier<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result2;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result2 = supplier.get())) {
                    }
                    context.onComplete();
                    return result2;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <E extends Exception, T> Supplier<Either<E, T>> decorateEitherSupplier(Retry retry, Supplier<Either<E, T>> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                Either result2;
                if ((result2 = (Either)supplier.get()).isRight()) {
                    boolean validationOfResult = context.onResult(result2.get());
                    if (validationOfResult) continue;
                    context.onComplete();
                    return result2;
                }
                Exception exception = (Exception)result2.getLeft();
                try {
                    context.onError((Exception)result2.getLeft());
                }
                catch (Exception e) {
                    return Either.left(exception);
                }
            }
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(Retry retry, Supplier<Try<T>> supplier) {
        return () -> {
            Try result2;
            Context context = retry.context();
            while (true) {
                if ((result2 = (Try)supplier.get()).isSuccess()) {
                    boolean validationOfResult = context.onResult(result2.get());
                    if (validationOfResult) continue;
                    context.onComplete();
                    return result2;
                }
                Throwable cause = result2.getCause();
                if (!(cause instanceof Exception)) break;
                try {
                    context.onError((Exception)result2.getCause());
                }
                catch (Exception e) {
                    return result2;
                }
            }
            return result2;
        };
    }

    public static <T> Callable<T> decorateCallable(Retry retry, Callable<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result2;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result2 = supplier.call())) {
                    }
                    context.onComplete();
                    return result2;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static Runnable decorateRunnable(Retry retry, Runnable runnable2) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable2.run();
                    context.onComplete();
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Retry retry, Function<T, R> function) {
        return t2 -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result2;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result2 = function.apply(t2))) {
                    }
                    context.onComplete();
                    return result2;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public String getName();

    public <T> Context<T> context();

    public <T> AsyncContext<T> asyncContext();

    public RetryConfig getRetryConfig();

    public Map<String, String> getTags();

    public EventPublisher getEventPublisher();

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return Retry.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Retry.decorateSupplier(this, supplier).get();
    }

    default public <E extends Exception, T> Either<E, T> executeEitherSupplier(Supplier<Either<E, T>> supplier) {
        return Retry.decorateEitherSupplier(this, supplier).get();
    }

    default public <T> Try<T> executeTrySupplier(Supplier<Try<T>> supplier) {
        return Retry.decorateTrySupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Retry.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable2) {
        Retry.decorateRunnable(this, runnable2).run();
    }

    default public <T> CompletionStage<T> executeCompletionStage(ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return Retry.decorateCompletionStage(this, scheduler, supplier).get();
    }

    public Metrics getMetrics();

    public static class AsyncRetryBlock<T>
    implements Runnable {
        private final ScheduledExecutorService scheduler;
        private final AsyncContext<T> retryContext;
        private final Supplier<CompletionStage<T>> supplier;
        private final CompletableFuture<T> promise;

        AsyncRetryBlock(ScheduledExecutorService scheduler, AsyncContext<T> retryContext, Supplier<CompletionStage<T>> supplier, CompletableFuture<T> promise) {
            this.scheduler = scheduler;
            this.retryContext = retryContext;
            this.supplier = supplier;
            this.promise = promise;
        }

        @Override
        public void run() {
            CompletionStage<Object> stage = this.supplier.get();
            stage.whenComplete((result2, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof Exception) {
                        this.onError((Exception)throwable);
                    } else {
                        this.promise.completeExceptionally((Throwable)throwable);
                    }
                } else {
                    this.onResult(result2);
                }
            });
        }

        private void onError(Exception t2) {
            long delay = this.retryContext.onError(t2);
            if (delay < 1L) {
                this.promise.completeExceptionally(t2);
            } else {
                this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        private void onResult(T result2) {
            long delay = this.retryContext.onResult(result2);
            if (delay < 1L) {
                this.promise.complete(result2);
                this.retryContext.onComplete();
            } else {
                this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RetryEvent> {
        public EventPublisher onRetry(EventConsumer<RetryOnRetryEvent> var1);

        public EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<RetryOnErrorEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> var1);
    }

    public static interface Context<T> {
        @Deprecated
        public void onSuccess();

        public void onComplete();

        public boolean onResult(T var1);

        public void onError(Exception var1) throws Exception;

        public void onRuntimeError(RuntimeException var1);
    }

    public static interface AsyncContext<T> {
        @Deprecated
        public void onSuccess();

        public void onComplete();

        public long onError(Throwable var1);

        public long onResult(T var1);
    }

    public static interface Metrics {
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt();

        public long getNumberOfFailedCallsWithoutRetryAttempt();

        public long getNumberOfSuccessfulCallsWithRetryAttempt();

        public long getNumberOfFailedCallsWithRetryAttempt();
    }
}

