/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.BuiltInMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected JdbcToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, traits, input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToEnumerableConverter(this.getCluster(), traitSet, JdbcToEnumerableConverter.sole(inputs));
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        if (cost == null) {
            return null;
        }
        return cost.multiplyBy(0.1);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression enumerable;
        Expression calendar_;
        BlockBuilder builder0 = new BlockBuilder(false);
        JdbcRel child = (JdbcRel)this.getInput();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        JdbcConvention jdbcConvention = (JdbcConvention)Objects.requireNonNull(child.getConvention(), () -> "child.getConvention() is null for " + child);
        SqlString sqlString = this.generateSql(jdbcConvention.dialect);
        String sql = sqlString.getSql();
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println("[" + sql + "]");
        }
        Hook.QUERY_PLAN.run(sql);
        Expression sql_ = builder0.append("sql", Expressions.constant(sql));
        int fieldCount = this.getRowType().getFieldCount();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression resultSet_ = Expressions.parameter(16, ResultSet.class, builder.newName("resultSet"));
        SqlDialect.CalendarPolicy calendarPolicy = jdbcConvention.dialect.getCalendarPolicy();
        switch (calendarPolicy) {
            case LOCAL: {
                calendar_ = builder0.append("calendar", Expressions.call(Calendar.class, "getInstance", new Expression[]{JdbcToEnumerableConverter.getTimeZoneExpression(implementor)}));
                break;
            }
            default: {
                calendar_ = null;
            }
        }
        if (fieldCount == 1) {
            ParameterExpression value_ = Expressions.parameter(Object.class, builder.newName("value"));
            builder.add(Expressions.declare(16, value_, null));
            JdbcToEnumerableConverter.generateGet(implementor, physType, builder, resultSet_, 0, value_, calendar_, calendarPolicy);
            builder.add(Expressions.return_(null, value_));
        } else {
            Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(fieldCount)));
            for (int i = 0; i < fieldCount; ++i) {
                JdbcToEnumerableConverter.generateGet(implementor, physType, builder, resultSet_, i, Expressions.arrayIndex(values_, Expressions.constant(i)), calendar_, calendarPolicy);
            }
            builder.add(Expressions.return_(null, values_));
        }
        ParameterExpression e_ = Expressions.parameter(SQLException.class, builder.newName("e"));
        Expression rowBuilderFactory_ = builder0.append("rowBuilderFactory", Expressions.lambda(Expressions.block(Expressions.return_(null, Expressions.lambda(Expressions.block(Expressions.tryCatch((Statement)builder.toBlock(), Expressions.catch_(e_, Expressions.throw_(Expressions.new_(RuntimeException.class, new Expression[]{e_}))))), new ParameterExpression[0]))), resultSet_));
        if (sqlString.getDynamicParameters() != null && !sqlString.getDynamicParameters().isEmpty()) {
            Expression preparedStatementConsumer_ = builder0.append("preparedStatementConsumer", Expressions.call(BuiltInMethod.CREATE_ENRICHER.method, Expressions.newArrayInit(Integer.class, 1, JdbcToEnumerableConverter.toIndexesTableExpression(sqlString)), DataContext.ROOT));
            enumerable = builder0.append("enumerable", Expressions.call(BuiltInMethod.RESULT_SET_ENUMERABLE_OF_PREPARED.method, Schemas.unwrap(jdbcConvention.expression, DataSource.class), sql_, rowBuilderFactory_, preparedStatementConsumer_));
        } else {
            enumerable = builder0.append("enumerable", Expressions.call(BuiltInMethod.RESULT_SET_ENUMERABLE_OF.method, Schemas.unwrap(jdbcConvention.expression, DataSource.class), sql_, rowBuilderFactory_));
        }
        builder0.add(Expressions.statement(Expressions.call(enumerable, BuiltInMethod.RESULT_SET_ENUMERABLE_SET_TIMEOUT.method, DataContext.ROOT)));
        builder0.add(Expressions.return_(null, enumerable));
        return implementor.result(physType, builder0.toBlock());
    }

    private static List<ConstantExpression> toIndexesTableExpression(SqlString sqlString) {
        return Objects.requireNonNull(sqlString.getDynamicParameters(), () -> "sqlString.getDynamicParameters() is null for " + sqlString).stream().map(Expressions::constant).collect(Collectors.toList());
    }

    private static UnaryExpression getTimeZoneExpression(EnumerableRelImplementor implementor) {
        return Expressions.convert_(Expressions.call((Expression)implementor.getRootExpression(), "get", Expressions.constant("timeZone")), TimeZone.class);
    }

    private static void generateGet(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression resultSet_, int i, Expression target, @Nullable Expression calendar_, SqlDialect.CalendarPolicy calendarPolicy) {
        Expression source2;
        Primitive primitive = Primitive.ofBoxOr(physType.fieldClass(i));
        RelDataType fieldType = physType.getRowType().getFieldList().get(i).getType();
        ArrayList<Expression> dateTimeArgs = new ArrayList<Expression>();
        dateTimeArgs.add(Expressions.constant(i + 1));
        SqlTypeName sqlTypeName = fieldType.getSqlTypeName();
        boolean offset = false;
        block0 : switch (calendarPolicy) {
            case LOCAL: {
                Objects.requireNonNull(calendar_, "calendar_");
                dateTimeArgs.add(calendar_);
                break;
            }
            case NULL: {
                break;
            }
            case DIRECT: {
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            case SHIFT: {
                switch (sqlTypeName) {
                    case TIMESTAMP: 
                    case DATE: {
                        offset = true;
                        break block0;
                    }
                }
                break;
            }
        }
        switch (sqlTypeName) {
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                source2 = Expressions.call(JdbcToEnumerableConverter.getMethod(sqlTypeName, fieldType.isNullable(), offset), Expressions.list().append(Expressions.call((Expression)resultSet_, JdbcToEnumerableConverter.getMethod2(sqlTypeName), dateTimeArgs)).appendIf(offset, (MethodCallExpression)((Object)JdbcToEnumerableConverter.getTimeZoneExpression(implementor))));
                break;
            }
            case ARRAY: {
                UnaryExpression x = Expressions.convert_(Expressions.call((Expression)resultSet_, JdbcToEnumerableConverter.jdbcGetMethod(primitive), Expressions.constant(i + 1)), Array.class);
                source2 = Expressions.call(BuiltInMethod.JDBC_ARRAY_TO_LIST.method, x);
                break;
            }
            case NULL: {
                source2 = RexImpTable.NULL_EXPR;
                break;
            }
            default: {
                source2 = Expressions.call((Expression)resultSet_, JdbcToEnumerableConverter.jdbcGetMethod(primitive), Expressions.constant(i + 1));
            }
        }
        builder.add(Expressions.statement(Expressions.assign(target, source2)));
        if (primitive != null) {
            builder.add(Expressions.ifThen(Expressions.call((Expression)resultSet_, "wasNull", new Expression[0]), Expressions.statement(Expressions.assign(target, Expressions.constant(null)))));
        }
    }

    private static Method getMethod(SqlTypeName sqlTypeName, boolean nullable, boolean offset) {
        switch (sqlTypeName) {
            case DATE: {
                return (nullable ? (offset ? BuiltInMethod.DATE_TO_INT_OPTIONAL_OFFSET : BuiltInMethod.DATE_TO_INT_OPTIONAL) : (offset ? BuiltInMethod.DATE_TO_INT_OFFSET : BuiltInMethod.DATE_TO_INT)).method;
            }
            case TIME: {
                return (nullable ? BuiltInMethod.TIME_TO_INT_OPTIONAL : BuiltInMethod.TIME_TO_INT).method;
            }
            case TIMESTAMP: {
                return (nullable ? (offset ? BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL_OFFSET : BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL) : (offset ? BuiltInMethod.TIMESTAMP_TO_LONG_OFFSET : BuiltInMethod.TIMESTAMP_TO_LONG)).method;
            }
        }
        throw new AssertionError((Object)((Object)((Object)sqlTypeName) + ":" + nullable));
    }

    private static Method getMethod2(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case DATE: {
                return BuiltInMethod.RESULT_SET_GET_DATE2.method;
            }
            case TIME: {
                return BuiltInMethod.RESULT_SET_GET_TIME2.method;
            }
            case TIMESTAMP: {
                return BuiltInMethod.RESULT_SET_GET_TIMESTAMP2.method;
            }
        }
        throw new AssertionError((Object)sqlTypeName);
    }

    private static String jdbcGetMethod(@Nullable Primitive primitive) {
        return primitive == null ? "getObject" : "get" + SqlFunctions.initcap(Nullness.castNonNull(primitive.primitiveName));
    }

    private SqlString generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        SqlImplementor.Result result2 = jdbcImplementor.visitRoot(this.getInput());
        return result2.asStatement().toSqlString(dialect);
    }
}

