/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FieldDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final ParameterExpression parameter;
    public final @Nullable Expression initializer;

    public FieldDeclaration(int modifier, ParameterExpression parameter, @Nullable Expression initializer) {
        this.modifier = modifier;
        this.parameter = Objects.requireNonNull(parameter, "parameter");
        this.initializer = initializer;
    }

    @Override
    public MemberDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression initializer = this.initializer == null ? null : this.initializer.accept(shuttle);
        return shuttle.visit(this, initializer);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.parameter.type).append(' ').append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
        writer.append(';');
        writer.newlineAndIndent();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDeclaration that = (FieldDeclaration)o;
        return this.modifier == that.modifier && Objects.equals(this.initializer, that.initializer) && this.parameter.equals(that.parameter);
    }

    public int hashCode() {
        return Objects.hash(this.modifier, this.parameter, this.initializer);
    }
}

