/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.util.Objects;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.GotoExpressionKind;
import org.apache.calcite.linq4j.tree.LabelTarget;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

public class GotoStatement
extends Statement {
    public final GotoExpressionKind kind;
    public final @Nullable LabelTarget labelTarget;
    public final @Nullable Expression expression;

    GotoStatement(GotoExpressionKind kind, @Nullable LabelTarget labelTarget, @Nullable Expression expression) {
        super(ExpressionType.Goto, expression == null ? Void.TYPE : expression.getType());
        this.kind = Objects.requireNonNull(kind, "kind");
        this.labelTarget = labelTarget;
        this.expression = expression;
        switch (kind) {
            case Break: 
            case Continue: {
                Preconditions.checkArgument(expression == null, "for %s, expression must be null", (Object)kind);
                break;
            }
            case Goto: {
                assert (expression == null);
                Objects.requireNonNull(labelTarget, "labelTarget");
                break;
            }
            case Return: 
            case Sequence: {
                Preconditions.checkArgument(labelTarget == null, "for %s, labelTarget must be null", (Object)kind);
                break;
            }
            default: {
                throw new RuntimeException("unexpected: " + (Object)((Object)kind));
            }
        }
    }

    @Override
    public Statement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression1 = this.expression == null ? null : this.expression.accept(shuttle);
        return shuttle.visit(this, expression1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append(this.kind.prefix);
        if (this.labelTarget != null) {
            writer.append(' ').append(this.labelTarget.name);
        }
        if (this.expression != null) {
            if (!this.kind.prefix.isEmpty()) {
                writer.append(' ');
            }
            switch (this.kind) {
                case Sequence: {
                    this.expression.accept(writer, 0, 0);
                    break;
                }
                default: {
                    writer.begin();
                    this.expression.accept(writer, 0, 0);
                    writer.end();
                }
            }
        }
        writer.append(';').newlineAndIndent();
    }

    @Override
    public @Nullable Object evaluate(Evaluator evaluator) {
        switch (this.kind) {
            case Return: 
            case Sequence: {
                return Objects.requireNonNull(this.expression, "expression").evaluate(evaluator);
            }
        }
        throw new AssertionError((Object)"evaluate not implemented");
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GotoStatement that = (GotoStatement)o;
        return Objects.equals(this.expression, that.expression) && this.kind == that.kind && Objects.equals(this.labelTarget, that.labelTarget);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.kind, this.labelTarget, this.expression});
    }
}

