/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.tree.ArrayLengthRecordField;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.PseudoField;
import org.apache.calcite.linq4j.tree.ReflectedPseudoField;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public abstract class Types {
    private Types() {
    }

    public static Type of(Type type2, Type ... typeArguments) {
        if (typeArguments.length == 0) {
            return type2;
        }
        return new ParameterizedTypeImpl(type2, ImmutableList.copyOf(typeArguments), null);
    }

    public static @Nullable Type getElementType(Type type2) {
        if (type2 instanceof ArrayType) {
            return ((ArrayType)type2).getComponentType();
        }
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)type2).getGenericComponentType();
        }
        Class<?> clazz = Types.toClass(type2);
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz) || Iterator.class.isAssignableFrom(clazz) || Enumerator.class.isAssignableFrom(clazz)) {
            if (type2 instanceof ParameterizedType) {
                return ((ParameterizedType)type2).getActualTypeArguments()[0];
            }
            return Object.class;
        }
        return null;
    }

    static Field getField(String fieldName, Class<?> clazz) {
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unknown field '" + fieldName + "' in class " + clazz, e);
        }
    }

    static PseudoField getField(String fieldName, Type type2) {
        if (type2 instanceof RecordType) {
            return Types.getRecordField(fieldName, (RecordType)type2);
        }
        if (type2 instanceof Class && ((Class)type2).isArray()) {
            return Types.getSystemField(fieldName, (Class)type2);
        }
        return Types.field(Types.getField(fieldName, Types.toClass(type2)));
    }

    private static RecordField getRecordField(String fieldName, RecordType type2) {
        for (RecordField field : type2.getRecordFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new RuntimeException("Unknown field '" + fieldName + "' in type " + type2);
    }

    private static RecordField getSystemField(String fieldName, Class<?> clazz) {
        return new ArrayLengthRecordField(fieldName, clazz);
    }

    public static Class<?> toClass(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return Types.toClass(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type2;
            return Types.toClass(typeVariable.getBounds()[0]);
        }
        throw new RuntimeException("unsupported type " + type2);
    }

    public static Class<?>[] toClassArray(Iterable<? extends Expression> arguments2) {
        ArrayList classes2 = new ArrayList();
        for (Expression expression : arguments2) {
            classes2.add(Types.toClass(expression.getType()));
        }
        return classes2.toArray(new Class[0]);
    }

    public static @Nullable Type getComponentType(Type type2) {
        if (type2 instanceof Class) {
            return ((Class)type2).getComponentType();
        }
        if (type2 instanceof ArrayType) {
            return ((ArrayType)type2).getComponentType();
        }
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)type2).getGenericComponentType();
        }
        if (type2 instanceof ParameterizedType) {
            return Types.getComponentType(((ParameterizedType)type2).getRawType());
        }
        if (type2 instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type2;
            return Types.getComponentType(typeVariable.getBounds()[0]);
        }
        return null;
    }

    static Type getComponentTypeN(Type type2) {
        Type componentType;
        while ((componentType = Types.getComponentType(type2)) != null) {
            type2 = componentType;
        }
        return type2;
    }

    public static Type box(Type type2) {
        return Primitive.box(type2);
    }

    public static Type unbox(Type type2) {
        return Primitive.unbox(type2);
    }

    static String className(Type type2) {
        if (type2 instanceof ArrayType) {
            return Types.className(((ArrayType)type2).getComponentType()) + "[]";
        }
        if (!(type2 instanceof Class)) {
            return type2.toString();
        }
        Class clazz = (Class)type2;
        if (clazz.isArray()) {
            return Types.className(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        if (!clazz.isPrimitive() && clazz.getPackage() != null && clazz.getPackage().getName().equals("java.lang")) {
            return className.substring("java.lang.".length());
        }
        return className.replace('$', '.');
    }

    public static boolean isAssignableFrom(Type type0, Type type2) {
        return Types.toClass(type0).isAssignableFrom(Types.toClass(type2));
    }

    public static boolean isArray(Type type2) {
        return Types.toClass(type2).isArray();
    }

    public static Field nthField(int ordinal, Class<?> clazz) {
        return clazz.getFields()[ordinal];
    }

    public static PseudoField nthField(int ordinal, Type clazz) {
        if (clazz instanceof RecordType) {
            RecordType recordType = (RecordType)clazz;
            return recordType.getRecordFields().get(ordinal);
        }
        return Types.field(Types.toClass(clazz).getFields()[ordinal]);
    }

    public static boolean allAssignable(boolean varArgs, Class<?>[] parameterTypes, Class<?>[] argumentTypes) {
        if (varArgs ? argumentTypes.length < parameterTypes.length - 1 : parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            Class<?> parameterType;
            Class<Object> clazz = parameterType = !varArgs || i < parameterTypes.length - 1 ? parameterTypes[i] : Object.class;
            if (Types.assignableFrom(parameterType, argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableFrom(Class<?> parameter, Class<?> argument) {
        return parameter.isAssignableFrom(argument) || parameter.isPrimitive() && argument.isPrimitive() && Objects.requireNonNull(Primitive.of(parameter)).assignableFrom(Objects.requireNonNull(Primitive.of(argument)));
    }

    public static Method lookupMethod(Class<?> clazz, String methodName, Class<?> ... argumentTypes) {
        try {
            return clazz.getMethod(methodName, argumentTypes);
        }
        catch (NoSuchMethodException e) {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName) || !Types.allAssignable(method.isVarArgs(), method.getParameterTypes(), argumentTypes)) continue;
                return method;
            }
            throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
        }
    }

    public static Constructor<?> lookupConstructor(Type type2, Class<?> ... argumentTypes) {
        Constructor<?>[] constructors2;
        Class<?> clazz = Types.toClass(type2);
        for (Constructor<?> constructor : constructors2 = clazz.getDeclaredConstructors()) {
            if (!Types.allAssignable(constructor.isVarArgs(), constructor.getParameterTypes(), argumentTypes)) continue;
            return constructor;
        }
        if (constructors2.length == 0 && argumentTypes.length == 0) {
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new RuntimeException("while resolving constructor in class " + type2 + " with types " + Arrays.toString(argumentTypes));
    }

    public static Field lookupField(Type type2, String name) {
        Class<?> clazz = Types.toClass(type2);
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("while resolving field in class " + type2);
        }
    }

    public static void discard(Object ignored) {
    }

    static Type gcd(Type ... types) {
        if (types.length == 0) {
            return Object.class;
        }
        Type best = types[0];
        Primitive bestPrimitive = Primitive.of(best);
        if (bestPrimitive != null) {
            for (int i = 1; i < types.length; ++i) {
                Primitive primitive = Primitive.of(types[i]);
                if (primitive == null) {
                    return Object.class;
                }
                if (primitive.assignableFrom(bestPrimitive)) {
                    bestPrimitive = primitive;
                    continue;
                }
                if (bestPrimitive.assignableFrom(primitive)) continue;
                if (bestPrimitive == Primitive.CHAR || bestPrimitive == Primitive.BYTE) {
                    bestPrimitive = Primitive.INT;
                    --i;
                    continue;
                }
                return Object.class;
            }
            return Objects.requireNonNull(bestPrimitive.primitiveClass);
        }
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == types[0]) continue;
            return Object.class;
        }
        return types[0];
    }

    public static Expression castIfNecessary(Type returnType, Expression expression) {
        Type type2 = expression.getType();
        if (!Types.needTypeCast(type2, returnType)) {
            return expression;
        }
        if (returnType instanceof Class && Number.class.isAssignableFrom((Class)returnType) && type2 instanceof Class && Number.class.isAssignableFrom((Class)type2)) {
            return Expressions.unbox(expression, Objects.requireNonNull(Primitive.ofBox(returnType)));
        }
        if (Primitive.is(returnType) && !Primitive.is(type2)) {
            return Expressions.unbox((Expression)Expressions.convert_(expression, Types.box(returnType)), Objects.requireNonNull(Primitive.of(returnType)));
        }
        if (!Primitive.is(returnType) && Primitive.is(type2)) {
            return Expressions.convert_(expression, Types.unbox(returnType));
        }
        return Expressions.convert_(expression, returnType);
    }

    public static boolean needTypeCast(Type fromType, Type toType) {
        return !fromType.equals(toType) && !(toType instanceof RecordType) && !Types.isAssignableFrom(toType, fromType);
    }

    public static PseudoField field(Field field) {
        return new ReflectedPseudoField(field);
    }

    static Type arrayType(Type type2, int dimension) {
        for (int i = 0; i < dimension; ++i) {
            type2 = Types.arrayType(type2);
        }
        return type2;
    }

    static Type arrayType(Type type2) {
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            return Array.newInstance(clazz, 0).getClass();
        }
        return new ArrayType(type2);
    }

    public static Type stripGenerics(Type type2) {
        if (type2 instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type2).getGenericComponentType();
            return new ArrayType(Types.stripGenerics(componentType));
        }
        if (type2 instanceof ParameterizedType) {
            return ((ParameterizedType)type2).getRawType();
        }
        return type2;
    }

    public static class MapType
    implements Type {
        private final Type keyType;
        private final boolean keyIsNullable;
        private final Type valueType;
        private final boolean valueIsNullable;

        public MapType(Type keyType, boolean keyIsNullable, Type valueType, boolean valueIsNullable) {
            this.keyType = keyType;
            this.keyIsNullable = keyIsNullable;
            this.valueType = valueType;
            this.valueIsNullable = valueIsNullable;
        }

        public Type getKeyType() {
            return this.keyType;
        }

        public boolean keyIsNullable() {
            return this.keyIsNullable;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public boolean valueIsNullable() {
            return this.valueIsNullable;
        }
    }

    public static class ArrayType
    implements Type {
        private final Type componentType;
        private final boolean componentIsNullable;
        private final long maximumCardinality;

        public ArrayType(Type componentType, boolean componentIsNullable, long maximumCardinality) {
            this.componentType = componentType;
            this.componentIsNullable = componentIsNullable;
            this.maximumCardinality = Math.max(maximumCardinality, -1L);
        }

        public ArrayType(Type componentType) {
            this(componentType, !Primitive.is(componentType), -1L);
        }

        public Type getComponentType() {
            return this.componentType;
        }

        public boolean componentIsNullable() {
            return this.componentIsNullable;
        }

        public long maximumCardinality() {
            return this.maximumCardinality;
        }
    }

    public static interface RecordField
    extends PseudoField {
        public boolean nullable();
    }

    public static interface RecordType
    extends Type {
        public List<RecordField> getRecordFields();

        public String getName();
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final List<Type> typeArguments;
        private final @Nullable Type ownerType;

        ParameterizedTypeImpl(Type rawType, List<Type> typeArguments, @Nullable Type ownerType) {
            this.rawType = Objects.requireNonNull(rawType, "rawType");
            this.typeArguments = ImmutableList.copyOf(typeArguments);
            this.ownerType = ownerType;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(Types.className(this.rawType));
            buf.append("<");
            int i = 0;
            for (Type typeArgument : this.typeArguments) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                buf.append(Types.className(typeArgument));
            }
            buf.append(">");
            return buf.toString();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments.toArray(new Type[0]);
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public @Nullable Type getOwnerType() {
            return this.ownerType;
        }
    }
}

