/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.externalize.RelEnumTypes;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

public abstract class TableModify
extends SingleRel {
    protected final Prepare.CatalogReader catalogReader;
    protected final RelOptTable table;
    private final Operation operation;
    private final @Nullable List<String> updateColumnList;
    private final @Nullable List<RexNode> sourceExpressionList;
    private @MonotonicNonNull RelDataType inputRowType;
    private final boolean flattened;

    protected TableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, Operation operation, @Nullable List<String> updateColumnList, @Nullable List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traitSet, input);
        this.table = table;
        this.catalogReader = catalogReader;
        this.operation = operation;
        this.updateColumnList = updateColumnList;
        this.sourceExpressionList = sourceExpressionList;
        if (operation == Operation.UPDATE) {
            Objects.requireNonNull(updateColumnList, "updateColumnList");
            Objects.requireNonNull(sourceExpressionList, "sourceExpressionList");
            Preconditions.checkArgument(sourceExpressionList.size() == updateColumnList.size());
        } else {
            if (operation == Operation.MERGE) {
                Objects.requireNonNull(updateColumnList, "updateColumnList");
            } else {
                Preconditions.checkArgument(updateColumnList == null);
            }
            Preconditions.checkArgument(sourceExpressionList == null);
        }
        RelOptSchema relOptSchema = table.getRelOptSchema();
        if (relOptSchema != null) {
            cluster.getPlanner().registerSchema(relOptSchema);
        }
        this.flattened = flattened;
    }

    protected TableModify(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getTable("table"), Objects.requireNonNull((Prepare.CatalogReader)input.getTable("table").getRelOptSchema(), "relOptSchema"), input.getInput(), Objects.requireNonNull(input.getEnum("operation", Operation.class), "operation"), input.getStringList("updateColumnList"), input.getExpressionList("sourceExpressionList"), input.getBoolean("flattened", false));
    }

    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    public @Nullable List<String> getUpdateColumnList() {
        return this.updateColumnList;
    }

    public @Nullable List<RexNode> getSourceExpressionList() {
        return this.sourceExpressionList;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isInsert() {
        return this.operation == Operation.INSERT;
    }

    public boolean isUpdate() {
        return this.operation == Operation.UPDATE;
    }

    public boolean isDelete() {
        return this.operation == Operation.DELETE;
    }

    public boolean isMerge() {
        return this.operation == Operation.MERGE;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.INSERT, this.getCluster().getTypeFactory());
    }

    @Override
    public RelDataType getExpectedInputRowType(int ordinalInParent) {
        assert (ordinalInParent == 0);
        if (this.inputRowType != null) {
            return this.inputRowType;
        }
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        RelDataType rowType = this.table.getRowType();
        switch (this.operation) {
            case UPDATE: {
                if (this.updateColumnList == null) {
                    throw new AssertionError((Object)("updateColumnList must not be null for " + (Object)((Object)this.operation)));
                }
                this.inputRowType = typeFactory.createJoinType(rowType, this.getCatalogReader().createTypeFromProjection(rowType, this.updateColumnList));
                break;
            }
            case MERGE: {
                if (this.updateColumnList == null) {
                    throw new AssertionError((Object)("updateColumnList must not be null for " + (Object)((Object)this.operation)));
                }
                this.inputRowType = typeFactory.createJoinType(typeFactory.createJoinType(rowType, rowType), this.getCatalogReader().createTypeFromProjection(rowType, this.updateColumnList));
                break;
            }
            default: {
                this.inputRowType = rowType;
            }
        }
        if (this.flattened) {
            this.inputRowType = SqlTypeUtil.flattenRecordType(typeFactory, this.inputRowType, null);
        }
        return this.inputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName()).item("operation", RelEnumTypes.fromEnum(this.getOperation())).itemIf("updateColumnList", this.updateColumnList, this.updateColumnList != null).itemIf("sourceExpressionList", this.sourceExpressionList, this.sourceExpressionList != null).item("flattened", this.flattened);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        MERGE;

    }
}

