/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.runtime.Automaton;
import org.apache.calcite.runtime.Pattern;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

public class AutomatonBuilder {
    private final Map<String, Integer> symbolIds = new HashMap<String, Integer>();
    private final List<Automaton.State> stateList = new ArrayList<Automaton.State>();
    private final List<Automaton.Transition> transitionList = new ArrayList<Automaton.Transition>();
    private final Automaton.State startState = this.createState();
    private final Automaton.State endState = this.createState();

    AutomatonBuilder add(Pattern pattern) {
        return this.add(pattern, this.startState, this.endState);
    }

    private AutomatonBuilder add(Pattern pattern, Automaton.State fromState, Automaton.State toState) {
        Pattern.AbstractPattern p = (Pattern.AbstractPattern)pattern;
        switch (p.op) {
            case SEQ: {
                Pattern.OpPattern pSeq = (Pattern.OpPattern)p;
                return this.seq(fromState, toState, pSeq.patterns);
            }
            case STAR: {
                Pattern.OpPattern pStar = (Pattern.OpPattern)p;
                return this.star(fromState, toState, (Pattern)pStar.patterns.get(0));
            }
            case PLUS: {
                Pattern.OpPattern pPlus = (Pattern.OpPattern)p;
                return this.plus(fromState, toState, (Pattern)pPlus.patterns.get(0));
            }
            case REPEAT: {
                Pattern.RepeatPattern pRepeat = (Pattern.RepeatPattern)p;
                return this.repeat(fromState, toState, (Pattern)pRepeat.patterns.get(0), pRepeat.minRepeat, pRepeat.maxRepeat);
            }
            case SYMBOL: {
                Pattern.SymbolPattern pSymbol = (Pattern.SymbolPattern)p;
                return this.symbol(fromState, toState, pSymbol.name);
            }
            case OR: {
                Pattern.OpPattern pOr = (Pattern.OpPattern)p;
                return this.or(fromState, toState, (Pattern)pOr.patterns.get(0), (Pattern)pOr.patterns.get(1));
            }
            case OPTIONAL: {
                Pattern.OpPattern pOptional = (Pattern.OpPattern)p;
                return this.optional(fromState, toState, (Pattern)pOptional.patterns.get(0));
            }
        }
        throw new AssertionError((Object)("unknown op " + (Object)((Object)p.op)));
    }

    private Automaton.State createState() {
        Automaton.State state = new Automaton.State(this.stateList.size());
        this.stateList.add(state);
        return state;
    }

    public Automaton build() {
        ImmutableList.Builder symbolTransitions = ImmutableList.builder();
        ImmutableList.Builder epsilonTransitions = ImmutableList.builder();
        for (Automaton.Transition transition : this.transitionList) {
            if (transition instanceof Automaton.SymbolTransition) {
                symbolTransitions.add((Automaton.SymbolTransition)transition);
            }
            if (!(transition instanceof Automaton.EpsilonTransition)) continue;
            epsilonTransitions.add((Automaton.EpsilonTransition)transition);
        }
        ImmutableList<String> symbolNames = this.symbolIds.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        return new Automaton(this.stateList.get(0), this.endState, (ImmutableList<Automaton.SymbolTransition>)symbolTransitions.build(), (ImmutableList<Automaton.EpsilonTransition>)epsilonTransitions.build(), symbolNames);
    }

    AutomatonBuilder symbol(Automaton.State fromState, Automaton.State toState, String name) {
        Objects.requireNonNull(name, "name");
        int symbolId = this.symbolIds.computeIfAbsent(name, k -> this.symbolIds.size());
        this.transitionList.add(new Automaton.SymbolTransition(fromState, toState, symbolId));
        return this;
    }

    AutomatonBuilder seq(Automaton.State fromState, Automaton.State toState, List<Pattern> patterns) {
        Automaton.State prevState = fromState;
        for (int i = 0; i < patterns.size(); ++i) {
            Pattern pattern = patterns.get(i);
            Automaton.State nextState = i == patterns.size() - 1 ? toState : this.createState();
            this.add(pattern, prevState, nextState);
            prevState = nextState;
        }
        return this;
    }

    AutomatonBuilder or(Automaton.State fromState, Automaton.State toState, Pattern left, Pattern right) {
        this.add(left, fromState, toState);
        this.add(right, fromState, toState);
        return this;
    }

    AutomatonBuilder star(Automaton.State fromState, Automaton.State toState, Pattern pattern) {
        Automaton.State beforeState = this.createState();
        Automaton.State afterState = this.createState();
        this.transitionList.add(new Automaton.EpsilonTransition(fromState, beforeState));
        this.add(pattern, beforeState, afterState);
        this.transitionList.add(new Automaton.EpsilonTransition(afterState, beforeState));
        this.transitionList.add(new Automaton.EpsilonTransition(afterState, toState));
        this.transitionList.add(new Automaton.EpsilonTransition(fromState, toState));
        return this;
    }

    AutomatonBuilder plus(Automaton.State fromState, Automaton.State toState, Pattern pattern) {
        Automaton.State beforeState = this.createState();
        Automaton.State afterState = this.createState();
        this.transitionList.add(new Automaton.EpsilonTransition(fromState, beforeState));
        this.add(pattern, beforeState, afterState);
        this.transitionList.add(new Automaton.EpsilonTransition(afterState, beforeState));
        this.transitionList.add(new Automaton.EpsilonTransition(afterState, toState));
        return this;
    }

    AutomatonBuilder repeat(Automaton.State fromState, Automaton.State toState, Pattern pattern, int minRepeat, int maxRepeat) {
        Preconditions.checkArgument(0 <= minRepeat);
        Preconditions.checkArgument(minRepeat <= maxRepeat);
        Preconditions.checkArgument(1 <= maxRepeat);
        Automaton.State prevState = fromState;
        for (int i = 0; i <= maxRepeat; ++i) {
            Automaton.State s2 = this.createState();
            if (i == 0) {
                this.transitionList.add(new Automaton.EpsilonTransition(fromState, s2));
            } else {
                this.add(pattern, prevState, s2);
            }
            if (i >= minRepeat) {
                this.transitionList.add(new Automaton.EpsilonTransition(s2, toState));
            }
            prevState = s2;
        }
        this.transitionList.add(new Automaton.EpsilonTransition(prevState, toState));
        return this;
    }

    private AutomatonBuilder optional(Automaton.State fromState, Automaton.State toState, Pattern pattern) {
        this.add(pattern, fromState, toState);
        this.transitionList.add(new Automaton.EpsilonTransition(fromState, toState));
        return this;
    }
}

