/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.function.Parameter;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.util.ReflectiveVisitDispatcher;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public abstract class ReflectUtil {
    private static final Map<Class, Class> PRIMITIVE_TO_BOXING_MAP;
    private static final Map<Class, Method> PRIMITIVE_TO_BYTE_BUFFER_READ_METHOD;
    private static final Map<Class, Method> PRIMITIVE_TO_BYTE_BUFFER_WRITE_METHOD;

    public static Method getByteBufferReadMethod(Class clazz) {
        assert (clazz.isPrimitive());
        return Nullness.castNonNull(PRIMITIVE_TO_BYTE_BUFFER_READ_METHOD.get(clazz));
    }

    public static Method getByteBufferWriteMethod(Class clazz) {
        assert (clazz.isPrimitive());
        return Nullness.castNonNull(PRIMITIVE_TO_BYTE_BUFFER_WRITE_METHOD.get(clazz));
    }

    public static Class getBoxingClass(Class primitiveClass) {
        assert (primitiveClass.isPrimitive());
        return Nullness.castNonNull(PRIMITIVE_TO_BOXING_MAP.get(primitiveClass));
    }

    public static String getUnqualifiedClassName(Class c) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            return className;
        }
        return className.substring(lastDot + 1);
    }

    public static String getUnmangledMethodName(Class declaringClass, String methodName, Class[] paramTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(declaringClass.getName());
        sb.append(".");
        sb.append(methodName);
        sb.append("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramTypes[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getUnmangledMethodName(Method method) {
        return ReflectUtil.getUnmangledMethodName(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    public static boolean invokeVisitor(ReflectiveVisitor visitor2, Object visitee, Class hierarchyRoot, String visitMethodName) {
        return ReflectUtil.invokeVisitorInternal(visitor2, visitee, hierarchyRoot, visitMethodName);
    }

    private static boolean invokeVisitorInternal(Object visitor2, Object visitee, Class hierarchyRoot, String visitMethodName) {
        Class<?> paramType;
        Class<?> visiteeClass;
        Class<?> visitorClass = visitor2.getClass();
        Method method = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass = visitee.getClass(), visitMethodName);
        if (method == null) {
            return false;
        }
        if (hierarchyRoot != null && !hierarchyRoot.isAssignableFrom(paramType = method.getParameterTypes()[0])) {
            return false;
        }
        try {
            method.invoke(visitor2, visitee);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw Util.throwAsRuntime(Util.causeOrSelf(ex));
        }
        return true;
    }

    public static @Nullable Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName) {
        return ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, Collections.emptyList());
    }

    public static @Nullable Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) {
        Class[] paramTypes = new Class[1 + additionalParameterTypes.size()];
        int iParam = 1;
        for (Class paramType : additionalParameterTypes) {
            paramTypes[iParam++] = paramType;
        }
        HashMap<Class<?>, @Nullable Method> cache = new HashMap();
        return ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, paramTypes, cache);
    }

    private static @Nullable Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName, Class<?>[] paramTypes, Map<Class<?>, @Nullable Method> cache) {
        if (cache.containsKey(visiteeClass)) {
            return cache.get(visiteeClass);
        }
        Method candidateMethod = null;
        paramTypes[0] = visiteeClass;
        try {
            candidateMethod = visitorClass.getMethod(visitMethodName, paramTypes);
            cache.put(visiteeClass, candidateMethod);
            return candidateMethod;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?>[] interfaces;
            Class<?> superClass = visiteeClass.getSuperclass();
            if (superClass != null) {
                candidateMethod = ReflectUtil.lookupVisitMethod(visitorClass, superClass, visitMethodName, paramTypes, cache);
            }
            for (Class<?> anInterface : interfaces = visiteeClass.getInterfaces()) {
                Method method = ReflectUtil.lookupVisitMethod(visitorClass, anInterface, visitMethodName, paramTypes, cache);
                if (method == null) continue;
                if (candidateMethod != null && !method.equals(candidateMethod)) {
                    Class<?> c2;
                    Class<?> c1 = method.getParameterTypes()[0];
                    if (c1.isAssignableFrom(c2 = candidateMethod.getParameterTypes()[0])) continue;
                    if (!c2.isAssignableFrom(c1)) {
                        throw new IllegalArgumentException("dispatch ambiguity between " + candidateMethod + " and " + method);
                    }
                }
                candidateMethod = method;
            }
            cache.put(visiteeClass, candidateMethod);
            return candidateMethod;
        }
    }

    public static <R extends ReflectiveVisitor, E> ReflectiveVisitDispatcher<R, E> createDispatcher(Class<R> visitorBaseClazz, final Class<E> visiteeBaseClazz) {
        assert (ReflectiveVisitor.class.isAssignableFrom(visitorBaseClazz));
        assert (Object.class.isAssignableFrom(visiteeBaseClazz));
        return new ReflectiveVisitDispatcher<R, E>(){
            final Map<List<Object>, @Nullable Method> map = new HashMap<List<Object>, Method>();

            @Override
            public @Nullable Method lookupVisitMethod(Class<? extends R> visitorClass, Class<? extends E> visiteeClass, String visitMethodName) {
                return this.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, Collections.emptyList());
            }

            @Override
            public synchronized @Nullable Method lookupVisitMethod(Class<? extends R> visitorClass, Class<? extends E> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) {
                ImmutableList<List<Class>> key = ImmutableList.of(visitorClass, visiteeClass, visitMethodName, additionalParameterTypes);
                Method method = this.map.get(key);
                if (method == null && !this.map.containsKey(key)) {
                    method = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, additionalParameterTypes);
                    this.map.put(key, method);
                }
                return method;
            }

            @Override
            public boolean invokeVisitor(R visitor2, E visitee, String visitMethodName) {
                return ReflectUtil.invokeVisitor(visitor2, visitee, visiteeBaseClazz, visitMethodName);
            }
        };
    }

    public static <E, T> MethodDispatcher<T> createMethodDispatcher(final Class<T> returnClazz, final ReflectiveVisitor visitor2, final String methodName, final Class<E> arg0Clazz, Class ... otherArgClasses) {
        final ImmutableList<Class> otherArgClassList = ImmutableList.copyOf(otherArgClasses);
        final ReflectiveVisitDispatcher<?, E> dispatcher = ReflectUtil.createDispatcher(visitor2.getClass(), arg0Clazz);
        return new MethodDispatcher<T>(){

            @Override
            public T invoke(Object ... args2) {
                Method method = this.lookupMethod(Nullness.castNonNull(args2[0]));
                try {
                    Object o = Nullness.castNonNull(method.invoke((Object)visitor2, args2));
                    return returnClazz.cast(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("While invoking method '" + method + "'", e);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    if (target instanceof RuntimeException) {
                        throw (RuntimeException)target;
                    }
                    if (target instanceof Error) {
                        throw (Error)target;
                    }
                    throw new RuntimeException("While invoking method '" + method + "'", e);
                }
            }

            private Method lookupMethod(Object arg0) {
                if (!arg0Clazz.isInstance(arg0)) {
                    throw new IllegalArgumentException();
                }
                Method method = dispatcher.lookupVisitMethod(visitor2.getClass(), arg0.getClass(), methodName, otherArgClassList);
                if (method == null) {
                    ArrayList<Class> classList = new ArrayList<Class>();
                    classList.add(arg0Clazz);
                    classList.addAll(otherArgClassList);
                    throw new IllegalArgumentException("Method not found: " + methodName + "(" + classList + ")");
                }
                return method;
            }
        };
    }

    public static String getParameterName(Method method, int i) {
        for (Annotation annotation : method.getParameterAnnotations()[i]) {
            if (annotation.annotationType() != Parameter.class) continue;
            return ((Parameter)annotation).name();
        }
        return method.getParameters()[i].getName();
    }

    public static boolean isParameterOptional(Method method, int i) {
        for (Annotation annotation : method.getParameterAnnotations()[i]) {
            if (annotation.annotationType() != Parameter.class) continue;
            return ((Parameter)annotation).optional();
        }
        return false;
    }

    public static boolean mightBeAssignableFrom(Class<?> parameterType, Class<?> argumentType) {
        if (parameterType == argumentType) {
            return true;
        }
        if (Primitive.is(argumentType)) {
            return false;
        }
        if (!parameterType.isInterface() && Modifier.isFinal(parameterType.getModifiers())) {
            return argumentType.isAssignableFrom(parameterType);
        }
        if (!argumentType.isInterface() && Modifier.isFinal(argumentType.getModifiers())) {
            return parameterType.isAssignableFrom(argumentType);
        }
        return true;
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    static {
        Method[] methods2;
        PRIMITIVE_TO_BOXING_MAP = new HashMap<Class, Class>();
        PRIMITIVE_TO_BOXING_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_BOXING_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_BOXING_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_BOXING_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_BOXING_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_BOXING_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_BOXING_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_BOXING_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_BYTE_BUFFER_READ_METHOD = new HashMap<Class, Method>();
        PRIMITIVE_TO_BYTE_BUFFER_WRITE_METHOD = new HashMap<Class, Method>();
        for (Method method : methods2 = ByteBuffer.class.getDeclaredMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (method.getName().startsWith("get")) {
                if (!method.getReturnType().isPrimitive() || paramTypes.length != 1) continue;
                PRIMITIVE_TO_BYTE_BUFFER_READ_METHOD.put(method.getReturnType(), method);
                if (!method.getReturnType().equals(Byte.TYPE)) continue;
                PRIMITIVE_TO_BYTE_BUFFER_READ_METHOD.put(Boolean.TYPE, method);
                continue;
            }
            if (!method.getName().startsWith("put") || paramTypes.length != 2 || !paramTypes[1].isPrimitive()) continue;
            PRIMITIVE_TO_BYTE_BUFFER_WRITE_METHOD.put(paramTypes[1], method);
            if (!paramTypes[1].equals(Byte.TYPE)) continue;
            PRIMITIVE_TO_BYTE_BUFFER_WRITE_METHOD.put(Boolean.TYPE, method);
        }
    }

    public static interface MethodDispatcher<T> {
        public T invoke(Object ... var1);
    }
}

