/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.mapping;

import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.collect.Ordering;

public class IntPair {
    @Deprecated
    public static final Function<IntPair, IntPair> SWAP = new Function<IntPair, IntPair>(){

        @Override
        public IntPair apply(IntPair pair) {
            return IntPair.of(pair.target, pair.source);
        }
    };
    public static final Ordering<IntPair> ORDERING = Ordering.from(new Comparator<IntPair>(){

        @Override
        public int compare(IntPair o1, IntPair o2) {
            int c = Integer.compare(o1.source, o2.source);
            if (c == 0) {
                c = Integer.compare(o1.target, o2.target);
            }
            return c;
        }
    });
    @Deprecated
    public static final Function<IntPair, Integer> LEFT = new Function<IntPair, Integer>(){

        @Override
        public Integer apply(IntPair pair) {
            return pair.source;
        }
    };
    @Deprecated
    public static final Function<IntPair, Integer> RIGHT = new Function<IntPair, Integer>(){

        @Override
        public Integer apply(IntPair pair) {
            return pair.target;
        }
    };
    public final int source;
    public final int target;

    public IntPair(int source2, int target) {
        this.source = source2;
        this.target = target;
    }

    public static IntPair of(int left, int right) {
        return new IntPair(left, right);
    }

    public String toString() {
        return this.source + "-" + this.target;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof IntPair) {
            IntPair that = (IntPair)obj;
            return this.source == that.source && this.target == that.target;
        }
        return false;
    }

    public int hashCode() {
        return Utilities.hash(this.source, this.target);
    }

    public static List<IntPair> zip(List<? extends Number> lefts, List<? extends Number> rights) {
        return IntPair.zip(lefts, rights, false);
    }

    public static List<IntPair> zip(final List<? extends Number> lefts, final List<? extends Number> rights, boolean strict) {
        int size;
        if (strict) {
            if (lefts.size() != rights.size()) {
                throw new AssertionError();
            }
            size = lefts.size();
        } else {
            size = Math.min(lefts.size(), rights.size());
        }
        return new AbstractList<IntPair>(){

            @Override
            public IntPair get(int index) {
                return IntPair.of(((Number)lefts.get(index)).intValue(), ((Number)rights.get(index)).intValue());
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static List<Integer> left(List<IntPair> pairs) {
        return Util.transform(pairs, x -> x.source);
    }

    public static List<Integer> right(List<IntPair> pairs) {
        return Util.transform(pairs, x -> x.target);
    }
}

