/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.util.reflect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import org.codehaus.commons.nullanalysis.Nullable;

public class ByteArrayClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classes;
    private Map<String, byte[]> resources = Collections.emptyMap();

    public ByteArrayClassLoader(Map<String, byte[]> classes2) {
        this.classes = classes2;
    }

    public ByteArrayClassLoader(Map<String, byte[]> classes2, ClassLoader parent) {
        super(parent);
        this.classes = classes2;
    }

    public void setResources(Map<String, byte[]> resources) {
        this.resources = resources;
    }

    @Override
    protected Class<?> findClass(@Nullable String name) throws ClassNotFoundException {
        ProtectionDomain protectionDomain;
        assert (name != null);
        byte[] data2 = this.classes.get(name);
        if (data2 == null && (data2 = this.classes.get(name.replace('.', '/') + ".class")) == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            protectionDomain = this.getClass().getProtectionDomain();
        }
        catch (AccessControlException ace) {
            protectionDomain = null;
        }
        return super.defineClass(name, data2, 0, data2.length, protectionDomain);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream result2 = super.getResourceAsStream(name);
        if (result2 != null) {
            return result2;
        }
        byte[] ba = this.resources.get(name);
        return ba == null ? null : new ByteArrayInputStream(ba);
    }
}

